/*
 * Copyright (c) 2013 ICM Uniwersytet Warszawski All rights reserved.
 * See LICENCE.txt file for licensing information.
 */
package pl.edu.icm.unity.unicore.samlidp.web;

import java.util.AbstractMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import pl.edu.icm.unity.engine.api.endpoint.EndpointFactory;
import pl.edu.icm.unity.engine.api.endpoint.EndpointInstance;
import pl.edu.icm.unity.saml.idp.web.SamlAuthVaadinEndpoint;
import pl.edu.icm.unity.types.endpoint.EndpointTypeDescription;
import pl.edu.icm.unity.webui.authn.VaadinAuthentication;

/**
 * Factory creating {@link SamlAuthVaadinEndpoint} endpoints with the UNICORE
 * specific UI.
 * 
 * @author K. Benedyczak
 */
@Component
public class SamlUnicoreIdPWebEndpointFactory implements EndpointFactory
{
	public static final String NAME = "SAMLUnicoreWebIdP";

	public static final EndpointTypeDescription TYPE = new EndpointTypeDescription(NAME,
			"SAML 2 UNICORE identity provider web endpoint", VaadinAuthentication.NAME,
			Stream.of(new AbstractMap.SimpleEntry<>(SamlAuthETDVaadinEndpoint.SAML_CONSUMER_SERVLET_PATH,
					"SAML 2 UNICORE identity provider web endpoint"),
					new AbstractMap.SimpleEntry<>(SamlAuthVaadinEndpoint.SAML_META_SERVLET_PATH,
							"Metadata of the SAML 2 identity provider web endpoint"),
					new AbstractMap.SimpleEntry<>(
							SamlAuthVaadinEndpoint.SAML_SLO_ASYNC_SERVLET_PATH,
							"Single Logout web endpoint "
									+ "(supports POST and Redirect bindings)"),
					new AbstractMap.SimpleEntry<>(SamlAuthVaadinEndpoint.SAML_SLO_SOAP_SERVLET_PATH,
							"Single Logout web endpoint (supports SOAP binding)"))
					.collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));

	@Autowired
	private ObjectFactory<SamlAuthETDVaadinEndpoint> factory;

	@Override
	public EndpointTypeDescription getDescription()
	{
		return TYPE;
	}

	@Override
	public EndpointInstance newInstance()
	{
		return factory.getObject();
	}
}
