/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.webelements.layout;

import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.Sizeable;
import com.vaadin.shared.ui.MarginInfo;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Component;
import com.vaadin.ui.CustomComponent;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Layout;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import io.imunity.webelements.menu.left.LeftMenu;
import io.imunity.webelements.menu.top.TopRightMenu;
import io.imunity.webelements.navigation.NavigationHierarchyManager;
import pl.edu.icm.unity.webui.common.Styles;

public class SidebarLayout
extends CustomComponent {
    private HorizontalLayout rootContent;
    private TopRightMenu topRightMenu;
    private LeftMenu leftMenu;

    public SidebarLayout(NavigationHierarchyManager viewMan, Layout naviContent, Component topComponent) {
        this.setSizeFull();
        this.setStyleName(Styles.sidebar.toString());
        this.topRightMenu = new TopRightMenu();
        this.leftMenu = new LeftMenu(viewMan);
        UI ui = UI.getCurrent();
        if (ui.getNavigator() != null) {
            ui.getNavigator().addViewChangeListener((ViewChangeListener)this.leftMenu);
        }
        this.rootContent = new HorizontalLayout();
        this.rootContent.setSizeFull();
        this.rootContent.setMargin(false);
        this.rootContent.setSpacing(false);
        this.rootContent.setStyleName(Styles.rootContent.toString());
        HorizontalLayout headerBar = new HorizontalLayout();
        headerBar.setSpacing(false);
        headerBar.setMargin(new MarginInfo(false, true));
        headerBar.setStyleName(Styles.headerBar.toString());
        headerBar.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        headerBar.setHeightUndefined();
        if (topComponent == null) {
            throw new IllegalArgumentException("Top component cannot be null");
        }
        if (naviContent == null) {
            throw new IllegalArgumentException("Navigation content component cannot be null");
        }
        headerBar.addComponent(topComponent);
        headerBar.setComponentAlignment(topComponent, Alignment.MIDDLE_LEFT);
        headerBar.addComponent((Component)this.topRightMenu);
        headerBar.setComponentAlignment((Component)this.topRightMenu, Alignment.MIDDLE_RIGHT);
        VerticalLayout rightSpace = new VerticalLayout();
        rightSpace.setMargin(false);
        rightSpace.setSpacing(false);
        rightSpace.setSizeFull();
        rightSpace.addComponents(new Component[]{headerBar, naviContent});
        rightSpace.setExpandRatio((Component)naviContent, 1.0f);
        this.rootContent.addComponents(new Component[]{this.leftMenu, rightSpace});
        this.rootContent.setExpandRatio((Component)rightSpace, 1.0f);
        this.setCompositionRoot((Component)this.rootContent);
    }

    public LeftMenu getLeftMenu() {
        return this.leftMenu;
    }

    public TopRightMenu getTopRightMenu() {
        return this.topRightMenu;
    }
}

