/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.webelements.menu;

import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.UI;
import io.imunity.webelements.menu.MenuElement;
import java.io.Serializable;
import pl.edu.icm.unity.webui.common.Styles;

public class MenuButton
extends Button
implements MenuElement {
    private String toolTip;
    private String navigateTo;
    private String id;

    public static MenuButton get(String id) {
        return new MenuButton(id, "");
    }

    public MenuButton(String id, String caption) {
        this.build(id, caption, null, null);
    }

    private void build(String id, String caption, Resource icon, Button.ClickListener clickListener) {
        this.id = id;
        this.withCaption(caption);
        this.withIcon(icon);
        if (clickListener != null) {
            this.withClickListener(clickListener);
        }
        this.setPrimaryStyleName(Styles.menuButton.toString());
    }

    public MenuButton withStyleName(String style) {
        this.addStyleName(style);
        return this;
    }

    public String getToolTip() {
        return this.toolTip;
    }

    public MenuButton setToolTip(String toolTip) {
        this.toolTip = toolTip;
        return this;
    }

    public MenuButton withCaption(String caption) {
        super.setCaption(caption);
        this.removeToolTip();
        this.updateToolTip();
        return this;
    }

    public MenuButton clickable() {
        this.withStyleName(Styles.menuButtonClickable.toString());
        return this;
    }

    public MenuButton withIcon(Resource icon) {
        super.setIcon(icon);
        return this;
    }

    public MenuButton withClickListener(Button.ClickListener clickListener) {
        super.addClickListener(clickListener);
        return this;
    }

    public MenuButton withDescription(String description) {
        super.setDescription(description);
        return this;
    }

    public MenuButton withNavigateTo(String link) {
        this.navigateTo = link;
        return this.withClickListener((Button.ClickListener & Serializable)e -> UI.getCurrent().getNavigator().navigateTo(link));
    }

    private MenuButton updateToolTip() {
        String toolTip = "";
        String caption = this.getCaption();
        if (caption != null && !caption.isEmpty()) {
            toolTip = toolTip + caption;
        }
        if (this.toolTip != null && !this.toolTip.isEmpty()) {
            toolTip = toolTip + "<div class=\"u-toolTip\">" + this.toolTip + "</div>";
        }
        this.setCaption(toolTip);
        return this;
    }

    public MenuButton withToolTip(String toolTip) {
        this.setCaptionAsHtml(true);
        this.removeToolTip();
        this.toolTip = toolTip == null || toolTip.isEmpty() ? null : toolTip;
        this.updateToolTip();
        return this;
    }

    private MenuButton removeToolTip() {
        String caption = this.getCaption();
        if (this.toolTip != null && !this.toolTip.isEmpty() && caption != null && !caption.isEmpty()) {
            this.setCaption(caption.replaceAll("<div class=\"u-toolTip\">" + this.toolTip + "</div>", ""));
        }
        return this;
    }

    private boolean isActive() {
        return this.getStyleName().contains(Styles.menuButtonActive.toString());
    }

    @Override
    public void setActive(boolean active) {
        if (active != this.isActive()) {
            if (active) {
                this.addStyleName(Styles.menuButtonActive.toString());
            } else {
                this.removeStyleName(Styles.menuButtonActive.toString());
            }
        }
    }

    public String getNavigateTo() {
        return this.navigateTo;
    }

    @Override
    public String getMenuElementId() {
        return this.id;
    }
}

