/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.webelements.menu.left;

import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.Sizeable;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CustomComponent;
import com.vaadin.ui.VerticalLayout;
import io.imunity.webelements.menu.MenuButton;
import io.imunity.webelements.menu.MenuElement;
import io.imunity.webelements.menu.MenuElementContainer;
import io.imunity.webelements.menu.left.SubMenu;
import io.imunity.webelements.navigation.NavigationHierarchyManager;
import io.imunity.webelements.navigation.NavigationInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pl.edu.icm.unity.webui.common.Images;
import pl.edu.icm.unity.webui.common.Styles;

public class LeftMenu
extends CustomComponent
implements ViewChangeListener,
MenuElementContainer {
    private NavigationHierarchyManager navMan;
    private VerticalLayout main;
    private Map<String, MenuElement> menuElements;
    private Map<String, MenuElementContainer> menuContainers;
    private Map<String, MenuElement> allElements;
    private List<MenuElement> activatedElements;
    private ToggleMode toggleMode;
    private Button toggleButton;

    public LeftMenu(NavigationHierarchyManager navMan) {
        this.navMan = navMan;
        this.main = new VerticalLayout();
        this.setWidth(250.0f, Sizeable.Unit.PIXELS);
        this.setHeight(100.0f, Sizeable.Unit.PERCENTAGE);
        this.setStyleName(Styles.leftMenu.toString());
        this.main.setMargin(false);
        this.main.setSpacing(false);
        this.setCompositionRoot((Component)this.main);
        this.menuElements = new HashMap<String, MenuElement>();
        this.menuContainers = new HashMap<String, MenuElementContainer>();
        this.allElements = new HashMap<String, MenuElement>();
        this.activatedElements = new ArrayList<MenuElement>();
        this.toggleMode = ToggleMode.NORMAL;
        this.toggleButton = new Button();
        this.toggleButton.setIcon(Images.leftDoubleArrow.getResource());
        this.main.addComponent((Component)this.toggleButton);
        this.toggleButton.addClickListener((Button.ClickListener & Serializable)e -> this.toggleSize());
        this.toggleButton.addStyleName(Styles.vButtonBorderless.toString());
        this.toggleButton.addStyleName("u-left-menu-toggle");
    }

    public LeftMenu toggleSize() {
        if (this.getToggleMode().equals((Object)ToggleMode.NORMAL)) {
            this.setToggleMode(ToggleMode.MINIMAL);
        } else {
            this.setToggleMode(ToggleMode.NORMAL);
        }
        return this;
    }

    public LeftMenu setToggleMode(ToggleMode toggleMode) {
        if (toggleMode != null) {
            switch (toggleMode) {
                case MINIMAL: {
                    this.setWidth(50.0f, Sizeable.Unit.EM);
                    this.toggleButton.setIcon(Images.rightDoubleArrow.getResource());
                    this.getParent().addStyleName(ToggleMode.MINIMAL.name().toLowerCase());
                    break;
                }
                case NORMAL: {
                    this.setWidth(250.0f, Sizeable.Unit.EM);
                    this.toggleButton.setIcon(Images.leftDoubleArrow.getResource());
                    this.getParent().removeStyleName(ToggleMode.MINIMAL.name().toLowerCase());
                }
            }
            this.toggleMode = toggleMode;
        }
        return this;
    }

    public ToggleMode getToggleMode() {
        return this.toggleMode;
    }

    public void addSubContainerElement(MenuElementContainer container) {
        this.menuContainers.put(container.getMenuElementId(), container);
        this.allElements.put(container.getMenuElementId(), container);
        for (MenuElement element : container.getMenuElements()) {
            this.allElements.put(element.getMenuElementId(), element);
        }
        this.main.addComponent((Component)container);
    }

    private void adapt(List<NavigationInfo> path) {
        for (MenuElement activeted : this.activatedElements) {
            activeted.setActive(false);
        }
        this.activatedElements.clear();
        for (MenuElementContainer container : this.menuContainers.values()) {
            container.setActive(false);
        }
        for (NavigationInfo view : path) {
            if (!this.allElements.containsKey(view.id)) continue;
            MenuElement toActive = this.allElements.get(view.id);
            toActive.setActive(true);
            this.activatedElements.add(toActive);
        }
    }

    @Override
    public String getMenuElementId() {
        return super.getId();
    }

    @Override
    public void addMenuElement(MenuElement entry) {
        this.menuElements.put(entry.getMenuElementId(), entry);
        this.allElements.put(entry.getMenuElementId(), entry);
        this.main.addComponent((Component)entry);
    }

    @Override
    public Collection<MenuElement> getMenuElements() {
        return this.menuElements.values();
    }

    public Collection<MenuElementContainer> getSubContainerElements() {
        return this.menuContainers.values();
    }

    public void addNavigationElements(String rootNavElement) {
        for (NavigationInfo child : this.navMan.getChildren(rootNavElement)) {
            if (child.type == NavigationInfo.Type.ViewGroup) {
                SubMenu subMenu = SubMenu.get(child.id).withCaption(this.getCaption(child)).withIcon(child.icon);
                this.buildSubMenu(this.navMan.getChildren(child.id), subMenu);
                this.addSubContainerElement(subMenu);
                continue;
            }
            if (child.type != NavigationInfo.Type.View && child.type != NavigationInfo.Type.DefaultView) continue;
            this.addMenuElement(MenuButton.get(child.id).withCaption(this.getCaption(child)).withNavigateTo(child.id).withIcon(child.icon));
        }
    }

    private void buildSubMenu(List<NavigationInfo> viewChildren, MenuElementContainer menuContainer) {
        for (NavigationInfo child : viewChildren) {
            menuContainer.addMenuElement(MenuButton.get(child.id).withCaption(this.getCaption(child)).withNavigateTo(child.id).withIcon(child.icon));
        }
    }

    String getCaption(NavigationInfo element) {
        return element.shortCaption != null ? element.shortCaption : element.caption;
    }

    public boolean beforeViewChange(ViewChangeListener.ViewChangeEvent event) {
        return true;
    }

    public void afterViewChange(ViewChangeListener.ViewChangeEvent event) {
        this.adapt(this.navMan.getParentPath(event.getViewName()));
    }

    @Override
    public void setActive(boolean active) {
        this.setVisible(active);
    }

    public void setToggleVisible(boolean visible) {
        this.toggleButton.setVisible(visible);
    }

    public static enum ToggleMode {
        NORMAL,
        MINIMAL;

    }
}

