/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.webelements.menu.left;

import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CustomComponent;
import com.vaadin.ui.VerticalLayout;
import io.imunity.webelements.menu.MenuButton;
import io.imunity.webelements.menu.MenuElement;
import io.imunity.webelements.menu.MenuElementContainer;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import pl.edu.icm.unity.webui.common.Images;
import pl.edu.icm.unity.webui.common.Styles;

public class SubMenu
extends CustomComponent
implements MenuElementContainer {
    private MenuButton button;
    private VerticalLayout content;
    private Map<String, MenuElement> menuElements;
    private String id;
    private VerticalLayout main;

    public static SubMenu get(String id) {
        return new SubMenu(id, "");
    }

    public SubMenu(String id, String caption) {
        this.build(id, caption, null);
    }

    public SubMenu(String id, Resource icon) {
        this.build(id, null, icon);
    }

    public SubMenu(String id, String caption, Resource icon) {
        this.build(id, caption, icon);
    }

    private void build(String id, String caption, Resource icon) {
        this.id = id;
        this.main = new VerticalLayout();
        this.button = MenuButton.get(super.getId()).withCaption(caption).withIcon(icon).withToolTip(Images.bottomArrow.getHtml()).withClickListener((Button.ClickListener & Serializable)e -> this.toggle());
        this.content = new VerticalLayout();
        this.content.setStyleName("menucontent");
        this.content.setMargin(false);
        this.content.setSpacing(false);
        this.main.setMargin(false);
        this.main.setSpacing(false);
        this.main.addComponents(new Component[]{this.button, this.content});
        this.setStyleName(Styles.subMenu.toString());
        this.menuElements = new HashMap<String, MenuElement>();
        this.setCompositionRoot((Component)this.main);
    }

    public String getCaption() {
        return this.button.getCaption();
    }

    public MenuButton getButton() {
        return this.button;
    }

    public SubMenu withCaption(String caption) {
        this.button.withCaption(caption);
        return this;
    }

    public SubMenu withIcon(Resource icon) {
        this.button.withIcon(icon);
        return this;
    }

    public SubMenu toggle() {
        if (this.isOpen()) {
            this.close();
        } else {
            this.open();
        }
        return this;
    }

    public SubMenu open() {
        this.addStyleName(Styles.subMenuOpen.toString());
        return this;
    }

    public SubMenu close() {
        this.removeStyleName(Styles.subMenuOpen.toString());
        return this;
    }

    public boolean isOpen() {
        return this.getStyleName().contains(Styles.subMenuOpen.toString());
    }

    @Override
    public void addMenuElement(MenuElement entry) {
        this.menuElements.put(entry.getMenuElementId(), entry);
        this.content.addComponent((Component)entry);
    }

    @Override
    public void setActive(boolean active) {
        if (active) {
            this.open();
        } else {
            this.close();
        }
    }

    @Override
    public Collection<MenuElement> getMenuElements() {
        return this.menuElements.values();
    }

    @Override
    public String getMenuElementId() {
        return this.id;
    }
}

