/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.webelements.navigation;

import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewProvider;
import io.imunity.webelements.navigation.NavigationHierarchyManager;
import io.imunity.webelements.navigation.NavigationInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Autowired;
import pl.edu.icm.unity.base.utils.Log;

public class AppContextViewProvider
implements ViewProvider {
    private static final Logger LOG = Log.getLogger((String)"unity.server.web", AppContextViewProvider.class);
    private Map<String, ObjectFactory<?>> viewFactories = new HashMap();

    @Autowired
    public AppContextViewProvider(NavigationHierarchyManager navMan) {
        for (Map.Entry<String, NavigationInfo> navEntry : navMan.getNavigationInfoMap().entrySet()) {
            this.viewFactories.put(navEntry.getKey(), navEntry.getValue().objectFactory);
        }
    }

    public String getViewName(String viewAndParameters) {
        if (!viewAndParameters.isEmpty()) {
            for (String view : this.viewFactories.keySet().stream().filter(v -> !v.isEmpty()).collect(Collectors.toSet())) {
                if (!this.getViewNameInternal(viewAndParameters).equals(view)) continue;
                return view;
            }
        }
        return viewAndParameters;
    }

    private String getViewNameInternal(String viewAndParameters) {
        if (viewAndParameters.contains("/")) {
            return viewAndParameters.split("/")[0];
        }
        return viewAndParameters;
    }

    public View getView(String viewName) {
        if (viewName != null && this.viewFactories.containsKey(viewName)) {
            try {
                return (View)this.viewFactories.get(viewName).getObject();
            }
            catch (Exception e) {
                LOG.debug("Cannot load view " + viewName, (Throwable)e);
            }
        } else {
            LOG.debug("View " + viewName + " not exits");
        }
        return null;
    }
}

