/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.webelements.navigation;

import io.imunity.webelements.navigation.NavigationInfo;
import io.imunity.webelements.navigation.NavigationInfoProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class NavigationHierarchyManager {
    private Map<String, NavigationInfo> navigationMap;
    private Map<String, List<NavigationInfo>> navigationChildren;

    public NavigationHierarchyManager(Collection<? extends NavigationInfoProvider> providers) {
        this.navigationMap = providers.stream().collect(Collectors.toMap(p -> p.getNavigationInfo().id, p -> p.getNavigationInfo()));
        this.initChildren();
        this.initDefaultView();
    }

    private void initDefaultView() {
        NavigationInfo defaultView = null;
        for (NavigationInfo info : this.navigationMap.values()) {
            if (info.type != NavigationInfo.Type.DefaultView) continue;
            defaultView = info;
        }
        if (defaultView != null) {
            this.navigationMap.put("", defaultView);
        }
    }

    private void initChildren() {
        this.navigationChildren = new HashMap<String, List<NavigationInfo>>();
        for (NavigationInfo view : this.navigationMap.values()) {
            if (view.parent != null) continue;
            this.initChildren(view);
        }
    }

    private void initChildren(NavigationInfo view) {
        List children = this.navigationMap.values().stream().filter(v -> v.parent != null && v.parent.equals(view.id)).collect(Collectors.toList());
        if (!this.navigationChildren.containsKey(view.id)) {
            this.navigationChildren.put(view.id, children);
        }
        for (NavigationInfo child : children) {
            this.initChildren(child);
        }
    }

    public List<NavigationInfo> getParentPath(String viewName) {
        if (viewName != null && this.navigationMap.containsKey(viewName)) {
            List<NavigationInfo> ret = this.getParentRecursive(this.navigationMap.get(viewName), new ArrayList<NavigationInfo>());
            Collections.reverse(ret);
            return this.trimRootGroup(ret);
        }
        return Collections.emptyList();
    }

    private List<NavigationInfo> trimRootGroup(List<NavigationInfo> ret) {
        return ret.size() > 1 ? ret.subList(1, ret.size()) : ret;
    }

    private List<NavigationInfo> getParentRecursive(NavigationInfo viewInfo, List<NavigationInfo> ret) {
        if (viewInfo == null) {
            return ret;
        }
        ret.add(viewInfo);
        if (viewInfo.parent == null) {
            return ret;
        }
        return this.getParentRecursive(this.navigationMap.get(viewInfo.parent), ret);
    }

    public List<NavigationInfo> getChildren(String viewName) {
        if (viewName != null && this.navigationChildren.containsKey(viewName)) {
            List<NavigationInfo> ret = this.navigationChildren.get(viewName);
            ret.sort((c1, c2) -> c1.position - c2.position);
            return ret;
        }
        return Collections.emptyList();
    }

    public Map<String, NavigationInfo> getNavigationInfoMap() {
        return new HashMap<String, NavigationInfo>(this.navigationMap);
    }
}

