/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.webelements.navigation;

import com.vaadin.ui.Component;
import com.vaadin.ui.CustomComponent;
import io.imunity.webelements.menu.MenuButton;
import io.imunity.webelements.navigation.BreadcrumbsComponent;
import io.imunity.webelements.navigation.UnityViewWithSubViews;
import java.util.LinkedList;
import pl.edu.icm.unity.webui.common.webElements.SubViewSwitcher;
import pl.edu.icm.unity.webui.common.webElements.UnitySubView;

public abstract class ViewWithSubViewBase
extends CustomComponent
implements SubViewSwitcher,
UnityViewWithSubViews {
    private LinkedList<UnitySubView> subViews = new LinkedList();
    private Component mainView;
    private BreadcrumbsComponent breadCrumbs = new BreadcrumbsComponent();

    public ViewWithSubViewBase() {
        this.breadCrumbs.setMargin(false);
    }

    protected void setMainView(Component mainView) {
        this.mainView = mainView;
        this.setCompositionRoot(mainView);
    }

    public void exitSubView() {
        this.subViews.pollLast();
        if (this.subViews.isEmpty()) {
            this.setCompositionRoot(this.mainView);
        } else {
            this.setCompositionRoot((Component)this.subViews.getLast());
        }
        this.refreshBreadCrumbs();
    }

    public void goToSubView(UnitySubView subview) {
        this.subViews.add(subview);
        this.setCompositionRoot((Component)subview);
        this.refreshBreadCrumbs();
    }

    protected void refreshBreadCrumbs() {
        this.breadCrumbs.removeAllComponents();
        this.breadCrumbs.addComponent(MenuButton.get(this.getDisplayedName()).withCaption(this.getDisplayedName()));
        for (UnitySubView subView : this.subViews) {
            subView.getBredcrumbs().forEach(b -> {
                this.breadCrumbs.addSeparator();
                this.breadCrumbs.addComponent(MenuButton.get(b).withCaption((String)b));
            });
        }
    }

    protected LinkedList<UnitySubView> getSubViews() {
        return this.subViews;
    }

    @Override
    public BreadcrumbsComponent getBreadcrumbsComponent() {
        return this.breadCrumbs;
    }

    @Override
    public abstract String getDisplayedName();
}

