/*
 * Decompiled with CFR 0.152.
 */
package indigoextras.datatypes;

import indigoextras.datatypes.UpdatePattern$Batch$;
import indigoextras.datatypes.UpdatePattern$Every$;
import indigoextras.datatypes.UpdatePattern$Interleave$;
import scala.Function1;

public interface UpdatePattern {
    public <A, B> B update(A var1, Function1<A, B> var2, B var3, int var4);

    public UpdatePattern step();

    public static final class Batch
    implements UpdatePattern {
        private final int size;
        private final int count;

        public static Batch apply(int n) {
            return UpdatePattern$Batch$.MODULE$.apply(n);
        }

        public Batch(int size, int count) {
            this.size = size;
            this.count = count;
        }

        @Override
        public <A, B> B update(A value, Function1<A, B> f, B b, int position) {
            if ((position / this.size - this.count) % this.size == 0) {
                return (B)f.apply(value);
            }
            return b;
        }

        @Override
        public UpdatePattern step() {
            return new Batch(this.size, (this.count + 1) % this.size);
        }
    }

    public static final class Every
    implements UpdatePattern {
        private final int every;
        private final int count;

        public static Every apply(int n) {
            return UpdatePattern$Every$.MODULE$.apply(n);
        }

        public Every(int every, int count) {
            this.every = every;
            this.count = count;
        }

        @Override
        public <A, B> B update(A value, Function1<A, B> f, B b, int position) {
            if ((position - this.count) % this.every == 0) {
                return (B)f.apply(value);
            }
            return b;
        }

        @Override
        public UpdatePattern step() {
            return new Every(this.every, (this.count + 1) % this.every);
        }
    }

    public static final class Interleave
    implements UpdatePattern {
        private final boolean flip;

        public static Interleave apply() {
            return UpdatePattern$Interleave$.MODULE$.apply();
        }

        public Interleave(boolean flip) {
            this.flip = flip;
        }

        @Override
        public <A, B> B update(A value, Function1<A, B> f, B b, int position) {
            if (position % 2 == 0 ^ this.flip) {
                return (B)f.apply(value);
            }
            return b;
        }

        @Override
        public UpdatePattern step() {
            return new Interleave(!this.flip);
        }
    }
}

