/*
 * Decompiled with CFR 0.152.
 */
package indigoextras.geometry;

import indigoextras.geometry.Vertex;
import indigoextras.geometry.Vertex$;
import java.io.Serializable;
import scala.runtime.ModuleSerializationProxy;

public final class BezierMath$
implements Serializable {
    public static final BezierMath$ MODULE$ = new BezierMath$();

    private BezierMath$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(BezierMath$.class);
    }

    public double linear(double t, double p0, double p1) {
        return (1.0 - t) * p0 + t * p1;
    }

    public Vertex linearWithVertices(double t, Vertex p0, Vertex p1) {
        return Vertex$.MODULE$.apply(this.linear(t, p0.x(), p1.x()), this.linear(t, p0.y(), p1.y()));
    }

    public Vertex linearNormalised(double t, Vertex p0, Vertex p1) {
        return this.linearWithVertices(Math.max(0.0, Math.min(1.0, t)), p0, p1);
    }

    public double quadratic(double t, double p0, double p1, double p2) {
        return Math.pow(1.0 - t, 2.0) * p0 + (double)2 * t * (1.0 - t) * p1 + Math.pow(t, 2.0) * p2;
    }

    public Vertex quadraticWithVertices(double t, Vertex p0, Vertex p1, Vertex p2) {
        return Vertex$.MODULE$.apply(this.quadratic(t, p0.x(), p1.x(), p2.x()), this.quadratic(t, p0.y(), p1.y(), p2.y()));
    }

    public Vertex quadraticNormalised(double t, Vertex p0, Vertex p1, Vertex p2) {
        return this.quadraticWithVertices(Math.max(0.0, Math.min(1.0, t)), p0, p1, p2);
    }

    public double cubic(double t, double p0, double p1, double p2, double p3) {
        return Math.pow(1.0 - t, 3.0) * p0 + (double)3 * t * Math.pow(1.0 - t, 2.0) * p1 + (double)3 * Math.pow(t, 2.0) * (1.0 - t) * p2 + Math.pow(t, 3.0) * p3;
    }

    public Vertex cubicWithVertices(double t, Vertex p0, Vertex p1, Vertex p2, Vertex p3) {
        return Vertex$.MODULE$.apply(this.cubic(t, p0.x(), p1.x(), p2.x(), p3.x()), this.cubic(t, p0.y(), p1.y(), p2.y(), p3.y()));
    }

    public Vertex cubicNormalised(double t, Vertex p0, Vertex p1, Vertex p2, Vertex p3) {
        return this.cubicWithVertices(Math.max(0.0, Math.min(1.0, t)), p0, p1, p2, p3);
    }
}

