/*
 * Decompiled with CFR 0.152.
 */
package indigoextras.geometry;

import indigo.shared.collections.Batch;
import indigo.shared.collections.Batch$;
import indigo.shared.datatypes.Rectangle;
import indigoextras.geometry.BoundingBox;
import indigoextras.geometry.BoundingCircle;
import indigoextras.geometry.LineSegment;
import indigoextras.geometry.LineSegment$;
import indigoextras.geometry.Vertex;
import indigoextras.geometry.Vertex$;
import java.io.Serializable;
import scala.CanEqual;
import scala.Double$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.deriving.Mirror;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class BoundingBox$
implements Mirror.Product,
Serializable {
    private static final BoundingBox zero;
    private static CanEqual derived$CanEqual$lzy1;
    private boolean derived$CanEqualbitmap$1;
    public static final BoundingBox$ MODULE$;

    private BoundingBox$() {
    }

    static {
        MODULE$ = new BoundingBox$();
        zero = MODULE$.apply(0.0, 0.0, 0.0, 0.0);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(BoundingBox$.class);
    }

    public BoundingBox apply(Vertex position, Vertex size) {
        return new BoundingBox(position, size);
    }

    public BoundingBox unapply(BoundingBox x$1) {
        return x$1;
    }

    public String toString() {
        return "BoundingBox";
    }

    public BoundingBox zero() {
        return zero;
    }

    public BoundingBox apply(double x, double y, double width, double height) {
        return this.apply(Vertex$.MODULE$.apply(x, y), Vertex$.MODULE$.apply(width, height));
    }

    public BoundingBox apply(double width, double height) {
        return this.apply(Vertex$.MODULE$.zero(), Vertex$.MODULE$.apply(width, height));
    }

    public BoundingBox apply(Vertex size) {
        return this.apply(Vertex$.MODULE$.zero(), size);
    }

    public BoundingBox fromTwoVertices(Vertex pt1, Vertex pt2) {
        double x = Math.min(pt1.x(), pt2.x());
        double y = Math.min(pt1.y(), pt2.y());
        double w = Math.max(pt1.x(), pt2.x()) - x;
        double h = Math.max(pt1.y(), pt2.y()) - y;
        return this.apply(x, y, w, h);
    }

    public BoundingBox fromVertices(Batch<Vertex> vertices) {
        double margin = 0.001;
        return this.rec$1(margin, vertices.toList(), Double.MAX_VALUE, Double.MAX_VALUE, Double$.MODULE$.MinValue(), Double$.MODULE$.MinValue());
    }

    public BoundingBox fromVertexCloud(Batch<Vertex> vertices) {
        return this.fromVertices(vertices);
    }

    public BoundingBox fromRectangle(Rectangle rectangle) {
        return this.apply(Vertex$.MODULE$.fromPoint(rectangle.position()), Vertex$.MODULE$.apply(rectangle.size().width(), rectangle.size().height()));
    }

    public BoundingBox fromBoundingCircle(BoundingCircle boundingCircle) {
        return boundingCircle.toBoundingBox();
    }

    public Batch<LineSegment> toLineSegments(BoundingBox boundingBox) {
        return Batch$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LineSegment[]{LineSegment$.MODULE$.apply(boundingBox.topLeft(), boundingBox.bottomLeft()), LineSegment$.MODULE$.apply(boundingBox.bottomLeft(), boundingBox.bottomRight()), LineSegment$.MODULE$.apply(boundingBox.bottomRight(), boundingBox.topRight()), LineSegment$.MODULE$.apply(boundingBox.topRight(), boundingBox.topLeft())}));
    }

    public BoundingBox expand(BoundingBox boundingBox, double amount) {
        return this.apply(boundingBox.width() >= 0.0 ? boundingBox.x() - amount : boundingBox.x() + amount, boundingBox.height() >= 0.0 ? boundingBox.y() - amount : boundingBox.y() + amount, boundingBox.width() >= 0.0 ? boundingBox.width() + amount * (double)2 : boundingBox.width() - amount * (double)2, boundingBox.height() >= 0.0 ? boundingBox.height() + amount * (double)2 : boundingBox.height() - amount * (double)2);
    }

    public BoundingBox expandToInclude(BoundingBox a, BoundingBox b) {
        double newX = a.left() < b.left() ? a.left() : b.left();
        double newY = a.top() < b.top() ? a.top() : b.top();
        return this.apply(newX, newY, (a.right() > b.right() ? a.right() : b.right()) - newX, (a.bottom() > b.bottom() ? a.bottom() : b.bottom()) - newY);
    }

    public BoundingBox contract(BoundingBox boundingBox, double amount) {
        return this.apply(boundingBox.width() >= 0.0 ? boundingBox.x() + amount : boundingBox.x() - amount, boundingBox.height() >= 0.0 ? boundingBox.y() + amount : boundingBox.y() - amount, boundingBox.width() >= 0.0 ? boundingBox.width() - amount * (double)2 : boundingBox.width() + amount * (double)2, boundingBox.height() >= 0.0 ? boundingBox.height() - amount * (double)2 : boundingBox.height() + amount * (double)2);
    }

    public boolean encompassing(BoundingBox a, BoundingBox b) {
        return b.x() >= a.x() && b.y() >= a.y() && b.width() + (b.x() - a.x()) <= a.width() && b.height() + (b.y() - a.y()) <= a.height();
    }

    public boolean overlapping(BoundingBox a, BoundingBox b) {
        return Math.abs(a.center().x() - b.center().x()) < a.halfSize().x() + b.halfSize().x() && Math.abs(a.center().y() - b.center().y()) < a.halfSize().y() + b.halfSize().y();
    }

    public boolean lineIntersects(BoundingBox boundingBox, LineSegment line) {
        boolean containsStart = boundingBox.contains(line.start());
        boolean containsEnd = boundingBox.contains(line.end());
        if (containsStart && containsEnd) {
            return false;
        }
        if (!line.toBoundingBox().overlaps(boundingBox)) {
            return false;
        }
        return this.rec$2(line, boundingBox.toLineSegments().toList());
    }

    public Option<Vertex> lineIntersectsAt(BoundingBox boundingBox, LineSegment line) {
        boolean containsStart = boundingBox.contains(line.start());
        boolean containsEnd = boundingBox.contains(line.end());
        if (containsStart && containsEnd) {
            return None$.MODULE$;
        }
        if (!line.toBoundingBox().overlaps(boundingBox)) {
            return None$.MODULE$;
        }
        Vertex outside = !containsStart && !containsEnd ? line.start() : (containsStart ? line.end() : line.start());
        return boundingBox.toLineSegments().flatMap((Function1 & Serializable)ln -> {
            if (ln.isFacingVertex(outside)) {
                Option<Vertex> at = ln.intersectsAt(line);
                if (at.isDefined()) {
                    return Batch$.MODULE$.apply(at.get());
                }
                return Batch$.MODULE$.empty();
            }
            return Batch$.MODULE$.empty();
        }).sortWith((Function2 & Serializable)(a, b) -> a.distanceTo(outside) < b.distanceTo(outside)).headOption();
    }

    public CanEqual<BoundingBox, BoundingBox> derived$CanEqual() {
        if (!this.derived$CanEqualbitmap$1) {
            derived$CanEqual$lzy1 = CanEqual.derived$.MODULE$;
            this.derived$CanEqualbitmap$1 = true;
        }
        return derived$CanEqual$lzy1;
    }

    public BoundingBox fromProduct(Product x$0) {
        return new BoundingBox((Vertex)x$0.productElement(0), (Vertex)x$0.productElement(1));
    }

    private final BoundingBox rec$1(double margin$1, List remaining, double left, double top, double right, double bottom) {
        List list;
        while (true) {
            List ps;
            list = remaining;
            Nil$ nil$ = package$.MODULE$.Nil();
            List list2 = list;
            if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
                return this.apply(left, top, right - left + margin$1, bottom - top + margin$1);
            }
            if (!(list instanceof .colon.colon)) break;
            .colon.colon colon2 = (.colon.colon)list;
            List list3 = colon2.next$access$1();
            Vertex p = (Vertex)colon2.head();
            List list4 = ps = list3;
            double d = Math.min(left, p.x());
            double d2 = Math.min(top, p.y());
            double d3 = Math.max(right, p.x());
            double d4 = Math.max(bottom, p.y());
            remaining = list4;
            left = d;
            top = d2;
            right = d3;
            bottom = d4;
        }
        throw new MatchError((Object)list);
    }

    private final boolean rec$2(LineSegment line$1, List remaining) {
        List list;
        while (true) {
            List xs;
            list = remaining;
            Nil$ nil$ = package$.MODULE$.Nil();
            List list2 = list;
            if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
                return false;
            }
            if (!(list instanceof .colon.colon)) break;
            .colon.colon colon2 = (.colon.colon)list;
            List list3 = colon2.next$access$1();
            LineSegment x = (LineSegment)colon2.head();
            if (x.intersectsAt(line$1).isDefined()) {
                return true;
            }
            remaining = xs = list3;
        }
        throw new MatchError((Object)list);
    }
}

