/*
 * Decompiled with CFR 0.152.
 */
package indigoextras.geometry;

import indigo.shared.collections.Batch;
import indigo.shared.collections.Batch$;
import indigo.shared.datatypes.Rectangle;
import indigo.shared.datatypes.Rectangle$;
import indigo.shared.datatypes.Size$;
import indigo.shared.datatypes.Vector2;
import indigoextras.geometry.BoundingBox$;
import indigoextras.geometry.BoundingCircle;
import indigoextras.geometry.BoundingCircle$;
import indigoextras.geometry.LineSegment;
import indigoextras.geometry.Vertex;
import indigoextras.geometry.Vertex$;
import java.io.Serializable;
import scala.CanEqual;
import scala.Option;
import scala.Product;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class BoundingBox
implements Product,
Serializable {
    private final Vertex position;
    private final Vertex size;
    private double x$lzy1;
    private boolean xbitmap$1;
    private double y$lzy1;
    private boolean ybitmap$1;
    private double width$lzy1;
    private boolean widthbitmap$1;
    private double height$lzy1;
    private boolean heightbitmap$1;
    private double left$lzy1;
    private boolean leftbitmap$1;
    private double right$lzy1;
    private boolean rightbitmap$1;
    private double top$lzy1;
    private boolean topbitmap$1;
    private double bottom$lzy1;
    private boolean bottombitmap$1;
    private double horizontalCenter$lzy1;
    private boolean horizontalCenterbitmap$1;
    private double verticalCenter$lzy1;
    private boolean verticalCenterbitmap$1;
    private Vertex topLeft$lzy1;
    private boolean topLeftbitmap$1;
    private Vertex topRight$lzy1;
    private boolean topRightbitmap$1;
    private Vertex bottomRight$lzy1;
    private boolean bottomRightbitmap$1;
    private Vertex bottomLeft$lzy1;
    private boolean bottomLeftbitmap$1;
    private Vertex center$lzy1;
    private boolean centerbitmap$1;
    private Vertex halfSize$lzy1;
    private boolean halfSizebitmap$1;
    private Batch corners$lzy1;
    private boolean cornersbitmap$1;

    public static BoundingBox apply(double d, double d2) {
        return BoundingBox$.MODULE$.apply(d, d2);
    }

    public static BoundingBox apply(double d, double d2, double d3, double d4) {
        return BoundingBox$.MODULE$.apply(d, d2, d3, d4);
    }

    public static BoundingBox apply(Vertex vertex) {
        return BoundingBox$.MODULE$.apply(vertex);
    }

    public static BoundingBox apply(Vertex vertex, Vertex vertex2) {
        return BoundingBox$.MODULE$.apply(vertex, vertex2);
    }

    public static CanEqual<BoundingBox, BoundingBox> derived$CanEqual() {
        return BoundingBox$.MODULE$.derived$CanEqual();
    }

    public static boolean encompassing(BoundingBox boundingBox, BoundingBox boundingBox2) {
        return BoundingBox$.MODULE$.encompassing(boundingBox, boundingBox2);
    }

    public static BoundingBox fromBoundingCircle(BoundingCircle boundingCircle) {
        return BoundingBox$.MODULE$.fromBoundingCircle(boundingCircle);
    }

    public static BoundingBox fromProduct(Product product) {
        return BoundingBox$.MODULE$.fromProduct(product);
    }

    public static BoundingBox fromRectangle(Rectangle rectangle) {
        return BoundingBox$.MODULE$.fromRectangle(rectangle);
    }

    public static BoundingBox fromTwoVertices(Vertex vertex, Vertex vertex2) {
        return BoundingBox$.MODULE$.fromTwoVertices(vertex, vertex2);
    }

    public static BoundingBox fromVertexCloud(Batch<Vertex> batch) {
        return BoundingBox$.MODULE$.fromVertexCloud(batch);
    }

    public static BoundingBox fromVertices(Batch<Vertex> batch) {
        return BoundingBox$.MODULE$.fromVertices(batch);
    }

    public static boolean overlapping(BoundingBox boundingBox, BoundingBox boundingBox2) {
        return BoundingBox$.MODULE$.overlapping(boundingBox, boundingBox2);
    }

    public static BoundingBox unapply(BoundingBox boundingBox) {
        return BoundingBox$.MODULE$.unapply(boundingBox);
    }

    public static BoundingBox zero() {
        return BoundingBox$.MODULE$.zero();
    }

    public BoundingBox(Vertex position, Vertex size) {
        this.position = position;
        this.size = size;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof BoundingBox)) return false;
        BoundingBox boundingBox = (BoundingBox)object;
        Vertex vertex = this.position();
        Vertex vertex2 = boundingBox.position();
        if (vertex == null) {
            if (vertex2 != null) {
                return false;
            }
        } else if (!((Object)vertex).equals(vertex2)) return false;
        Vertex vertex3 = this.size();
        Vertex vertex4 = boundingBox.size();
        if (vertex3 == null) {
            if (vertex4 == null) return true;
            return false;
        } else {
            if (!((Object)vertex3).equals(vertex4)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof BoundingBox;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "BoundingBox";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        if (1 == n2) {
            return this._2();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "position";
        }
        if (1 == n2) {
            return "size";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Vertex position() {
        return this.position;
    }

    public Vertex size() {
        return this.size;
    }

    public double x() {
        if (!this.xbitmap$1) {
            this.x$lzy1 = this.position().x();
            this.xbitmap$1 = true;
        }
        return this.x$lzy1;
    }

    public double y() {
        if (!this.ybitmap$1) {
            this.y$lzy1 = this.position().y();
            this.ybitmap$1 = true;
        }
        return this.y$lzy1;
    }

    public double width() {
        if (!this.widthbitmap$1) {
            this.width$lzy1 = this.size().x();
            this.widthbitmap$1 = true;
        }
        return this.width$lzy1;
    }

    public double height() {
        if (!this.heightbitmap$1) {
            this.height$lzy1 = this.size().y();
            this.heightbitmap$1 = true;
        }
        return this.height$lzy1;
    }

    public double left() {
        if (!this.leftbitmap$1) {
            this.left$lzy1 = this.width() >= 0.0 ? this.x() : this.x() + this.width();
            this.leftbitmap$1 = true;
        }
        return this.left$lzy1;
    }

    public double right() {
        if (!this.rightbitmap$1) {
            this.right$lzy1 = this.width() >= 0.0 ? this.x() + this.width() : this.x();
            this.rightbitmap$1 = true;
        }
        return this.right$lzy1;
    }

    public double top() {
        if (!this.topbitmap$1) {
            this.top$lzy1 = this.height() >= 0.0 ? this.y() : this.y() + this.height();
            this.topbitmap$1 = true;
        }
        return this.top$lzy1;
    }

    public double bottom() {
        if (!this.bottombitmap$1) {
            this.bottom$lzy1 = this.height() >= 0.0 ? this.y() + this.height() : this.y();
            this.bottombitmap$1 = true;
        }
        return this.bottom$lzy1;
    }

    public double horizontalCenter() {
        if (!this.horizontalCenterbitmap$1) {
            this.horizontalCenter$lzy1 = this.x() + this.width() / (double)2;
            this.horizontalCenterbitmap$1 = true;
        }
        return this.horizontalCenter$lzy1;
    }

    public double verticalCenter() {
        if (!this.verticalCenterbitmap$1) {
            this.verticalCenter$lzy1 = this.y() + this.height() / (double)2;
            this.verticalCenterbitmap$1 = true;
        }
        return this.verticalCenter$lzy1;
    }

    public Vertex topLeft() {
        if (!this.topLeftbitmap$1) {
            this.topLeft$lzy1 = Vertex$.MODULE$.apply(this.left(), this.top());
            this.topLeftbitmap$1 = true;
        }
        return this.topLeft$lzy1;
    }

    public Vertex topRight() {
        if (!this.topRightbitmap$1) {
            this.topRight$lzy1 = Vertex$.MODULE$.apply(this.right(), this.top());
            this.topRightbitmap$1 = true;
        }
        return this.topRight$lzy1;
    }

    public Vertex bottomRight() {
        if (!this.bottomRightbitmap$1) {
            this.bottomRight$lzy1 = Vertex$.MODULE$.apply(this.right(), this.bottom());
            this.bottomRightbitmap$1 = true;
        }
        return this.bottomRight$lzy1;
    }

    public Vertex bottomLeft() {
        if (!this.bottomLeftbitmap$1) {
            this.bottomLeft$lzy1 = Vertex$.MODULE$.apply(this.left(), this.bottom());
            this.bottomLeftbitmap$1 = true;
        }
        return this.bottomLeft$lzy1;
    }

    public Vertex center() {
        if (!this.centerbitmap$1) {
            this.center$lzy1 = Vertex$.MODULE$.apply(this.horizontalCenter(), this.verticalCenter());
            this.centerbitmap$1 = true;
        }
        return this.center$lzy1;
    }

    public Vertex halfSize() {
        if (!this.halfSizebitmap$1) {
            this.halfSize$lzy1 = this.size().$div(2.0).abs();
            this.halfSizebitmap$1 = true;
        }
        return this.halfSize$lzy1;
    }

    public Batch<Vertex> corners() {
        if (!this.cornersbitmap$1) {
            this.corners$lzy1 = Batch$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Vertex[]{this.topLeft(), this.topRight(), this.bottomRight(), this.bottomLeft()}));
            this.cornersbitmap$1 = true;
        }
        return this.corners$lzy1;
    }

    public boolean contains(Vertex vertex) {
        return vertex.x() >= this.left() && vertex.x() < this.right() && vertex.y() >= this.top() && vertex.y() < this.bottom();
    }

    public boolean contains(Vector2 vector) {
        return this.contains(Vertex$.MODULE$.fromVector2(vector));
    }

    public boolean contains(double x, double y) {
        return this.contains(Vertex$.MODULE$.apply(x, y));
    }

    public BoundingBox $plus(BoundingBox rect) {
        return BoundingBox$.MODULE$.apply(this.x() + rect.x(), this.y() + rect.y(), this.width() + rect.width(), this.height() + rect.height());
    }

    public BoundingBox $plus(double d) {
        return BoundingBox$.MODULE$.apply(this.x() + d, this.y() + d, this.width() + d, this.height() + d);
    }

    public BoundingBox $minus(BoundingBox rect) {
        return BoundingBox$.MODULE$.apply(this.x() - rect.x(), this.y() - rect.y(), this.width() - rect.width(), this.height() - rect.height());
    }

    public BoundingBox $minus(double d) {
        return BoundingBox$.MODULE$.apply(this.x() - d, this.y() - d, this.width() - d, this.height() - d);
    }

    public BoundingBox $times(BoundingBox rect) {
        return BoundingBox$.MODULE$.apply(this.x() * rect.x(), this.y() * rect.y(), this.width() * rect.width(), this.height() * rect.height());
    }

    public BoundingBox $times(double d) {
        return BoundingBox$.MODULE$.apply(this.x() * d, this.y() * d, this.width() * d, this.height() * d);
    }

    public BoundingBox $div(BoundingBox rect) {
        return BoundingBox$.MODULE$.apply(this.x() / rect.x(), this.y() / rect.y(), this.width() / rect.width(), this.height() / rect.height());
    }

    public BoundingBox $div(double d) {
        return BoundingBox$.MODULE$.apply(this.x() / d, this.y() / d, this.width() / d, this.height() / d);
    }

    public double sdf(Vertex vertex) {
        Vertex p = vertex.$minus(this.center());
        Vertex d = p.abs().$minus(this.halfSize());
        return d.max(0.0).length() + Math.min(Math.max(d.x(), d.y()), 0.0);
    }

    public double sdf(Vector2 vector) {
        return this.sdf(Vertex$.MODULE$.fromVector2(vector));
    }

    public double distanceToBoundary(Vertex vertex) {
        return this.sdf(vertex);
    }

    public double distanceToBoundary(Vector2 vector) {
        return this.sdf(Vertex$.MODULE$.fromVector2(vector));
    }

    public BoundingBox expand(double amount) {
        return BoundingBox$.MODULE$.expand(this, amount);
    }

    public BoundingBox expandToInclude(BoundingBox other) {
        return BoundingBox$.MODULE$.expandToInclude(this, other);
    }

    public BoundingBox contract(double amount) {
        return BoundingBox$.MODULE$.contract(this, amount);
    }

    public boolean encompasses(BoundingBox other) {
        return BoundingBox$.MODULE$.encompassing(this, other);
    }

    public boolean overlaps(BoundingBox other) {
        return BoundingBox$.MODULE$.overlapping(this, other);
    }

    public BoundingBox moveBy(Vertex amount) {
        return this.copy(this.position().$plus(amount), this.copy$default$2());
    }

    public BoundingBox moveBy(double x, double y) {
        return this.moveBy(Vertex$.MODULE$.apply(x, y));
    }

    public BoundingBox moveBy(Vector2 amount) {
        return this.moveBy(Vertex$.MODULE$.fromVector2(amount));
    }

    public BoundingBox moveTo(Vertex newPosition) {
        return this.copy(newPosition, this.copy$default$2());
    }

    public BoundingBox moveTo(double x, double y) {
        return this.moveTo(Vertex$.MODULE$.apply(x, y));
    }

    public BoundingBox moveTo(Vector2 newPosition) {
        return this.moveTo(Vertex$.MODULE$.fromVector2(newPosition));
    }

    public BoundingBox resize(Vertex newSize) {
        return this.copy(this.copy$default$1(), newSize);
    }

    public BoundingBox resize(Vector2 newSize) {
        return this.resize(Vertex$.MODULE$.fromVector2(newSize));
    }

    public Rectangle toRectangle() {
        return Rectangle$.MODULE$.apply(this.position().toPoint(), Size$.MODULE$.apply((int)this.size().x(), (int)this.size().y()));
    }

    public BoundingCircle toBoundingCircle() {
        return BoundingCircle$.MODULE$.fromBoundingBox(this);
    }

    public Batch<LineSegment> toLineSegments() {
        return BoundingBox$.MODULE$.toLineSegments(this);
    }

    public boolean lineIntersects(LineSegment line) {
        return BoundingBox$.MODULE$.lineIntersects(this, line);
    }

    public Option<Vertex> lineIntersectsAt(LineSegment line) {
        return BoundingBox$.MODULE$.lineIntersectsAt(this, line);
    }

    public boolean $tilde$eq$eq(BoundingBox other) {
        return this.position().$tilde$eq$eq(other.position()) && this.size().$tilde$eq$eq(other.size());
    }

    public BoundingBox copy(Vertex position, Vertex size) {
        return new BoundingBox(position, size);
    }

    public Vertex copy$default$1() {
        return this.position();
    }

    public Vertex copy$default$2() {
        return this.size();
    }

    public Vertex _1() {
        return this.position();
    }

    public Vertex _2() {
        return this.size();
    }
}

