/*
 * Decompiled with CFR 0.152.
 */
package indigoextras.geometry;

import indigo.shared.collections.Batch;
import indigo.shared.datatypes.Vector2$;
import indigoextras.geometry.BoundingBox;
import indigoextras.geometry.BoundingBox$;
import indigoextras.geometry.BoundingCircle;
import indigoextras.geometry.BoundingCircleLineIntersect;
import indigoextras.geometry.BoundingCircleLineIntersect$One$;
import indigoextras.geometry.BoundingCircleLineIntersect$Zero$;
import indigoextras.geometry.LineSegment;
import indigoextras.geometry.Vertex;
import indigoextras.geometry.Vertex$;
import java.io.Serializable;
import scala.CanEqual;
import scala.Product;
import scala.deriving.Mirror;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class BoundingCircle$
implements Mirror.Product,
Serializable {
    private static final BoundingCircle zero;
    private static CanEqual derived$CanEqual$lzy1;
    private boolean derived$CanEqualbitmap$1;
    public static final BoundingCircle$ MODULE$;

    private BoundingCircle$() {
    }

    static {
        MODULE$ = new BoundingCircle$();
        zero = MODULE$.apply(Vertex$.MODULE$.zero(), 0.0);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(BoundingCircle$.class);
    }

    public BoundingCircle apply(Vertex position, double radius) {
        return new BoundingCircle(position, radius);
    }

    public BoundingCircle unapply(BoundingCircle x$1) {
        return x$1;
    }

    public String toString() {
        return "BoundingCircle";
    }

    public BoundingCircle zero() {
        return zero;
    }

    public BoundingCircle apply(double x, double y, double radius) {
        return this.apply(Vertex$.MODULE$.apply(x, y), radius);
    }

    public BoundingCircle fromTwoVertices(Vertex center, Vertex boundary) {
        return this.apply(center, center.distanceTo(boundary));
    }

    public BoundingCircle fromVertices(Batch<Vertex> vertices) {
        BoundingBox bb = BoundingBox$.MODULE$.fromVertices(vertices);
        return this.apply(bb.center(), bb.center().distanceTo(bb.topLeft()));
    }

    public BoundingCircle fromVertexCloud(Batch<Vertex> vertices) {
        return this.fromVertices(vertices);
    }

    public BoundingCircle fromBoundingBox(BoundingBox boundingBox) {
        return this.apply(boundingBox.center(), Math.max(boundingBox.halfSize().x(), boundingBox.halfSize().y()));
    }

    public BoundingCircle expandToInclude(BoundingCircle a, BoundingCircle b) {
        return a.resize(a.position().distanceTo(b.position()) + Math.abs(b.radius()));
    }

    public boolean encompassing(BoundingCircle a, BoundingCircle b) {
        return a.position().distanceTo(b.position()) <= Math.abs(a.radius()) - Math.abs(b.radius());
    }

    public boolean overlapping(BoundingCircle a, BoundingCircle b) {
        return a.position().distanceTo(b.position()) < Math.abs(a.radius()) + Math.abs(b.radius());
    }

    public boolean lineIntersects(BoundingCircle boundingCircle, LineSegment line) {
        return Math.abs(line.sdf(boundingCircle.position())) <= boundingCircle.radius();
    }

    public BoundingCircleLineIntersect lineIntersectsAt(BoundingCircle boundingCircle, LineSegment line) {
        double r;
        double nearestY;
        double dl;
        double cY;
        double aX = line.start().x();
        double aY = line.start().y();
        double bX = line.end().x();
        double bY = line.end().y();
        double dX = bX - aX;
        double dY = bY - aY;
        if (dX == 0.0 && dY == 0.0) {
            return BoundingCircleLineIntersect$Zero$.MODULE$;
        }
        double cX = boundingCircle.position().x();
        double t = ((cX - aX) * dX + ((cY = boundingCircle.position().y()) - aY) * dY) / (dl = dX * dX + dY * dY);
        double nearestX = aX + t * dX;
        double dist = Vector2$.MODULE$.distance(Vector2$.MODULE$.apply(nearestX, nearestY = aY + t * dY), Vector2$.MODULE$.apply(cX, cY));
        if (dist == (r = boundingCircle.radius())) {
            double iX = nearestX;
            double iY = nearestY;
            return (BoundingCircleLineIntersect)(t < 0.0 || t > 1.0 ? BoundingCircleLineIntersect$Zero$.MODULE$ : BoundingCircleLineIntersect$One$.MODULE$.apply(Vertex$.MODULE$.apply(iX, iY)));
        }
        if (dist < r) {
            double dt = Math.sqrt(r * r - dist * dist) / Math.sqrt(dl);
            double t1 = t - dt;
            double i1X = aX + t1 * dX;
            double i1Y = aY + t1 * dY;
            BoundingCircleLineIntersect near = (BoundingCircleLineIntersect)(t1 < 0.0 || t1 > 1.0 ? BoundingCircleLineIntersect$Zero$.MODULE$ : BoundingCircleLineIntersect$One$.MODULE$.apply(Vertex$.MODULE$.apply(i1X, i1Y)));
            double t2 = t + dt;
            double i2X = aX + t2 * dX;
            double i2Y = aY + t2 * dY;
            BoundingCircleLineIntersect far = (BoundingCircleLineIntersect)(t2 < 0.0 || t2 > 1.0 ? BoundingCircleLineIntersect$Zero$.MODULE$ : BoundingCircleLineIntersect$One$.MODULE$.apply(Vertex$.MODULE$.apply(i2X, i2Y)));
            return near.$bar$plus$bar(far);
        }
        return BoundingCircleLineIntersect$Zero$.MODULE$;
    }

    public double signedDistanceFunction(Vertex point, double radius) {
        return point.length() - radius;
    }

    public CanEqual<BoundingCircle, BoundingCircle> derived$CanEqual() {
        if (!this.derived$CanEqualbitmap$1) {
            derived$CanEqual$lzy1 = CanEqual.derived$.MODULE$;
            this.derived$CanEqualbitmap$1 = true;
        }
        return derived$CanEqual$lzy1;
    }

    public BoundingCircle fromProduct(Product x$0) {
        return new BoundingCircle((Vertex)x$0.productElement(0), BoxesRunTime.unboxToDouble((Object)x$0.productElement(1)));
    }
}

