/*
 * Decompiled with CFR 0.152.
 */
package indigoextras.geometry;

import indigo.shared.collections.Batch;
import indigo.shared.datatypes.Vector2;
import indigoextras.geometry.BoundingBox;
import indigoextras.geometry.BoundingBox$;
import indigoextras.geometry.BoundingCircle$;
import indigoextras.geometry.BoundingCircleLineIntersect;
import indigoextras.geometry.LineSegment;
import indigoextras.geometry.Vertex;
import indigoextras.geometry.Vertex$;
import java.io.Serializable;
import scala.CanEqual;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class BoundingCircle
implements Product,
Serializable {
    private final Vertex position;
    private final double radius;
    private double x$lzy1;
    private boolean xbitmap$1;
    private double y$lzy1;
    private boolean ybitmap$1;
    private double diameter$lzy1;
    private boolean diameterbitmap$1;
    private double left$lzy1;
    private boolean leftbitmap$1;
    private double right$lzy1;
    private boolean rightbitmap$1;
    private double top$lzy1;
    private boolean topbitmap$1;
    private double bottom$lzy1;
    private boolean bottombitmap$1;

    public static BoundingCircle apply(double d, double d2, double d3) {
        return BoundingCircle$.MODULE$.apply(d, d2, d3);
    }

    public static BoundingCircle apply(Vertex vertex, double d) {
        return BoundingCircle$.MODULE$.apply(vertex, d);
    }

    public static CanEqual<BoundingCircle, BoundingCircle> derived$CanEqual() {
        return BoundingCircle$.MODULE$.derived$CanEqual();
    }

    public static boolean encompassing(BoundingCircle boundingCircle, BoundingCircle boundingCircle2) {
        return BoundingCircle$.MODULE$.encompassing(boundingCircle, boundingCircle2);
    }

    public static BoundingCircle fromBoundingBox(BoundingBox boundingBox) {
        return BoundingCircle$.MODULE$.fromBoundingBox(boundingBox);
    }

    public static BoundingCircle fromProduct(Product product) {
        return BoundingCircle$.MODULE$.fromProduct(product);
    }

    public static BoundingCircle fromTwoVertices(Vertex vertex, Vertex vertex2) {
        return BoundingCircle$.MODULE$.fromTwoVertices(vertex, vertex2);
    }

    public static BoundingCircle fromVertexCloud(Batch<Vertex> batch) {
        return BoundingCircle$.MODULE$.fromVertexCloud(batch);
    }

    public static BoundingCircle fromVertices(Batch<Vertex> batch) {
        return BoundingCircle$.MODULE$.fromVertices(batch);
    }

    public static boolean overlapping(BoundingCircle boundingCircle, BoundingCircle boundingCircle2) {
        return BoundingCircle$.MODULE$.overlapping(boundingCircle, boundingCircle2);
    }

    public static double signedDistanceFunction(Vertex vertex, double d) {
        return BoundingCircle$.MODULE$.signedDistanceFunction(vertex, d);
    }

    public static BoundingCircle unapply(BoundingCircle boundingCircle) {
        return BoundingCircle$.MODULE$.unapply(boundingCircle);
    }

    public static BoundingCircle zero() {
        return BoundingCircle$.MODULE$.zero();
    }

    public BoundingCircle(Vertex position, double radius) {
        this.position = position;
        this.radius = radius;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.position()));
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.radius()));
        return Statics.finalizeHash((int)n, (int)2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof BoundingCircle)) return false;
        BoundingCircle boundingCircle = (BoundingCircle)object;
        if (this.radius() != boundingCircle.radius()) return false;
        Vertex vertex = this.position();
        Vertex vertex2 = boundingCircle.position();
        if (vertex != null) {
            if (!((Object)vertex).equals(vertex2)) return false;
            return true;
        }
        if (vertex2 == null) return true;
        return false;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof BoundingCircle;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "BoundingCircle";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        if (1 == n2) {
            return BoxesRunTime.boxToDouble((double)this._2());
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "position";
        }
        if (1 == n2) {
            return "radius";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Vertex position() {
        return this.position;
    }

    public double radius() {
        return this.radius;
    }

    public double x() {
        if (!this.xbitmap$1) {
            this.x$lzy1 = this.position().x();
            this.xbitmap$1 = true;
        }
        return this.x$lzy1;
    }

    public double y() {
        if (!this.ybitmap$1) {
            this.y$lzy1 = this.position().y();
            this.ybitmap$1 = true;
        }
        return this.y$lzy1;
    }

    public double diameter() {
        if (!this.diameterbitmap$1) {
            this.diameter$lzy1 = this.radius() * (double)2;
            this.diameterbitmap$1 = true;
        }
        return this.diameter$lzy1;
    }

    public double left() {
        if (!this.leftbitmap$1) {
            this.left$lzy1 = this.x() - this.radius();
            this.leftbitmap$1 = true;
        }
        return this.left$lzy1;
    }

    public double right() {
        if (!this.rightbitmap$1) {
            this.right$lzy1 = this.x() + this.radius();
            this.rightbitmap$1 = true;
        }
        return this.right$lzy1;
    }

    public double top() {
        if (!this.topbitmap$1) {
            this.top$lzy1 = this.y() - this.radius();
            this.topbitmap$1 = true;
        }
        return this.top$lzy1;
    }

    public double bottom() {
        if (!this.bottombitmap$1) {
            this.bottom$lzy1 = this.y() + this.radius();
            this.bottombitmap$1 = true;
        }
        return this.bottom$lzy1;
    }

    public BoundingBox toBoundingBox() {
        return BoundingBox$.MODULE$.apply(Vertex$.MODULE$.apply(this.left(), this.top()), Vertex$.MODULE$.apply(this.diameter(), this.diameter()));
    }

    public boolean contains(Vertex vertex) {
        return vertex.distanceTo(this.position()) <= this.radius();
    }

    public boolean contains(double x, double y) {
        return this.contains(Vertex$.MODULE$.apply(x, y));
    }

    public boolean contains(Vector2 vector) {
        return this.contains(Vertex$.MODULE$.fromVector2(vector));
    }

    public BoundingCircle $plus(double d) {
        return this.resize(this.radius() + d);
    }

    public BoundingCircle $minus(double d) {
        return this.resize(this.radius() - d);
    }

    public BoundingCircle $times(double d) {
        return this.resize(this.radius() * d);
    }

    public BoundingCircle $div(double d) {
        return this.resize(this.radius() / d);
    }

    public double sdf(Vertex vertex) {
        return BoundingCircle$.MODULE$.signedDistanceFunction(vertex.$minus(this.position()), this.radius());
    }

    public double sdf(Vector2 vector) {
        return this.sdf(Vertex$.MODULE$.fromVector2(vector));
    }

    public double distanceToBoundary(Vertex vertex) {
        return this.sdf(vertex);
    }

    public double distanceToBoundary(Vector2 vector) {
        return this.sdf(Vertex$.MODULE$.fromVector2(vector));
    }

    public BoundingCircle expandToInclude(BoundingCircle other) {
        return BoundingCircle$.MODULE$.expandToInclude(this, other);
    }

    public boolean encompasses(BoundingCircle other) {
        return BoundingCircle$.MODULE$.encompassing(this, other);
    }

    public boolean overlaps(BoundingCircle other) {
        return BoundingCircle$.MODULE$.overlapping(this, other);
    }

    public BoundingCircle moveBy(Vertex amount) {
        return this.copy(this.position().$plus(amount), this.copy$default$2());
    }

    public BoundingCircle moveBy(double x, double y) {
        return this.moveBy(Vertex$.MODULE$.apply(x, y));
    }

    public BoundingCircle moveBy(Vector2 amount) {
        return this.moveBy(Vertex$.MODULE$.fromVector2(amount));
    }

    public BoundingCircle moveTo(Vertex newPosition) {
        return this.copy(newPosition, this.copy$default$2());
    }

    public BoundingCircle moveTo(double x, double y) {
        return this.moveTo(Vertex$.MODULE$.apply(x, y));
    }

    public BoundingCircle moveTo(Vector2 newPosition) {
        return this.moveTo(Vertex$.MODULE$.fromVector2(newPosition));
    }

    public BoundingCircle resize(double newRadius) {
        return this.copy(this.copy$default$1(), newRadius);
    }

    public boolean lineIntersects(LineSegment line) {
        return BoundingCircle$.MODULE$.lineIntersects(this, line);
    }

    public BoundingCircleLineIntersect lineIntersectsAt(LineSegment line) {
        return BoundingCircle$.MODULE$.lineIntersectsAt(this, line);
    }

    public BoundingCircle copy(Vertex position, double radius) {
        return new BoundingCircle(position, radius);
    }

    public Vertex copy$default$1() {
        return this.position();
    }

    public double copy$default$2() {
        return this.radius();
    }

    public Vertex _1() {
        return this.position();
    }

    public double _2() {
        return this.radius();
    }
}

