/*
 * Decompiled with CFR 0.152.
 */
package indigoextras.geometry;

import indigoextras.geometry.Line$;
import indigoextras.geometry.Line$Components$;
import indigoextras.geometry.Line$InvalidLine$;
import indigoextras.geometry.Line$ParallelToAxisY$;
import indigoextras.geometry.LineIntersectionResult;
import indigoextras.geometry.LineSegment;
import indigoextras.geometry.Vertex;
import indigoextras.geometry.Vertex$;
import java.io.Serializable;
import scala.CanEqual;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public interface Line {
    public static CanEqual<Line, Line> derived$CanEqual() {
        return Line$.MODULE$.derived$CanEqual();
    }

    public static Line fromLineSegment(LineSegment lineSegment) {
        return Line$.MODULE$.fromLineSegment(lineSegment);
    }

    public static LineIntersectionResult intersection(Line line, Line line2) {
        return Line$.MODULE$.intersection(line, line2);
    }

    public static int ordinal(Line line) {
        return Line$.MODULE$.ordinal(line);
    }

    public boolean intersectsWith(Line var1);

    public Option<Vertex> intersectsAt(Line var1);

    public static final class Components
    implements Line,
    Product,
    Serializable {
        private final double m;
        private final double b;

        public static Components apply(double d, double d2) {
            return Line$Components$.MODULE$.apply(d, d2);
        }

        public static Components fromProduct(Product product) {
            return Line$Components$.MODULE$.fromProduct(product);
        }

        public static Components unapply(Components components) {
            return Line$Components$.MODULE$.unapply(components);
        }

        public Components(double m, double b) {
            this.m = m;
            this.b = b;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.m()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.b()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Components)) return false;
            Components components = (Components)object;
            if (this.m() != components.m()) return false;
            if (this.b() != components.b()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Components;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Components";
        }

        public Object productElement(int n) {
            double d;
            int n2 = n;
            if (0 == n2) {
                d = this._1();
            } else if (1 == n2) {
                d = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToDouble((double)d);
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "m";
            }
            if (1 == n2) {
                return "b";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public double m() {
            return this.m;
        }

        public double b() {
            return this.b;
        }

        public boolean slopeComparison(Vertex vertex, double tolerance) {
            double m2 = vertex.x() == 0.0 ? 0.0 : (this.b() - vertex.y()) / (0.0 - vertex.x());
            double mDelta = this.m() - m2;
            return mDelta >= -tolerance && mDelta <= tolerance;
        }

        @Override
        public boolean intersectsWith(Line other) {
            Line line = other;
            if (line instanceof Components) {
                Components components = Line$Components$.MODULE$.unapply((Components)line);
                double d = components._1();
                double d2 = components._2();
                double m2 = d;
                return this.m() != m2;
            }
            if (line instanceof ParallelToAxisY) {
                ParallelToAxisY parallelToAxisY = Line$ParallelToAxisY$.MODULE$.unapply((ParallelToAxisY)line);
                double d = parallelToAxisY._1();
                return true;
            }
            if (Line$InvalidLine$.MODULE$.equals(line)) {
                return false;
            }
            throw new MatchError((Object)line);
        }

        @Override
        public Option<Vertex> intersectsAt(Line other) {
            Line line = other;
            if (line instanceof Components) {
                Components components = Line$Components$.MODULE$.unapply((Components)line);
                double d = components._1();
                double d2 = components._2();
                double m2 = d;
                if (this.m() == m2) {
                    return None$.MODULE$;
                }
                double m22 = d;
                double b2 = d2;
                double x = (b2 - this.b()) / (this.m() - m22);
                return Some$.MODULE$.apply((Object)Vertex$.MODULE$.apply(x, this.m() * x + this.b()));
            }
            if (line instanceof ParallelToAxisY) {
                double d;
                ParallelToAxisY parallelToAxisY = Line$ParallelToAxisY$.MODULE$.unapply((ParallelToAxisY)line);
                double x = d = parallelToAxisY._1();
                return Some$.MODULE$.apply((Object)Vertex$.MODULE$.apply(x, this.m() * x + this.b()));
            }
            return None$.MODULE$;
        }

        public Components copy(double m, double b) {
            return new Components(m, b);
        }

        public double copy$default$1() {
            return this.m();
        }

        public double copy$default$2() {
            return this.b();
        }

        public double _1() {
            return this.m();
        }

        public double _2() {
            return this.b();
        }
    }

    public static final class ParallelToAxisY
    implements Line,
    Product,
    Serializable {
        private final double xPosition;

        public static ParallelToAxisY apply(double d) {
            return Line$ParallelToAxisY$.MODULE$.apply(d);
        }

        public static ParallelToAxisY fromProduct(Product product) {
            return Line$ParallelToAxisY$.MODULE$.fromProduct(product);
        }

        public static ParallelToAxisY unapply(ParallelToAxisY parallelToAxisY) {
            return Line$ParallelToAxisY$.MODULE$.unapply(parallelToAxisY);
        }

        public ParallelToAxisY(double xPosition) {
            this.xPosition = xPosition;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.xPosition()));
            return Statics.finalizeHash((int)n, (int)1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ParallelToAxisY)) return false;
            ParallelToAxisY parallelToAxisY = (ParallelToAxisY)object;
            if (this.xPosition() != parallelToAxisY.xPosition()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ParallelToAxisY;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "ParallelToAxisY";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToDouble((double)this._1());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "xPosition";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public double xPosition() {
            return this.xPosition;
        }

        @Override
        public boolean intersectsWith(Line other) {
            Line line = other;
            return line instanceof Components;
        }

        @Override
        public Option<Vertex> intersectsAt(Line other) {
            Line line = other;
            if (line instanceof Components) {
                Components components = Line$Components$.MODULE$.unapply((Components)line);
                double d = components._1();
                double d2 = components._2();
                double m = d;
                double b = d2;
                return Some$.MODULE$.apply((Object)Vertex$.MODULE$.apply(this.xPosition(), m * this.xPosition() + b));
            }
            return None$.MODULE$;
        }

        public ParallelToAxisY copy(double xPosition) {
            return new ParallelToAxisY(xPosition);
        }

        public double copy$default$1() {
            return this.xPosition();
        }

        public double _1() {
            return this.xPosition();
        }
    }
}

