/*
 * Decompiled with CFR 0.152.
 */
package indigoextras.geometry;

import indigo.shared.datatypes.Vector2;
import indigo.shared.datatypes.Vector2$;
import indigoextras.geometry.BoundingBox;
import indigoextras.geometry.BoundingBox$;
import indigoextras.geometry.Line;
import indigoextras.geometry.Line$;
import indigoextras.geometry.Line$InvalidLine$;
import indigoextras.geometry.LineSegment$;
import indigoextras.geometry.Vertex;
import indigoextras.geometry.Vertex$;
import java.io.Serializable;
import scala.CanEqual;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class LineSegment
implements Product,
Serializable {
    private final Vertex start;
    private final Vertex end;
    private final Vertex center;

    public static LineSegment apply(double d, double d2, double d3, double d4) {
        return LineSegment$.MODULE$.apply(d, d2, d3, d4);
    }

    public static LineSegment apply(Tuple2<Object, Object> tuple2, Tuple2<Object, Object> tuple22) {
        return LineSegment$.MODULE$.apply(tuple2, tuple22);
    }

    public static LineSegment apply(Vertex vertex, Vertex vertex2) {
        return LineSegment$.MODULE$.apply(vertex, vertex2);
    }

    public static CanEqual<LineSegment, LineSegment> derived$CanEqual() {
        return LineSegment$.MODULE$.derived$CanEqual();
    }

    public static LineSegment fromProduct(Product product) {
        return LineSegment$.MODULE$.fromProduct(product);
    }

    public static LineSegment unapply(LineSegment lineSegment) {
        return LineSegment$.MODULE$.unapply(lineSegment);
    }

    public LineSegment(Vertex start, Vertex end) {
        this.start = start;
        this.end = end;
        this.center = Vertex$.MODULE$.apply((end.x() - start.x()) / (double)2 + start.x(), (end.y() - start.y()) / (double)2 + start.y());
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof LineSegment)) return false;
        LineSegment lineSegment = (LineSegment)object;
        Vertex vertex = this.start();
        Vertex vertex2 = lineSegment.start();
        if (vertex == null) {
            if (vertex2 != null) {
                return false;
            }
        } else if (!((Object)vertex).equals(vertex2)) return false;
        Vertex vertex3 = this.end();
        Vertex vertex4 = lineSegment.end();
        if (vertex3 == null) {
            if (vertex4 == null) return true;
            return false;
        } else {
            if (!((Object)vertex3).equals(vertex4)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof LineSegment;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "LineSegment";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        if (1 == n2) {
            return this._2();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "start";
        }
        if (1 == n2) {
            return "end";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Vertex start() {
        return this.start;
    }

    public Vertex end() {
        return this.end;
    }

    public Vertex center() {
        return this.center;
    }

    public double left() {
        return Math.min(this.start().x(), this.end().x());
    }

    public double right() {
        return Math.max(this.start().x(), this.end().x());
    }

    public double top() {
        return Math.min(this.start().y(), this.end().y());
    }

    public double bottom() {
        return Math.max(this.start().y(), this.end().y());
    }

    public double length() {
        return this.start().distanceTo(this.end());
    }

    public double sdf(Vertex vertex) {
        Vertex pa = vertex.$minus(this.start());
        Vertex ba = this.end().$minus(this.start());
        double h = Math.min(1.0, Math.max(0.0, pa.dot(ba) / ba.dot(ba)));
        return pa.$minus(ba.$times(h)).length();
    }

    public double distanceToBoundary(Vertex vertex) {
        return this.sdf(vertex);
    }

    public double distanceToBoundary(Vector2 vector) {
        return this.sdf(Vertex$.MODULE$.fromVector2(vector));
    }

    public LineSegment moveTo(Vertex newPosition) {
        return this.copy(newPosition, newPosition.$plus(this.end().$minus(this.start())));
    }

    public LineSegment moveTo(double x, double y) {
        return this.moveTo(Vertex$.MODULE$.apply(x, y));
    }

    public LineSegment moveTo(Vector2 newPosition) {
        return this.moveTo(Vertex$.MODULE$.fromVector2(newPosition));
    }

    public LineSegment moveBy(Vertex amount) {
        return this.moveTo(this.start().$plus(amount));
    }

    public LineSegment moveBy(double x, double y) {
        return this.moveBy(Vertex$.MODULE$.apply(x, y));
    }

    public LineSegment moveBy(Vector2 amount) {
        return this.moveBy(Vertex$.MODULE$.fromVector2(amount));
    }

    public LineSegment moveStartTo(Vertex newPosition) {
        return this.copy(newPosition, this.copy$default$2());
    }

    public LineSegment moveStartTo(double x, double y) {
        return this.moveStartTo(Vertex$.MODULE$.apply(x, y));
    }

    public LineSegment moveStartTo(Vector2 newPosition) {
        return this.moveStartTo(Vertex$.MODULE$.fromVector2(newPosition));
    }

    public LineSegment moveStartBy(Vertex amount) {
        return this.moveStartTo(this.start().$plus(amount));
    }

    public LineSegment moveStartBy(double x, double y) {
        return this.moveStartBy(Vertex$.MODULE$.apply(x, y));
    }

    public LineSegment moveStartBy(Vector2 amount) {
        return this.moveStartBy(Vertex$.MODULE$.fromVector2(amount));
    }

    public LineSegment moveEndTo(Vertex newPosition) {
        return this.copy(this.copy$default$1(), newPosition);
    }

    public LineSegment moveEndTo(double x, double y) {
        return this.moveEndTo(Vertex$.MODULE$.apply(x, y));
    }

    public LineSegment moveEndTo(Vector2 newPosition) {
        return this.moveEndTo(Vertex$.MODULE$.fromVector2(newPosition));
    }

    public LineSegment moveEndBy(Vertex amount) {
        return this.moveEndTo(this.end().$plus(amount));
    }

    public LineSegment moveEndBy(double x, double y) {
        return this.moveEndBy(Vertex$.MODULE$.apply(x, y));
    }

    public LineSegment moveEndBy(Vector2 amount) {
        return this.moveEndBy(Vertex$.MODULE$.fromVector2(amount));
    }

    public LineSegment invert() {
        return LineSegment$.MODULE$.apply(this.end(), this.start());
    }

    public LineSegment flip() {
        return this.invert();
    }

    public Vector2 normal() {
        return Vector2$.MODULE$.apply(-(this.end().y() - this.start().y()), this.end().x() - this.start().x()).normalise();
    }

    public Line toLine() {
        return Line$.MODULE$.fromLineSegment(this);
    }

    public Option<Vertex> intersectsAt(LineSegment other) {
        return this.toLine().intersectsAt(other.toLine()).flatMap((Function1 & Serializable)pt -> {
            if (this.contains((Vertex)pt) && other.contains((Vertex)pt)) {
                return Some$.MODULE$.apply(pt);
            }
            return None$.MODULE$;
        });
    }

    public boolean intersectsWith(LineSegment other) {
        return BoxesRunTime.unboxToBoolean((Object)this.toLine().intersectsAt(other.toLine()).map((Function1 & Serializable)pt -> this.contains((Vertex)pt) && other.contains((Vertex)pt)).getOrElse(LineSegment::intersectsWith$$anonfun$2));
    }

    public boolean intersectsWithLine(LineSegment other) {
        return this.intersectsWith(other);
    }

    public boolean contains(Vertex vertex, double tolerance) {
        if (vertex.x() >= this.left() && vertex.x() <= this.right() && vertex.y() >= this.top() && vertex.y() <= this.bottom()) {
            Line line = this.toLine();
            if (Line$InvalidLine$.MODULE$.equals(line)) {
                return false;
            }
            if (line instanceof Line.ParallelToAxisY) {
                return true;
            }
            if (line instanceof Line.Components) {
                Line.Components l = (Line.Components)line;
                return l.slopeComparison(vertex, tolerance);
            }
            throw new MatchError((Object)line);
        }
        return false;
    }

    public boolean contains(Vertex vertex) {
        return this.contains(vertex, 0.5);
    }

    public boolean contains(Vector2 vector) {
        return this.contains(Vertex$.MODULE$.fromVector2(vector));
    }

    public boolean isFacingVertex(Vertex vertex) {
        return this.normal().dot(vertex.makeVectorWith(this.center())) < 0.0;
    }

    public boolean isFacingVertex(Vector2 vector) {
        return this.isFacingVertex(Vertex$.MODULE$.fromVector2(vector));
    }

    public Option<Vertex> closestPointOnLine(Vertex to) {
        double a = this.end().y() - this.start().y();
        double b = this.start().x() - this.end().x();
        double c1 = a * this.start().x() + b * this.start().y();
        double c2 = -b * to.x() + a * to.y();
        double det = a * a - -b * b;
        double resX = (a * c1 - b * c2) / det;
        double resY = (a * c2 - -b * c1) / det;
        double minX = Math.min(this.start().x(), this.end().x());
        double minY = Math.min(this.start().y(), this.end().y());
        double maxX = Math.max(this.start().x(), this.end().x());
        double maxY = Math.max(this.start().y(), this.end().y());
        double x = Math.min(maxX, Math.max(minX, resX));
        double y = Math.min(maxY, Math.max(minY, resY));
        if (det != 0.0) {
            return Some$.MODULE$.apply((Object)Vertex$.MODULE$.apply(x, y));
        }
        return None$.MODULE$;
    }

    public Option<Vertex> closestPointOnLine(Vector2 to) {
        return this.closestPointOnLine(Vertex$.MODULE$.fromVector2(to));
    }

    public boolean $tilde$eq$eq(LineSegment other) {
        return this.start().$tilde$eq$eq(other.start()) && this.end().$tilde$eq$eq(other.end());
    }

    public BoundingBox toBoundingBox() {
        return BoundingBox$.MODULE$.fromTwoVertices(this.start(), this.end());
    }

    public LineSegment copy(Vertex start, Vertex end) {
        return new LineSegment(start, end);
    }

    public Vertex copy$default$1() {
        return this.start();
    }

    public Vertex copy$default$2() {
        return this.end();
    }

    public Vertex _1() {
        return this.start();
    }

    public Vertex _2() {
        return this.end();
    }

    private static final boolean intersectsWith$$anonfun$2() {
        return false;
    }
}

