/*
 * Decompiled with CFR 0.152.
 */
package indigoextras.geometry;

import indigo.shared.collections.Batch;
import indigo.shared.collections.Batch$;
import indigo.shared.datatypes.Rectangle;
import indigo.shared.datatypes.Vector2;
import indigoextras.geometry.BoundingBox;
import indigoextras.geometry.BoundingBox$;
import indigoextras.geometry.LineSegment;
import indigoextras.geometry.Polygon$;
import indigoextras.geometry.Polygon$Closed$;
import indigoextras.geometry.Polygon$Open$;
import indigoextras.geometry.Vertex;
import indigoextras.geometry.Vertex$;
import java.io.Serializable;
import scala.CanEqual;
import scala.Function1;
import scala.MatchError;
import scala.Product;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public interface Polygon {
    public static CanEqual<Polygon, Polygon> derived$CanEqual() {
        return Polygon$.MODULE$.derived$CanEqual();
    }

    public static Closed fromBoundingBox(BoundingBox boundingBox) {
        return Polygon$.MODULE$.fromBoundingBox(boundingBox);
    }

    public static Closed fromRectangle(Rectangle rectangle) {
        return Polygon$.MODULE$.fromRectangle(rectangle);
    }

    public static int ordinal(Polygon polygon) {
        return Polygon$.MODULE$.ordinal(polygon);
    }

    public static Batch<LineSegment> toLineSegments(Polygon polygon) {
        return Polygon$.MODULE$.toLineSegments(polygon);
    }

    public static void $init$(Polygon $this) {
    }

    public Batch<Vertex> vertices();

    public Polygon moveTo(Vertex var1);

    public static Polygon moveTo$(Polygon $this, double x, double y) {
        return $this.moveTo(x, y);
    }

    default public Polygon moveTo(double x, double y) {
        return this.moveTo(Vertex$.MODULE$.apply(x, y));
    }

    public static Polygon moveTo$(Polygon $this, Vector2 newPosition) {
        return $this.moveTo(newPosition);
    }

    default public Polygon moveTo(Vector2 newPosition) {
        return this.moveTo(Vertex$.MODULE$.fromVector2(newPosition));
    }

    public Polygon moveBy(Vertex var1);

    public static Polygon moveBy$(Polygon $this, double x, double y) {
        return $this.moveBy(x, y);
    }

    default public Polygon moveBy(double x, double y) {
        return this.moveBy(Vertex$.MODULE$.apply(x, y));
    }

    public static Polygon moveBy$(Polygon $this, Vector2 amount) {
        return $this.moveBy(amount);
    }

    default public Polygon moveBy(Vector2 amount) {
        return this.moveBy(Vertex$.MODULE$.fromVector2(amount));
    }

    public Polygon scaleBy(Vertex var1);

    public static Polygon scaleBy$(Polygon $this, double amount) {
        return $this.scaleBy(amount);
    }

    default public Polygon scaleBy(double amount) {
        return this.scaleBy(Vertex$.MODULE$.apply(amount));
    }

    public static Polygon scaleBy$(Polygon $this, Vector2 vec) {
        return $this.scaleBy(vec);
    }

    default public Polygon scaleBy(Vector2 vec) {
        return this.scaleBy(Vertex$.MODULE$.fromVector2(vec));
    }

    public static BoundingBox bounds$(Polygon $this) {
        return $this.bounds();
    }

    default public BoundingBox bounds() {
        return BoundingBox$.MODULE$.fromVertices(this.vertices());
    }

    public static int edgeCount$(Polygon $this) {
        return $this.edgeCount();
    }

    default public int edgeCount() {
        Polygon polygon = this;
        if (polygon instanceof Open) {
            Batch<Vertex> batch;
            Open open = Polygon$Open$.MODULE$.unapply((Open)polygon);
            Batch<Vertex> vs = batch = open._1();
            return vs.length() - 1;
        }
        if (polygon instanceof Closed) {
            Batch<Vertex> batch;
            Closed closed = Polygon$Closed$.MODULE$.unapply((Closed)polygon);
            Batch<Vertex> vs = batch = closed._1();
            return vs.length();
        }
        throw new MatchError((Object)polygon);
    }

    public static Batch lineSegments$(Polygon $this) {
        return $this.lineSegments();
    }

    default public Batch<LineSegment> lineSegments() {
        return Polygon$.MODULE$.toLineSegments(this);
    }

    public static Polygon addVertex$(Polygon $this, Vertex vertex) {
        return $this.addVertex(vertex);
    }

    default public Polygon addVertex(Vertex vertex) {
        Product product;
        Polygon polygon = this;
        if (polygon instanceof Open) {
            Batch<Vertex> batch;
            Open open = Polygon$Open$.MODULE$.unapply((Open)polygon);
            Batch<Vertex> vs = batch = open._1();
            product = Polygon$Open$.MODULE$.apply((Batch<Vertex>)vs.$plus$plus(Batch$.MODULE$.apply((Object)vertex)));
        } else if (polygon instanceof Closed) {
            Batch<Vertex> batch;
            Closed closed = Polygon$Closed$.MODULE$.unapply((Closed)polygon);
            Batch<Vertex> vs = batch = closed._1();
            product = Polygon$Closed$.MODULE$.apply((Batch<Vertex>)vs.$plus$plus(Batch$.MODULE$.apply((Object)vertex)));
        } else {
            throw new MatchError((Object)polygon);
        }
        return product;
    }

    public static boolean contains$(Polygon $this, Vertex vertex) {
        return $this.contains(vertex);
    }

    default public boolean contains(Vertex vertex) {
        Polygon polygon = this;
        if (polygon instanceof Open) {
            Open open = Polygon$Open$.MODULE$.unapply((Open)polygon);
            Batch<Vertex> batch = open._1();
            return false;
        }
        if (polygon instanceof Closed) {
            Closed closed = Polygon$Closed$.MODULE$.unapply((Closed)polygon);
            Batch<Vertex> batch = closed._1();
            Closed p = (Closed)polygon;
            return this.bounds().contains(vertex) && p.lineSegments().forall((Function1 & Serializable)l -> !l.isFacingVertex(vertex));
        }
        throw new MatchError((Object)polygon);
    }

    public static boolean lineIntersectCheck$(Polygon $this, LineSegment lineSegment) {
        return $this.lineIntersectCheck(lineSegment);
    }

    default public boolean lineIntersectCheck(LineSegment lineSegment) {
        return this.lineSegments().exists((Function1 & Serializable)_$1 -> _$1.intersectsWith(lineSegment));
    }

    public static boolean rectangleIntersectCheck$(Polygon $this, Rectangle rectangle) {
        return $this.rectangleIntersectCheck(rectangle);
    }

    default public boolean rectangleIntersectCheck(Rectangle rectangle) {
        return Polygon$.MODULE$.fromRectangle(rectangle).lineSegments().exists((Function1 & Serializable)lineSegment -> this.lineIntersectCheck((LineSegment)lineSegment));
    }

    public static boolean polygonIntersectCheck$(Polygon $this, Polygon polygon) {
        return $this.polygonIntersectCheck(polygon);
    }

    default public boolean polygonIntersectCheck(Polygon polygon) {
        return polygon.lineSegments().exists((Function1 & Serializable)lineSegment -> this.lineIntersectCheck((LineSegment)lineSegment));
    }

    public static String toString$(Polygon $this) {
        return $this.toString();
    }

    default public String toString() {
        Polygon polygon = this;
        if (polygon instanceof Open) {
            Batch<Vertex> batch;
            Open open = Polygon$Open$.MODULE$.unapply((Open)polygon);
            Batch<Vertex> vs = batch = open._1();
            return new StringBuilder(14).append("Polygon.Open(").append(vs.toString()).append(")").toString();
        }
        if (polygon instanceof Closed) {
            Batch<Vertex> batch;
            Closed closed = Polygon$Closed$.MODULE$.unapply((Closed)polygon);
            Batch<Vertex> vs = batch = closed._1();
            return new StringBuilder(16).append("Polygon.Closed(").append(vs.toString()).append(")").toString();
        }
        throw new MatchError((Object)polygon);
    }

    public static final class Closed
    implements Polygon,
    Product,
    Serializable {
        private Batch lineSegments$lzy2;
        private boolean lineSegmentsbitmap$2;
        private final Batch vertices;

        public static Closed apply(Batch<Vertex> batch) {
            return Polygon$Closed$.MODULE$.apply(batch);
        }

        public static Closed apply(Seq<Vertex> seq) {
            return Polygon$Closed$.MODULE$.apply(seq);
        }

        public static Closed empty() {
            return Polygon$Closed$.MODULE$.empty();
        }

        public static Closed fromProduct(Product product) {
            return Polygon$Closed$.MODULE$.fromProduct(product);
        }

        public static Closed unapply(Closed closed) {
            return Polygon$Closed$.MODULE$.unapply(closed);
        }

        public Closed(Batch<Vertex> vertices) {
            this.vertices = vertices;
            Polygon.$init$(this);
        }

        public Batch lineSegments() {
            if (!this.lineSegmentsbitmap$2) {
                this.lineSegments$lzy2 = Polygon.lineSegments$(this);
                this.lineSegmentsbitmap$2 = true;
            }
            return this.lineSegments$lzy2;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Closed)) return false;
            Closed closed = (Closed)object;
            Batch<Vertex> batch = this.vertices();
            Batch<Vertex> batch2 = closed.vertices();
            if (batch != null) {
                if (!batch.equals(batch2)) return false;
                return true;
            }
            if (batch2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof Closed;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Closed";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "vertices";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public Batch<Vertex> vertices() {
            return this.vertices;
        }

        @Override
        public Closed moveTo(Vertex newPosition) {
            return this.moveBy((Vertex)this.vertices().headOption().map((Function1 & Serializable)v -> newPosition.$minus((Vertex)v)).getOrElse(this::moveTo$$anonfun$4));
        }

        @Override
        public Closed moveBy(Vertex amount) {
            return this.copy((Batch<Vertex>)this.vertices().map((Function1 & Serializable)_$4 -> _$4.moveBy(amount)));
        }

        @Override
        public Closed scaleBy(Vertex vec) {
            return this.copy((Batch<Vertex>)this.vertices().map((Function1 & Serializable)_$5 -> _$5.scaleBy(vec)));
        }

        public Closed copy(Batch<Vertex> vertices) {
            return new Closed(vertices);
        }

        public Batch<Vertex> copy$default$1() {
            return this.vertices();
        }

        public Batch<Vertex> _1() {
            return this.vertices();
        }

        private final Vertex moveTo$$anonfun$4() {
            return Vertex$.MODULE$.zero();
        }
    }

    public static final class Open
    implements Polygon,
    Product,
    Serializable {
        private Batch lineSegments$lzy1;
        private boolean lineSegmentsbitmap$1;
        private final Batch vertices;

        public static Open apply(Batch<Vertex> batch) {
            return Polygon$Open$.MODULE$.apply(batch);
        }

        public static Open apply(Seq<Vertex> seq) {
            return Polygon$Open$.MODULE$.apply(seq);
        }

        public static Open empty() {
            return Polygon$Open$.MODULE$.empty();
        }

        public static Open fromProduct(Product product) {
            return Polygon$Open$.MODULE$.fromProduct(product);
        }

        public static Open unapply(Open open) {
            return Polygon$Open$.MODULE$.unapply(open);
        }

        public Open(Batch<Vertex> vertices) {
            this.vertices = vertices;
            Polygon.$init$(this);
        }

        public Batch lineSegments() {
            if (!this.lineSegmentsbitmap$1) {
                this.lineSegments$lzy1 = Polygon.lineSegments$(this);
                this.lineSegmentsbitmap$1 = true;
            }
            return this.lineSegments$lzy1;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Open)) return false;
            Open open = (Open)object;
            Batch<Vertex> batch = this.vertices();
            Batch<Vertex> batch2 = open.vertices();
            if (batch != null) {
                if (!batch.equals(batch2)) return false;
                return true;
            }
            if (batch2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof Open;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Open";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "vertices";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public Batch<Vertex> vertices() {
            return this.vertices;
        }

        @Override
        public Open moveTo(Vertex newPosition) {
            return this.moveBy((Vertex)this.vertices().headOption().map((Function1 & Serializable)v -> newPosition.$minus((Vertex)v)).getOrElse(this::moveTo$$anonfun$2));
        }

        @Override
        public Open moveBy(Vertex amount) {
            return this.copy((Batch<Vertex>)this.vertices().map((Function1 & Serializable)_$2 -> _$2.moveBy(amount)));
        }

        @Override
        public Open scaleBy(Vertex vec) {
            return this.copy((Batch<Vertex>)this.vertices().map((Function1 & Serializable)_$3 -> _$3.scaleBy(vec)));
        }

        public Open copy(Batch<Vertex> vertices) {
            return new Open(vertices);
        }

        public Batch<Vertex> copy$default$1() {
            return this.vertices();
        }

        public Batch<Vertex> _1() {
            return this.vertices();
        }

        private final Vertex moveTo$$anonfun$2() {
            return Vertex$.MODULE$.zero();
        }
    }
}

