/*
 * Decompiled with CFR 0.152.
 */
package indigoextras.geometry;

import indigo.shared.datatypes.Point;
import indigo.shared.datatypes.Point$;
import indigo.shared.datatypes.Radians;
import indigo.shared.datatypes.Radians$package$;
import indigo.shared.datatypes.Size;
import indigo.shared.datatypes.Size$;
import indigo.shared.datatypes.Vector2;
import indigo.shared.datatypes.Vector2$;
import indigoextras.geometry.Vertex$;
import java.io.Serializable;
import scala.CanEqual;
import scala.Product;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class Vertex
implements Product,
Serializable {
    private final double x;
    private final double y;

    public static Vertex apply(double d) {
        return Vertex$.MODULE$.apply(d);
    }

    public static Vertex apply(double d, double d2) {
        return Vertex$.MODULE$.apply(d, d2);
    }

    public static CanEqual<Vertex, Vertex> derived$CanEqual() {
        return Vertex$.MODULE$.derived$CanEqual();
    }

    public static Vertex fromPoint(Point point) {
        return Vertex$.MODULE$.fromPoint(point);
    }

    public static Vertex fromProduct(Product product) {
        return Vertex$.MODULE$.fromProduct(product);
    }

    public static Vertex fromSize(Size size) {
        return Vertex$.MODULE$.fromSize(size);
    }

    public static Vertex fromVector2(Vector2 vector2) {
        return Vertex$.MODULE$.fromVector2(vector2);
    }

    public static Vertex one() {
        return Vertex$.MODULE$.one();
    }

    public static Vertex tuple2ToVertex(Tuple2<Object, Object> tuple2) {
        return Vertex$.MODULE$.tuple2ToVertex(tuple2);
    }

    public static Vertex unapply(Vertex vertex) {
        return Vertex$.MODULE$.unapply(vertex);
    }

    public static Vertex zero() {
        return Vertex$.MODULE$.zero();
    }

    public Vertex(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.x()));
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.y()));
        return Statics.finalizeHash((int)n, (int)2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Vertex)) return false;
        Vertex vertex = (Vertex)object;
        if (this.x() != vertex.x()) return false;
        if (this.y() != vertex.y()) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof Vertex;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "Vertex";
    }

    public Object productElement(int n) {
        double d;
        int n2 = n;
        if (0 == n2) {
            d = this._1();
        } else if (1 == n2) {
            d = this._2();
        } else {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return BoxesRunTime.boxToDouble((double)d);
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "x";
        }
        if (1 == n2) {
            return "y";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public Vertex withX(double newX) {
        return this.copy(newX, this.copy$default$2());
    }

    public Vertex withY(double newY) {
        return this.copy(this.copy$default$1(), newY);
    }

    public double dot(Vertex other) {
        return this.x() * other.x() + this.y() * other.y();
    }

    public double dot(Vector2 other) {
        return this.dot(Vertex$.MODULE$.fromVector2(other));
    }

    public Vertex abs() {
        return Vertex$.MODULE$.apply(Math.abs(this.x()), Math.abs(this.y()));
    }

    public Vertex min(Vertex other) {
        return Vertex$.MODULE$.apply(Math.min(other.x(), this.x()), Math.min(other.y(), this.y()));
    }

    public Vertex min(double value) {
        return Vertex$.MODULE$.apply(Math.min(value, this.x()), Math.min(value, this.y()));
    }

    public Vertex min(Vector2 v) {
        return this.min(Vertex$.MODULE$.fromVector2(v));
    }

    public Vertex max(Vertex other) {
        return Vertex$.MODULE$.apply(Math.max(other.x(), this.x()), Math.max(other.y(), this.y()));
    }

    public Vertex max(double value) {
        return Vertex$.MODULE$.apply(Math.max(value, this.x()), Math.max(value, this.y()));
    }

    public Vertex max(Vector2 v) {
        return this.max(Vertex$.MODULE$.fromVector2(v));
    }

    public Vertex clamp(double min, double max) {
        return Vertex$.MODULE$.apply(Math.min(max, Math.max(min, this.x())), Math.min(max, Math.max(min, this.y())));
    }

    public Vertex clamp(Vertex min, Vertex max) {
        return Vertex$.MODULE$.apply(Math.min(max.x(), Math.max(min.x(), this.x())), Math.min(max.y(), Math.max(min.y(), this.y())));
    }

    public Vertex clamp(Vector2 v1, Vector2 v2) {
        return this.clamp(Vertex$.MODULE$.fromVector2(v1), Vertex$.MODULE$.fromVector2(v1));
    }

    public double length() {
        return this.distanceTo(Vertex$.MODULE$.zero());
    }

    public Vertex invert() {
        return Vertex$.MODULE$.apply(-this.x(), -this.y());
    }

    public Vertex translate(Vertex vec) {
        return this.$plus(vec);
    }

    public Vertex translate(Vector2 vec) {
        return this.$plus(Vertex$.MODULE$.fromVector2(vec));
    }

    public Vertex moveTo(Vertex newPosition) {
        return newPosition;
    }

    public Vertex moveTo(double x, double y) {
        return this.moveTo(Vertex$.MODULE$.apply(x, y));
    }

    public Vertex moveTo(Vector2 v) {
        return this.moveTo(Vertex$.MODULE$.fromVector2(v));
    }

    public Vertex moveBy(Vertex amount) {
        return this.$plus(amount);
    }

    public Vertex moveBy(double x, double y) {
        return this.moveBy(Vertex$.MODULE$.apply(x, y));
    }

    public Vertex moveBy(Vector2 v) {
        return this.moveBy(Vertex$.MODULE$.fromVector2(v));
    }

    public Vertex scaleBy(Vertex vec) {
        return this.$times(vec);
    }

    public Vertex scaleBy(double amount) {
        return this.scaleBy(Vertex$.MODULE$.apply(amount));
    }

    public Vertex scaleBy(Vector2 v) {
        return this.scaleBy(Vertex$.MODULE$.fromVector2(v));
    }

    public Vertex rotateBy(double angle) {
        double a = Radians.package.Radians$.MODULE$.toDouble(Radians.package.Radians$.MODULE$.wrap(angle));
        double s = Math.sin(a);
        double c = Math.cos(a);
        return Vertex$.MODULE$.apply(this.x() * c - this.y() * s, this.x() * s + this.y() * c);
    }

    public Vertex rotateBy(double angle, Vertex origin) {
        return this.$minus(origin).rotateBy(angle).$plus(origin);
    }

    public Vertex rotateTo(double angle) {
        double a = Radians.package.Radians$.MODULE$.toDouble(Radians.package.Radians$.MODULE$.wrap(angle));
        return Vertex$.MODULE$.apply(this.length() * Math.cos(a), this.length() * Math.sin(a));
    }

    public double angle() {
        Radians$package$ radians$package$;
        Radians$package$ Radians$package$_this = radians$package$ = Radians$package$.MODULE$;
        double radians$proxy1 = Math.atan2(this.y(), this.x());
        return radians$proxy1;
    }

    public Vertex ceil() {
        return Vertex$.MODULE$.apply(Math.ceil(this.x()), Math.ceil(this.y()));
    }

    public Vertex floor() {
        return Vertex$.MODULE$.apply(Math.floor(this.x()), Math.floor(this.y()));
    }

    public Vertex round() {
        return Vertex$.MODULE$.apply(Math.round(this.x()), Math.round(this.y()));
    }

    public Vertex $plus(Vertex other) {
        return Vertex$.MODULE$.apply(this.x() + other.x(), this.y() + other.y());
    }

    public Vertex $minus(Vertex other) {
        return Vertex$.MODULE$.apply(this.x() - other.x(), this.y() - other.y());
    }

    public Vertex $times(Vertex other) {
        return Vertex$.MODULE$.apply(this.x() * other.x(), this.y() * other.y());
    }

    public Vertex $div(Vertex other) {
        return Vertex$.MODULE$.apply(this.x() / other.x(), this.y() / other.y());
    }

    public Vertex $plus(double value) {
        return this.$plus(Vertex$.MODULE$.apply(value, value));
    }

    public Vertex $minus(double value) {
        return this.$minus(Vertex$.MODULE$.apply(value, value));
    }

    public Vertex $times(double value) {
        return this.$times(Vertex$.MODULE$.apply(value, value));
    }

    public Vertex $div(double value) {
        return this.$div(Vertex$.MODULE$.apply(value, value));
    }

    public double distanceTo(Vertex other) {
        return Math.sqrt(Math.abs(Math.pow(other.x() - this.x(), 2.0) + Math.pow(other.y() - this.y(), 2.0)));
    }

    public List<Object> toList() {
        return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{this.x(), this.y()}));
    }

    public Point toPoint() {
        return Point$.MODULE$.apply((int)this.x(), (int)this.y());
    }

    public Size toSize() {
        return Size$.MODULE$.apply((int)this.x(), (int)this.y());
    }

    public Vector2 toVector2() {
        return Vector2$.MODULE$.apply(this.x(), this.y());
    }

    public Vector2 makeVectorWith(Vertex other) {
        return Vector2$.MODULE$.apply(other.x() - this.x(), other.y() - this.y());
    }

    public boolean $tilde$eq$eq(Vertex other) {
        return Math.abs(this.x() - other.x()) < 1.0E-4 && Math.abs(this.y() - other.y()) < 1.0E-4;
    }

    public Vertex copy(double x, double y) {
        return new Vertex(x, y);
    }

    public double copy$default$1() {
        return this.x();
    }

    public double copy$default$2() {
        return this.y();
    }

    public double _1() {
        return this.x();
    }

    public double _2() {
        return this.y();
    }
}

