/*
 * Decompiled with CFR 0.152.
 */
package indigoextras.subsystems;

import indigo.shared.assets.AssetType;
import indigoextras.subsystems.AssetBundle$;
import indigoextras.subsystems.AssetBundleStatus;
import indigoextras.subsystems.AssetBundleStatus$LoadComplete$;
import indigoextras.subsystems.AssetBundleStatus$LoadFailed$;
import indigoextras.subsystems.AssetBundleStatus$LoadInProgress$;
import indigoextras.subsystems.AssetToLoad;
import indigoextras.subsystems.AssetToLoad$;
import java.io.Serializable;
import scala.CanEqual;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class AssetBundle
implements Product,
Serializable {
    private final String key;
    private final int assetCount;
    private final Map assets;
    private CanEqual given_CanEqual_Option_Option$lzy2;
    private boolean given_CanEqual_Option_Optionbitmap$2;

    public static AssetBundle apply(String string, int n, Map<String, AssetToLoad> map) {
        return AssetBundle$.MODULE$.apply(string, n, map);
    }

    public static AssetBundle fromProduct(Product product) {
        return AssetBundle$.MODULE$.fromProduct(product);
    }

    public static AssetBundle unapply(AssetBundle assetBundle) {
        return AssetBundle$.MODULE$.unapply(assetBundle);
    }

    public AssetBundle(String key, int assetCount, Map<String, AssetToLoad> assets) {
        this.key = key;
        this.assetCount = assetCount;
        this.assets = assets;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.key()));
        n = Statics.mix((int)n, (int)this.assetCount());
        n = Statics.mix((int)n, (int)Statics.anyHash(this.assets()));
        return Statics.finalizeHash((int)n, (int)3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof AssetBundle)) return false;
        AssetBundle assetBundle = (AssetBundle)object;
        if (this.assetCount() != assetBundle.assetCount()) return false;
        String string = this.key();
        String string2 = assetBundle.key();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Map<String, AssetToLoad> map = this.assets();
        Map<String, AssetToLoad> map2 = assetBundle.assets();
        if (map == null) {
            if (map2 == null) return true;
            return false;
        } else {
            if (!map.equals(map2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof AssetBundle;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "AssetBundle";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return BoxesRunTime.boxToInteger((int)this._2());
            }
            case 2: {
                return this._3();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "key";
            }
            case 1: {
                return "assetCount";
            }
            case 2: {
                return "assets";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String key() {
        return this.key;
    }

    public int assetCount() {
        return this.assetCount;
    }

    public Map<String, AssetToLoad> assets() {
        return this.assets;
    }

    private final CanEqual<Option<AssetToLoad>, Option<AssetToLoad>> given_CanEqual_Option_Option() {
        if (!this.given_CanEqual_Option_Optionbitmap$2) {
            this.given_CanEqual_Option_Option$lzy2 = CanEqual.derived$.MODULE$;
            this.given_CanEqual_Option_Optionbitmap$2 = true;
        }
        return this.given_CanEqual_Option_Option$lzy2;
    }

    public AssetBundle assetLoadComplete(String assetPath, boolean loaded) {
        return AssetBundle$.MODULE$.apply(this.key(), this.assetCount(), (Map<String, AssetToLoad>)((Map)this.assets().updatedWith((Object)assetPath, (Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (None$.MODULE$.equals(option)) {
                return None$.MODULE$;
            }
            if (option instanceof Some) {
                AssetToLoad v = (AssetToLoad)((Some)option).value();
                return Some$.MODULE$.apply((Object)AssetToLoad$.MODULE$.apply(v.asset(), true, loaded));
            }
            throw new MatchError((Object)option);
        })));
    }

    public AssetBundleStatus status() {
        List assetList = this.assets().toList();
        int count = assetList.length();
        List errors = assetList.filter((Function1 & Serializable)p -> ((AssetToLoad)p._2()).complete() && !((AssetToLoad)p._2()).loaded()).map((Function1 & Serializable)_$9 -> (String)_$9._1());
        int errorCount = errors.length();
        List successes = assetList.filter((Function1 & Serializable)p -> ((AssetToLoad)p._2()).complete() && ((AssetToLoad)p._2()).loaded()).map((Function1 & Serializable)_$10 -> (String)_$10._1());
        int successCount = successes.length();
        int combined = errorCount + successCount;
        int percentage = (int)Math.round(100.0 * (double)combined / (double)count);
        int clampedPercentage = Math.min(100, Math.max(0, percentage));
        if (errorCount + successCount < count) {
            return AssetBundleStatus$LoadInProgress$.MODULE$.apply(clampedPercentage, combined, count);
        }
        if (errorCount > 0) {
            return AssetBundleStatus$LoadFailed$.MODULE$.apply(clampedPercentage, combined, count, (List<String>)errors);
        }
        return AssetBundleStatus$LoadComplete$.MODULE$.apply(combined, count);
    }

    public Option<AssetToLoad> giveAssetLoadState(String path) {
        return this.assets().get((Object)path);
    }

    public Set<AssetType> giveAssetSet() {
        return this.assets().toList().map((Function1 & Serializable)_$11 -> ((AssetToLoad)_$11._2()).asset()).toSet();
    }

    public boolean containsAsset(String path) {
        return this.assets().contains((Object)path);
    }

    public AssetBundle copy(String key, int assetCount, Map<String, AssetToLoad> assets) {
        return new AssetBundle(key, assetCount, assets);
    }

    public String copy$default$1() {
        return this.key();
    }

    public int copy$default$2() {
        return this.assetCount();
    }

    public Map<String, AssetToLoad> copy$default$3() {
        return this.assets();
    }

    public String _1() {
        return this.key();
    }

    public int _2() {
        return this.assetCount();
    }

    public Map<String, AssetToLoad> _3() {
        return this.assets();
    }
}

