/*
 * Decompiled with CFR 0.152.
 */
package indigoextras.subsystems;

import indigo.shared.Outcome;
import indigo.shared.Outcome$;
import indigo.shared.assets.AssetPath$package$;
import indigo.shared.assets.AssetType;
import indigo.shared.assets.AssetType$;
import indigo.shared.assets.AssetTypePrimitive;
import indigo.shared.collections.Batch;
import indigo.shared.collections.Batch$;
import indigo.shared.datatypes.BindingKey$package$;
import indigo.shared.events.AssetEvent;
import indigo.shared.events.GlobalEvent;
import indigo.shared.scenegraph.SceneUpdateFragment;
import indigo.shared.scenegraph.SceneUpdateFragment$;
import indigo.shared.subsystems.SubSystem;
import indigo.shared.subsystems.SubSystemFrameContext;
import indigo.shared.subsystems.SubSystemId$package$;
import indigoextras.subsystems.AssetBundleLoaderEvent;
import indigoextras.subsystems.AssetBundleLoaderEvent$Failure$;
import indigoextras.subsystems.AssetBundleLoaderEvent$Load$;
import indigoextras.subsystems.AssetBundleLoaderEvent$LoadProgress$;
import indigoextras.subsystems.AssetBundleLoaderEvent$Retry$;
import indigoextras.subsystems.AssetBundleLoaderEvent$Started$;
import indigoextras.subsystems.AssetBundleLoaderEvent$Success$;
import indigoextras.subsystems.AssetBundleStatus;
import indigoextras.subsystems.AssetBundleStatus$LoadComplete$;
import indigoextras.subsystems.AssetBundleStatus$LoadFailed$;
import indigoextras.subsystems.AssetBundleStatus$LoadInProgress$;
import indigoextras.subsystems.AssetBundleTracker;
import indigoextras.subsystems.AssetBundleTracker$;
import java.io.Serializable;
import scala.CanEqual;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class AssetBundleLoader$
implements SubSystem,
Serializable {
    private static final String id;
    private static final Function1 eventFilter;
    private static CanEqual given_CanEqual_Option_Option$lzy1;
    private boolean given_CanEqual_Option_Optionbitmap$1;
    public static final AssetBundleLoader$ MODULE$;

    private AssetBundleLoader$() {
    }

    static {
        SubSystemId$package$ subSystemId$package$;
        MODULE$ = new AssetBundleLoader$();
        SubSystemId$package$ SubSystemId$package$_this = subSystemId$package$ = SubSystemId$package$.MODULE$;
        id = "[indigo_AssetBundleLoader_subsystem]";
        eventFilter = (Function1 & Serializable)x$1 -> {
            GlobalEvent globalEvent = x$1;
            if (globalEvent instanceof AssetBundleLoaderEvent) {
                AssetBundleLoaderEvent e = (AssetBundleLoaderEvent)globalEvent;
                return Some$.MODULE$.apply((Object)e);
            }
            if (globalEvent instanceof AssetEvent) {
                AssetEvent e = (AssetEvent)globalEvent;
                return Some$.MODULE$.apply((Object)e);
            }
            return None$.MODULE$;
        };
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(AssetBundleLoader$.class);
    }

    public String id() {
        return id;
    }

    public Function1<GlobalEvent, Option<GlobalEvent>> eventFilter() {
        return eventFilter;
    }

    public Outcome<AssetBundleTracker> initialModel() {
        return Outcome$.MODULE$.apply(this::initialModel$$anonfun$1);
    }

    private final CanEqual<Option<Set<AssetType>>, Option<Set<AssetType>>> given_CanEqual_Option_Option() {
        if (!this.given_CanEqual_Option_Optionbitmap$1) {
            given_CanEqual_Option_Option$lzy1 = CanEqual.derived$.MODULE$;
            this.given_CanEqual_Option_Optionbitmap$1 = true;
        }
        return given_CanEqual_Option_Option$lzy1;
    }

    public Function1<GlobalEvent, Outcome<AssetBundleTracker>> update(SubSystemFrameContext frameContext, AssetBundleTracker tracker) {
        return (Function1 & Serializable)x$1 -> {
            GlobalEvent globalEvent = x$1;
            if (globalEvent instanceof AssetBundleLoaderEvent.Load) {
                AssetBundleLoaderEvent.Load load = AssetBundleLoaderEvent$Load$.MODULE$.unapply((AssetBundleLoaderEvent.Load)globalEvent);
                String string = load._1();
                Set<AssetType> set = load._2();
                String key = string;
                Set<AssetType> assets = set;
                return this.createBeginLoadingOutcome(key, assets, tracker);
            }
            if (globalEvent instanceof AssetBundleLoaderEvent.Retry) {
                AssetBundleLoaderEvent.Retry retry = AssetBundleLoaderEvent$Retry$.MODULE$.unapply((AssetBundleLoaderEvent.Retry)globalEvent);
                String string = retry._1();
                String key = string;
                Option option = tracker.findBundleByKey(key).map((Function1 & Serializable)_$1 -> _$1.giveAssetSet());
                if (None$.MODULE$.equals(option)) {
                    return Outcome$.MODULE$.apply(() -> this.update$$anonfun$1$$anonfun$2(tracker));
                }
                if (option instanceof Some) {
                    Set assets = (Set)((Some)option).value();
                    return this.createBeginLoadingOutcome(key, (Set<AssetType>)assets, tracker);
                }
                throw new MatchError((Object)option);
            }
            if (globalEvent instanceof AssetEvent.AssetBatchLoaded) {
                AssetEvent.AssetBatchLoaded assetBatchLoaded = AssetEvent.AssetBatchLoaded$.MODULE$.unapply((AssetEvent.AssetBatchLoaded)globalEvent);
                String string = assetBatchLoaded._1();
                boolean bl = assetBatchLoaded._2();
                String key = string;
                if (bl && tracker.containsBundle(key)) {
                    return Outcome$.MODULE$.apply(() -> this.update$$anonfun$1$$anonfun$3(tracker)).addGlobalEvents((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new GlobalEvent[]{AssetBundleLoaderEvent$Success$.MODULE$.apply(key)}));
                }
                String key2 = string;
                if (!bl && tracker.containsAssetFromKey(key2)) {
                    AssetPath$package$ assetPath$package$;
                    AssetPath$package$ AssetPath$package$_this = assetPath$package$ = AssetPath$package$.MODULE$;
                    String value$proxy1 = key2.toString();
                    return this.processAssetUpdateEvent(value$proxy1, true, tracker);
                }
            }
            if (globalEvent instanceof AssetEvent.AssetBatchLoadError) {
                AssetEvent.AssetBatchLoadError assetBatchLoadError = AssetEvent.AssetBatchLoadError$.MODULE$.unapply((AssetEvent.AssetBatchLoadError)globalEvent);
                String string = assetBatchLoadError._1();
                String string2 = assetBatchLoadError._2();
                String key = string;
                String message = string2;
                if (tracker.containsBundle(key)) {
                    return Outcome$.MODULE$.apply(() -> this.update$$anonfun$1$$anonfun$4(tracker)).addGlobalEvents((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new GlobalEvent[]{AssetBundleLoaderEvent$Failure$.MODULE$.apply(key, message)}));
                }
                String key3 = string;
                if (tracker.containsAssetFromKey(key3)) {
                    AssetPath$package$ assetPath$package$;
                    AssetPath$package$ AssetPath$package$_this = assetPath$package$ = AssetPath$package$.MODULE$;
                    String value$proxy2 = key3.toString();
                    return this.processAssetUpdateEvent(value$proxy2, false, tracker);
                }
            }
            return Outcome$.MODULE$.apply(() -> this.update$$anonfun$1$$anonfun$5(tracker));
        };
    }

    public Outcome<SceneUpdateFragment> present(SubSystemFrameContext frameContext, AssetBundleTracker model) {
        return Outcome$.MODULE$.apply(this::present$$anonfun$1);
    }

    private Outcome<AssetBundleTracker> createBeginLoadingOutcome(String key, Set<AssetType> assets, AssetBundleTracker tracker) {
        List assetPrimitives = AssetType$.MODULE$.flattenAssetList(assets.toList());
        Batch events = Batch$.MODULE$.fromList(assetPrimitives.map((Function1 & Serializable)asset -> {
            BindingKey$package$ bindingKey$package$;
            BindingKey$package$ BindingKey$package$_this = bindingKey$package$ = BindingKey$package$.MODULE$;
            String value$proxy3 = asset.path().toString();
            return AssetEvent.LoadAsset$.MODULE$.apply((AssetType)asset, value$proxy3, false);
        }));
        return Outcome$.MODULE$.apply(() -> this.createBeginLoadingOutcome$$anonfun$1(key, tracker, assetPrimitives)).addGlobalEvents(() -> this.createBeginLoadingOutcome$$anonfun$2(key, events));
    }

    private Outcome<AssetBundleTracker> processAssetUpdateEvent(String path, boolean completedSuccessfully, AssetBundleTracker tracker) {
        AssetBundleTracker updatedTracker = tracker.assetLoadComplete(path, completedSuccessfully);
        List statusBasedEvents = updatedTracker.register().filter((Function1 & Serializable)_$2 -> _$2.containsAsset(path)).flatMap((Function1 & Serializable)bundle -> {
            AssetBundleStatus assetBundleStatus = bundle.status();
            if (assetBundleStatus instanceof AssetBundleStatus.LoadComplete) {
                AssetBundleStatus.LoadComplete loadComplete = AssetBundleStatus$LoadComplete$.MODULE$.unapply((AssetBundleStatus.LoadComplete)assetBundleStatus);
                int n = loadComplete._1();
                int n2 = loadComplete._2();
                int completed = n;
                int count = n2;
                return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new GlobalEvent[]{AssetBundleLoaderEvent$LoadProgress$.MODULE$.apply(bundle.key(), 100, completed, count), AssetEvent.LoadAssetBatch$.MODULE$.apply(bundle.giveAssetSet(), bundle.key(), true)}));
            }
            if (assetBundleStatus instanceof AssetBundleStatus.LoadFailed) {
                AssetBundleStatus.LoadFailed loadFailed = AssetBundleStatus$LoadFailed$.MODULE$.unapply((AssetBundleStatus.LoadFailed)assetBundleStatus);
                int n = loadFailed._1();
                int n3 = loadFailed._2();
                int n4 = loadFailed._3();
                List<String> list = loadFailed._4();
                int percent = n;
                int completed = n3;
                int count = n4;
                return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new GlobalEvent[]{AssetBundleLoaderEvent$LoadProgress$.MODULE$.apply(bundle.key(), percent, completed, count), AssetEvent.AssetBatchLoadError$.MODULE$.apply(bundle.key(), new StringBuilder(38).append("Asset batch with key '").append(bundle.key().toString()).append("' failed to load").toString())}));
            }
            if (assetBundleStatus instanceof AssetBundleStatus.LoadInProgress) {
                AssetBundleStatus.LoadInProgress loadInProgress = AssetBundleStatus$LoadInProgress$.MODULE$.unapply((AssetBundleStatus.LoadInProgress)assetBundleStatus);
                int n = loadInProgress._1();
                int n5 = loadInProgress._2();
                int n6 = loadInProgress._3();
                int percent = n;
                int completed = n5;
                int count = n6;
                return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AssetBundleLoaderEvent[]{AssetBundleLoaderEvent$LoadProgress$.MODULE$.apply(bundle.key(), percent, completed, count)}));
            }
            throw new MatchError((Object)assetBundleStatus);
        });
        return Outcome$.MODULE$.apply(() -> this.processAssetUpdateEvent$$anonfun$1(updatedTracker), () -> this.processAssetUpdateEvent$$anonfun$2(statusBasedEvents));
    }

    private final AssetBundleTracker initialModel$$anonfun$1() {
        return AssetBundleTracker$.MODULE$.empty();
    }

    private final AssetBundleTracker update$$anonfun$1$$anonfun$2(AssetBundleTracker tracker$2) {
        return tracker$2;
    }

    private final AssetBundleTracker update$$anonfun$1$$anonfun$3(AssetBundleTracker tracker$3) {
        return tracker$3;
    }

    private final AssetBundleTracker update$$anonfun$1$$anonfun$4(AssetBundleTracker tracker$4) {
        return tracker$4;
    }

    private final AssetBundleTracker update$$anonfun$1$$anonfun$5(AssetBundleTracker tracker$5) {
        return tracker$5;
    }

    private final SceneUpdateFragment present$$anonfun$1() {
        return SceneUpdateFragment$.MODULE$.empty();
    }

    private final AssetBundleTracker createBeginLoadingOutcome$$anonfun$1(String key$1, AssetBundleTracker tracker$6, List assetPrimitives$1) {
        return tracker$6.addBundle(key$1, (List<AssetTypePrimitive>)assetPrimitives$1);
    }

    private final Batch createBeginLoadingOutcome$$anonfun$2(String key$2, Batch events$1) {
        AssetBundleLoaderEvent.Started started = AssetBundleLoaderEvent$Started$.MODULE$.apply(key$2);
        return events$1.$colon$colon((Object)started);
    }

    private final AssetBundleTracker processAssetUpdateEvent$$anonfun$1(AssetBundleTracker updatedTracker$1) {
        return updatedTracker$1;
    }

    private final Batch processAssetUpdateEvent$$anonfun$2(List statusBasedEvents$1) {
        return Batch$.MODULE$.fromList(statusBasedEvents$1);
    }
}

