/*
 * Decompiled with CFR 0.152.
 */
package indigoextras.subsystems;

import indigo.shared.Outcome;
import indigo.shared.Outcome$;
import indigo.shared.datatypes.Fill;
import indigo.shared.datatypes.Point;
import indigo.shared.datatypes.RGBA;
import indigo.shared.datatypes.RGBA$;
import indigo.shared.datatypes.Rectangle;
import indigo.shared.datatypes.Rectangle$;
import indigo.shared.datatypes.Size;
import indigo.shared.datatypes.Size$;
import indigo.shared.events.FrameTick$;
import indigo.shared.events.GlobalEvent;
import indigo.shared.scenegraph.Layer;
import indigo.shared.scenegraph.Layer$;
import indigo.shared.scenegraph.SceneNode;
import indigo.shared.scenegraph.SceneUpdateFragment;
import indigo.shared.scenegraph.SceneUpdateFragment$;
import indigo.shared.scenegraph.Shape;
import indigo.shared.scenegraph.TextBox;
import indigo.shared.scenegraph.TextBox$;
import indigo.shared.subsystems.SubSystem;
import indigo.shared.subsystems.SubSystemFrameContext;
import indigo.shared.time.FPS;
import indigo.shared.time.Seconds;
import indigo.shared.time.Seconds$package$;
import indigoextras.subsystems.FPSCounter$;
import indigoextras.subsystems.FPSCounter$Move$;
import indigoextras.subsystems.FPSCounterState;
import indigoextras.subsystems.FPSCounterState$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class FPSCounter
implements SubSystem,
Product,
Serializable {
    private final String id;
    private final Point startPosition;
    private final Option targetFPS;
    private final Option layerKey;
    private final String fontFamily;
    private final int fontSize;
    private final int idealFps;
    private final Function1<Object, Object> decideNextFps;
    private final TextBox textBox;

    public static String DefaultId() {
        return FPSCounter$.MODULE$.DefaultId();
    }

    public static SubSystem apply(Point point) {
        return FPSCounter$.MODULE$.apply(point);
    }

    public static SubSystem apply(Point point, int n) {
        return FPSCounter$.MODULE$.apply(point, n);
    }

    public static SubSystem apply(Point point, int n, String string) {
        return FPSCounter$.MODULE$.apply(point, n, string);
    }

    public static SubSystem apply(Point point, String string) {
        return FPSCounter$.MODULE$.apply(point, string);
    }

    public static SubSystem apply(String string, Point point) {
        return FPSCounter$.MODULE$.apply(string, point);
    }

    public static SubSystem apply(String string, Point point, int n) {
        return FPSCounter$.MODULE$.apply(string, point, n);
    }

    public static SubSystem apply(String string, Point point, int n, String string2) {
        return FPSCounter$.MODULE$.apply(string, point, n, string2);
    }

    public static FPSCounter apply(String string, Point point, Option<Object> option, Option<String> option2, String string2, int n) {
        return FPSCounter$.MODULE$.apply(string, point, option, option2, string2, n);
    }

    public static SubSystem apply(String string, Point point, String string2) {
        return FPSCounter$.MODULE$.apply(string, point, string2);
    }

    public static FPSCounter fromProduct(Product product) {
        return FPSCounter$.MODULE$.fromProduct(product);
    }

    public static FPSCounter unapply(FPSCounter fPSCounter) {
        return FPSCounter$.MODULE$.unapply(fPSCounter);
    }

    public FPSCounter(String id, Point startPosition, Option<Object> targetFPS, Option<String> layerKey, String fontFamily, int fontSize) {
        Function1 & Serializable intersect;
        this.id = id;
        this.startPosition = startPosition;
        this.targetFPS = targetFPS;
        this.layerKey = layerKey;
        this.fontFamily = fontFamily;
        this.fontSize = fontSize;
        this.idealFps = FPS.package.FPS$.MODULE$.toInt(BoxesRunTime.unboxToInt((Object)targetFPS.getOrElse(FPSCounter::$init$$$anonfun$1)));
        Option<Object> option = targetFPS;
        if (None$.MODULE$.equals(option)) {
            intersect = (Function1 & Serializable)frameCountSinceInterval -> FPSCounter.$init$$$anonfun$2(BoxesRunTime.unboxToInt((Object)frameCountSinceInterval));
        } else if (option instanceof Some) {
            int target = BoxesRunTime.unboxToInt((Object)((Some)option).value());
            intersect = (Function1 & Serializable)frameCountSinceInterval -> FPSCounter.$init$$$anonfun$3(target, BoxesRunTime.unboxToInt((Object)frameCountSinceInterval));
        } else {
            throw new MatchError(option);
        }
        this.decideNextFps = intersect;
        this.textBox = TextBox$.MODULE$.apply("").withFontFamily(fontFamily).withFontSize(fontSize);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof FPSCounter)) return false;
        FPSCounter fPSCounter = (FPSCounter)object;
        String string = this.id();
        String string2 = fPSCounter.id();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Point point = this.startPosition();
        Point point2 = fPSCounter.startPosition();
        if (point == null) {
            if (point2 != null) {
                return false;
            }
        } else if (!point.equals(point2)) return false;
        Option<Object> option = this.targetFPS();
        Option<Object> option2 = fPSCounter.targetFPS();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<String> option3 = this.layerKey();
        Option<String> option4 = fPSCounter.layerKey();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        String string3 = this.fontFamily();
        String string4 = fPSCounter.fontFamily();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        if (this.fontSize() != fPSCounter.fontSize()) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof FPSCounter;
    }

    public int productArity() {
        return 6;
    }

    public String productPrefix() {
        return "FPSCounter";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return this._5();
            }
            case 5: {
                return BoxesRunTime.boxToInteger((int)this._6());
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "id";
            }
            case 1: {
                return "startPosition";
            }
            case 2: {
                return "targetFPS";
            }
            case 3: {
                return "layerKey";
            }
            case 4: {
                return "fontFamily";
            }
            case 5: {
                return "fontSize";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String id() {
        return this.id;
    }

    public Point startPosition() {
        return this.startPosition;
    }

    public Option<Object> targetFPS() {
        return this.targetFPS;
    }

    public Option<String> layerKey() {
        return this.layerKey;
    }

    public String fontFamily() {
        return this.fontFamily;
    }

    public int fontSize() {
        return this.fontSize;
    }

    public Function1<GlobalEvent, Option<GlobalEvent>> eventFilter() {
        return (Function1 & Serializable)x$1 -> {
            GlobalEvent globalEvent = x$1;
            if (FrameTick$.MODULE$.equals(globalEvent)) {
                return Some$.MODULE$.apply((Object)FrameTick$.MODULE$);
            }
            if (globalEvent instanceof Move) {
                Move e = (Move)globalEvent;
                return Some$.MODULE$.apply((Object)e);
            }
            return None$.MODULE$;
        };
    }

    public Outcome<FPSCounterState> initialModel() {
        return Outcome$.MODULE$.apply(this::initialModel$$anonfun$1);
    }

    public Function1<GlobalEvent, Outcome<FPSCounterState>> update(SubSystemFrameContext context, FPSCounterState model) {
        return (Function1 & Serializable)x$1 -> {
            GlobalEvent globalEvent = x$1;
            if (FrameTick$.MODULE$.equals(globalEvent)) {
                Seconds$package$ seconds$package$;
                Seconds$package$ Seconds$package$_this = seconds$package$ = Seconds$package$.MODULE$;
                if (Seconds.package.Seconds$.MODULE$.$greater$eq(context.gameTime().running(), Seconds.package.Seconds$.MODULE$.$plus(model.lastInterval(), 1.0))) {
                    return Outcome$.MODULE$.apply(() -> this.update$$anonfun$1$$anonfun$1(context, model));
                }
                return Outcome$.MODULE$.apply(() -> FPSCounter.update$$anonfun$1$$anonfun$2(model));
            }
            if (globalEvent instanceof Move) {
                Point point;
                Move move = FPSCounter$Move$.MODULE$.unapply((Move)globalEvent);
                Point to = point = move._1();
                return Outcome$.MODULE$.apply(() -> FPSCounter.update$$anonfun$1$$anonfun$3(model, to));
            }
            return Outcome$.MODULE$.apply(() -> FPSCounter.update$$anonfun$1$$anonfun$4(model));
        };
    }

    public Outcome<SceneUpdateFragment> present(SubSystemFrameContext context, FPSCounterState model) {
        TextBox text = this.textBox.withText(new StringBuilder(4).append("FPS ").append(BoxesRunTime.boxToInteger((int)model.fps()).toString()).toString()).withColor(this.pickTint(this.idealFps, model.fps())).moveTo(model.position().$plus(2));
        Rectangle size = context.boundaryLocator().measureText(text);
        Size size2 = size.expand(2).size();
        Size boxSize = Size$.MODULE$.apply(size2.width() % 2 == 0 ? size2.width() : size2.width() + 1, size2.height() % 2 == 0 ? size2.height() : size2.height() + 1);
        Shape.Box bg = Shape.Box$.MODULE$.apply(Rectangle$.MODULE$.apply(model.position(), boxSize), (Fill)Fill.Color$.MODULE$.apply(RGBA$.MODULE$.Black().withAlpha(0.5)));
        return Outcome$.MODULE$.apply(() -> this.present$$anonfun$1(text, size, bg));
    }

    public RGBA pickTint(int targetFPS, int fps) {
        if ((double)fps > (double)targetFPS - (double)targetFPS * 0.05) {
            return RGBA$.MODULE$.Green();
        }
        if (fps > targetFPS / 2) {
            return RGBA$.MODULE$.Yellow();
        }
        return RGBA$.MODULE$.Red();
    }

    public FPSCounter copy(String id, Point startPosition, Option<Object> targetFPS, Option<String> layerKey, String fontFamily, int fontSize) {
        return new FPSCounter(id, startPosition, targetFPS, layerKey, fontFamily, fontSize);
    }

    public String copy$default$1() {
        return this.id();
    }

    public Point copy$default$2() {
        return this.startPosition();
    }

    public Option<Object> copy$default$3() {
        return this.targetFPS();
    }

    public Option<String> copy$default$4() {
        return this.layerKey();
    }

    public String copy$default$5() {
        return this.fontFamily();
    }

    public int copy$default$6() {
        return this.fontSize();
    }

    public String _1() {
        return this.id();
    }

    public Point _2() {
        return this.startPosition();
    }

    public Option<Object> _3() {
        return this.targetFPS();
    }

    public Option<String> _4() {
        return this.layerKey();
    }

    public String _5() {
        return this.fontFamily();
    }

    public int _6() {
        return this.fontSize();
    }

    private static final int $init$$$anonfun$1() {
        return FPS.package.FPS$.MODULE$.60();
    }

    private static final /* synthetic */ int $init$$$anonfun$2(int frameCountSinceInterval) {
        return frameCountSinceInterval + 1;
    }

    private static final /* synthetic */ int $init$$$anonfun$3(int target$1, int frameCountSinceInterval) {
        return Math.min(FPS.package.FPS$.MODULE$.toInt(target$1), frameCountSinceInterval + 1);
    }

    private final FPSCounterState initialModel$$anonfun$1() {
        return FPSCounterState$.MODULE$.initial(this.startPosition());
    }

    private final FPSCounterState update$$anonfun$1$$anonfun$1(SubSystemFrameContext context$2, FPSCounterState model$2) {
        int n = BoxesRunTime.unboxToInt((Object)this.decideNextFps.apply((Object)BoxesRunTime.boxToInteger((int)model$2.frameCountSinceInterval())));
        Point point = model$2.copy$default$1();
        return model$2.copy(point, n, context$2.gameTime().running(), 0);
    }

    private static final FPSCounterState update$$anonfun$1$$anonfun$2(FPSCounterState model$3) {
        int n = model$3.frameCountSinceInterval() + 1;
        Point point = model$3.copy$default$1();
        int n2 = model$3.copy$default$2();
        double d = model$3.copy$default$3();
        return model$3.copy(point, n2, d, n);
    }

    private static final FPSCounterState update$$anonfun$1$$anonfun$3(FPSCounterState model$4, Point to$1) {
        return model$4.copy(to$1, model$4.copy$default$2(), model$4.copy$default$3(), model$4.copy$default$4());
    }

    private static final FPSCounterState update$$anonfun$1$$anonfun$4(FPSCounterState model$5) {
        return model$5;
    }

    private final SceneUpdateFragment present$$anonfun$1(TextBox text$1, Rectangle size$1, Shape.Box bg$1) {
        Layer layer;
        Option<String> option = this.layerKey();
        if (None$.MODULE$.equals(option)) {
            layer = Layer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SceneNode[]{bg$1, text$1.withSize(size$1.size())}));
        } else if (option instanceof Some) {
            String key = (String)((Some)option).value();
            layer = Layer$.MODULE$.apply(key, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SceneNode[]{bg$1, text$1.withSize(size$1.size())}));
        } else {
            throw new MatchError(option);
        }
        return SceneUpdateFragment$.MODULE$.apply(layer);
    }

    public static final class Move
    implements GlobalEvent,
    Product,
    Serializable {
        private final Point to;

        public static Move apply(Point point) {
            return FPSCounter$Move$.MODULE$.apply(point);
        }

        public static Move fromProduct(Product product) {
            return FPSCounter$Move$.MODULE$.fromProduct(product);
        }

        public static Move unapply(Move move) {
            return FPSCounter$Move$.MODULE$.unapply(move);
        }

        public Move(Point to) {
            this.to = to;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Move)) return false;
            Move move = (Move)object;
            Point point = this.to();
            Point point2 = move.to();
            if (point != null) {
                if (!point.equals(point2)) return false;
                return true;
            }
            if (point2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Move;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Move";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "to";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Point to() {
            return this.to;
        }

        public Move copy(Point to) {
            return new Move(to);
        }

        public Point copy$default$1() {
            return this.to();
        }

        public Point _1() {
            return this.to();
        }
    }
}

