/*
 * Decompiled with CFR 0.152.
 */
package indigoextras.trees;

import indigo.shared.collections.Batch;
import indigo.shared.collections.Batch$;
import indigoextras.geometry.BoundingBox;
import indigoextras.geometry.LineSegment;
import indigoextras.geometry.Vertex;
import indigoextras.trees.QuadTree$;
import indigoextras.trees.QuadTree$QuadBranch$;
import indigoextras.trees.QuadTree$QuadEmpty$;
import indigoextras.trees.QuadTree$QuadLeaf$;
import java.io.Serializable;
import scala.CanEqual;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple4;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public interface QuadTree<T> {
    public static <T> QuadTree<T> apply(Batch<Tuple2<T, Vertex>> batch) {
        return QuadTree$.MODULE$.apply(batch);
    }

    public static <T> QuadTree<T> apply(Seq<Tuple2<T, Vertex>> seq) {
        return QuadTree$.MODULE$.apply(seq);
    }

    public static <T_$_L, T_$_R> CanEqual<QuadTree<T_$_L>, QuadTree<T_$_R>> derived$CanEqual(CanEqual<T_$_L, T_$_R> canEqual) {
        return QuadTree$.MODULE$.derived$CanEqual(canEqual);
    }

    public static <T> QuadTree<T> empty(double d, double d2) {
        return QuadTree$.MODULE$.empty(d, d2);
    }

    public static <T> QuadTree<T> empty(Vertex vertex) {
        return QuadTree$.MODULE$.empty(vertex);
    }

    public static <T> CanEqual<Batch<QuadTree<T>>, Batch<QuadTree<T>>> given_CanEqual_Batch_Batch(CanEqual<T, T> canEqual) {
        return QuadTree$.MODULE$.given_CanEqual_Batch_Batch(canEqual);
    }

    public static <T> CanEqual<Option<QuadTree<T>>, Option<QuadTree<T>>> given_CanEqual_Option_Option(CanEqual<T, T> canEqual) {
        return QuadTree$.MODULE$.given_CanEqual_Option_Option(canEqual);
    }

    public static <T> QuadTree<T> insertElementAt(Vertex vertex, QuadTree<T> quadTree, T t) {
        return QuadTree$.MODULE$.insertElementAt(vertex, quadTree, t);
    }

    public static int ordinal(QuadTree<?> quadTree) {
        return QuadTree$.MODULE$.ordinal(quadTree);
    }

    public BoundingBox bounds();

    public boolean isEmpty();

    public static Option fetchElementAt$(QuadTree $this, Vertex vertex, CanEqual x$2) {
        return $this.fetchElementAt(vertex, x$2);
    }

    default public Option<T> fetchElementAt(Vertex vertex, CanEqual<T, T> x$2) {
        return QuadTree$.MODULE$.fetchElementAt(this, vertex, x$2);
    }

    public static QuadTree insertElement$(QuadTree $this, Object element, Vertex vertex) {
        return $this.insertElement(element, vertex);
    }

    default public QuadTree<T> insertElement(T element, Vertex vertex) {
        return QuadTree$.MODULE$.insertElementAt(vertex, this, element);
    }

    public static QuadTree insertElements$(QuadTree $this, Seq elements) {
        return $this.insertElements(elements);
    }

    default public QuadTree<T> insertElements(Seq<Tuple2<T, Vertex>> elements) {
        return this.insertElements(Batch$.MODULE$.fromSeq(elements));
    }

    public static QuadTree insertElements$(QuadTree $this, Batch elements) {
        return $this.insertElements(elements);
    }

    default public QuadTree<T> insertElements(Batch<Tuple2<T, Vertex>> elements) {
        return (QuadTree)elements.foldLeft((Object)this, (Function2 & Serializable)(acc, item) -> acc.insertElement(item._1(), (Vertex)item._2()));
    }

    public static QuadTree removeElement$(QuadTree $this, Vertex vertex) {
        return $this.removeElement(vertex);
    }

    default public QuadTree<T> removeElement(Vertex vertex) {
        return QuadTree$.MODULE$.removeElement(this, vertex);
    }

    public static Batch toBatch$(QuadTree $this, CanEqual x$1) {
        return $this.toBatch(x$1);
    }

    default public Batch<T> toBatch(CanEqual<T, T> x$1) {
        return QuadTree$.MODULE$.toBatch(this, (Function1 & Serializable)_$1 -> true, x$1);
    }

    public static Batch toBatch$(QuadTree $this, Function1 p, CanEqual x$2) {
        return $this.toBatch(p, x$2);
    }

    default public Batch<T> toBatch(Function1<T, Object> p, CanEqual<T, T> x$2) {
        return QuadTree$.MODULE$.toBatch(this, p, x$2);
    }

    public static Batch toBatchWithPosition$(QuadTree $this, CanEqual x$1) {
        return $this.toBatchWithPosition(x$1);
    }

    default public Batch<Tuple2<Vertex, T>> toBatchWithPosition(CanEqual<T, T> x$1) {
        return QuadTree$.MODULE$.toBatchWithPosition(this, (Function1 & Serializable)_$2 -> true, x$1);
    }

    public static Batch toBatchWithPosition$(QuadTree $this, Function1 p, CanEqual x$2) {
        return $this.toBatchWithPosition(p, x$2);
    }

    default public Batch<Tuple2<Vertex, T>> toBatchWithPosition(Function1<T, Object> p, CanEqual<T, T> x$2) {
        return QuadTree$.MODULE$.toBatchWithPosition(this, p, x$2);
    }

    public static QuadTree prune$(QuadTree $this) {
        return $this.prune();
    }

    default public QuadTree<T> prune() {
        return QuadTree$.MODULE$.prune(this);
    }

    public static Option searchByPoint$(QuadTree $this, Vertex point, CanEqual x$2) {
        return $this.searchByPoint(point, x$2);
    }

    default public Option<T> searchByPoint(Vertex point, CanEqual<T, T> x$2) {
        return QuadTree$.MODULE$.findClosestTo(this, point, x$2);
    }

    public static Option findClosestTo$(QuadTree $this, Vertex vertex, CanEqual x$2) {
        return $this.findClosestTo(vertex, x$2);
    }

    default public Option<T> findClosestTo(Vertex vertex, CanEqual<T, T> x$2) {
        return QuadTree$.MODULE$.findClosestTo(this, vertex, x$2);
    }

    public static Option findClosestToWithPosition$(QuadTree $this, Vertex vertex, CanEqual x$2) {
        return $this.findClosestToWithPosition(vertex, x$2);
    }

    default public Option<Tuple2<Vertex, T>> findClosestToWithPosition(Vertex vertex, CanEqual<T, T> x$2) {
        return QuadTree$.MODULE$.findClosestToWithPosition(this, vertex, x$2);
    }

    public static Batch searchByLine$(QuadTree $this, Vertex start, Vertex end, CanEqual x$3) {
        return $this.searchByLine(start, end, x$3);
    }

    default public Batch<T> searchByLine(Vertex start, Vertex end, CanEqual<T, T> x$3) {
        return QuadTree$.MODULE$.searchByLine(this, start, end, x$3);
    }

    public static Batch searchByLine$(QuadTree $this, LineSegment line, CanEqual x$2) {
        return $this.searchByLine(line, x$2);
    }

    default public Batch<T> searchByLine(LineSegment line, CanEqual<T, T> x$2) {
        return QuadTree$.MODULE$.searchByLine(this, line, x$2);
    }

    public static Batch searchByLineWithPosition$(QuadTree $this, Vertex start, Vertex end, CanEqual x$3) {
        return $this.searchByLineWithPosition(start, end, x$3);
    }

    default public Batch<Tuple2<Vertex, T>> searchByLineWithPosition(Vertex start, Vertex end, CanEqual<T, T> x$3) {
        return QuadTree$.MODULE$.searchByLineWithPosition(this, start, end, x$3);
    }

    public static Batch searchByLineWithPosition$(QuadTree $this, LineSegment line, CanEqual x$2) {
        return $this.searchByLineWithPosition(line, x$2);
    }

    default public Batch<Tuple2<Vertex, T>> searchByLineWithPosition(LineSegment line, CanEqual<T, T> x$2) {
        return QuadTree$.MODULE$.searchByLineWithPosition(this, line, x$2);
    }

    public static Batch searchByRectangle$(QuadTree $this, BoundingBox boundingBox, CanEqual x$2) {
        return $this.searchByRectangle(boundingBox, x$2);
    }

    default public Batch<T> searchByRectangle(BoundingBox boundingBox, CanEqual<T, T> x$2) {
        return QuadTree$.MODULE$.searchByBoundingBox(this, boundingBox, x$2);
    }

    public static Batch searchByBoundingBox$(QuadTree $this, BoundingBox boundingBox, CanEqual x$2) {
        return $this.searchByBoundingBox(boundingBox, x$2);
    }

    default public Batch<T> searchByBoundingBox(BoundingBox boundingBox, CanEqual<T, T> x$2) {
        return QuadTree$.MODULE$.searchByBoundingBox(this, boundingBox, x$2);
    }

    public static Batch searchByBoundingBoxWithPosition$(QuadTree $this, BoundingBox boundingBox, CanEqual x$2) {
        return $this.searchByBoundingBoxWithPosition(boundingBox, x$2);
    }

    default public Batch<Tuple2<Vertex, T>> searchByBoundingBoxWithPosition(BoundingBox boundingBox, CanEqual<T, T> x$2) {
        return QuadTree$.MODULE$.searchByBoundingBoxWithPosition(this, boundingBox, x$2);
    }

    public static String prettyPrint$(QuadTree $this) {
        return $this.prettyPrint();
    }

    default public String prettyPrint() {
        return QuadTree.rec$1(this, "");
    }

    public static boolean $eq$eq$eq$(QuadTree $this, QuadTree other, CanEqual x$2) {
        return $this.$eq$eq$eq(other, x$2);
    }

    default public boolean $eq$eq$eq(QuadTree<T> other, CanEqual<T, T> x$2) {
        return QuadTree.rec$2((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new QuadTree[]{this})), (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new QuadTree[]{other})));
    }

    public static boolean $bang$eq$eq$(QuadTree $this, QuadTree other, CanEqual x$2) {
        return $this.$bang$eq$eq(other, x$2);
    }

    default public boolean $bang$eq$eq(QuadTree<T> other, CanEqual<T, T> x$2) {
        return !this.$eq$eq$eq(other, x$2);
    }

    private static String rec$1(QuadTree quadTree, String indent) {
        QuadTree quadTree2 = quadTree;
        if (quadTree2 instanceof QuadEmpty) {
            BoundingBox boundingBox;
            QuadEmpty quadEmpty = QuadTree$QuadEmpty$.MODULE$.unapply((QuadEmpty)quadTree2);
            BoundingBox bounds = boundingBox = quadEmpty._1();
            return new StringBuilder(0).append(indent).append(new StringBuilder(8).append("Empty [").append(bounds.toString()).append("]").toString()).toString();
        }
        if (quadTree2 instanceof QuadLeaf) {
            QuadLeaf quadLeaf = QuadTree$QuadLeaf$.MODULE$.unapply((QuadLeaf)quadTree2);
            BoundingBox boundingBox = quadLeaf._1();
            Vertex vertex = quadLeaf._2();
            Object t = quadLeaf._3();
            BoundingBox bounds = boundingBox;
            Vertex exactPosition = vertex;
            Object value = t;
            return new StringBuilder(0).append(indent).append(new StringBuilder(13).append("Leaf [").append(bounds.toString()).append("] - ").append(exactPosition.toString()).append(" - ").append(value.toString()).toString()).toString();
        }
        if (quadTree2 instanceof QuadBranch) {
            QuadBranch quadBranch = QuadTree$QuadBranch$.MODULE$.unapply((QuadBranch)quadTree2);
            BoundingBox boundingBox = quadBranch._1();
            QuadTree quadTree3 = quadBranch._2();
            QuadTree quadTree4 = quadBranch._3();
            QuadTree quadTree5 = quadBranch._4();
            QuadTree quadTree6 = quadBranch._5();
            BoundingBox bounds = boundingBox;
            QuadTree a = quadTree3;
            QuadTree b = quadTree4;
            QuadTree c = quadTree5;
            QuadTree d = quadTree6;
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(69).append(indent).append("Branch [").append(bounds.toString()).append("]\n             |").append(QuadTree.rec$1(a, new StringBuilder(2).append(indent).append("  ").toString())).append("\n             |").append(QuadTree.rec$1(b, new StringBuilder(2).append(indent).append("  ").toString())).append("\n             |").append(QuadTree.rec$1(c, new StringBuilder(2).append(indent).append("  ").toString())).append("\n             |").append(QuadTree.rec$1(d, new StringBuilder(2).append(indent).append("  ").toString())).toString()));
        }
        throw new MatchError((Object)quadTree2);
    }

    private static boolean rec$2(List a, List b) {
        Tuple2 tuple2;
        while ((tuple2 = Tuple2$.MODULE$.apply((Object)a, (Object)b)) != null) {
            List list = (List)tuple2._1();
            List list2 = (List)tuple2._2();
            Nil$ nil$ = package$.MODULE$.Nil();
            List list3 = list;
            if (!(nil$ != null ? !nil$.equals(list3) : list3 != null)) {
                Nil$ nil$2 = package$.MODULE$.Nil();
                List list4 = list2;
                return !(nil$2 != null ? !nil$2.equals(list4) : list4 != null);
            }
            Nil$ nil$3 = package$.MODULE$.Nil();
            List list5 = list2;
            if (!(nil$3 != null ? !nil$3.equals(list5) : list5 != null)) {
                return false;
            }
            if (!(list instanceof .colon.colon)) break;
            .colon.colon colon2 = (.colon.colon)list;
            QuadTree quadTree = (QuadTree)colon2.head();
            List list6 = colon2.next$access$1();
            if (quadTree instanceof QuadEmpty) {
                BoundingBox boundingBox;
                QuadEmpty quadEmpty = QuadTree$QuadEmpty$.MODULE$.unapply((QuadEmpty)quadTree);
                BoundingBox b1 = boundingBox = quadEmpty._1();
                List as = list6;
                if (list2 instanceof .colon.colon) {
                    .colon.colon colon3 = (.colon.colon)list2;
                    QuadTree quadTree2 = (QuadTree)colon3.head();
                    List list7 = colon3.next$access$1();
                    if (quadTree2 instanceof QuadEmpty) {
                        BoundingBox boundingBox2;
                        QuadEmpty quadEmpty2 = QuadTree$QuadEmpty$.MODULE$.unapply((QuadEmpty)quadTree2);
                        BoundingBox b2 = boundingBox2 = quadEmpty2._1();
                        List bs = list7;
                        if (b1.$tilde$eq$eq(b2)) {
                            List list8 = as;
                            List list9 = bs;
                            a = list8;
                            b = list9;
                            continue;
                        }
                    }
                }
            }
            if (quadTree instanceof QuadLeaf) {
                QuadLeaf quadLeaf = QuadTree$QuadLeaf$.MODULE$.unapply((QuadLeaf)quadTree);
                BoundingBox boundingBox = quadLeaf._1();
                Vertex vertex = quadLeaf._2();
                Object t = quadLeaf._3();
                BoundingBox b1 = boundingBox;
                Vertex p1 = vertex;
                Object v1 = t;
                List as = list6;
                if (list2 instanceof .colon.colon) {
                    .colon.colon colon4 = (.colon.colon)list2;
                    QuadTree quadTree3 = (QuadTree)colon4.head();
                    List list10 = colon4.next$access$1();
                    if (quadTree3 instanceof QuadLeaf) {
                        QuadLeaf quadLeaf2 = QuadTree$QuadLeaf$.MODULE$.unapply((QuadLeaf)quadTree3);
                        BoundingBox boundingBox3 = quadLeaf2._1();
                        Vertex vertex2 = quadLeaf2._2();
                        Object t2 = quadLeaf2._3();
                        BoundingBox b2 = boundingBox3;
                        Vertex p2 = vertex2;
                        Object v2 = t2;
                        List bs = list10;
                        if (b1.$tilde$eq$eq(b2) && p1.$tilde$eq$eq(p2) && BoxesRunTime.equals(v1, v2)) {
                            List list11 = as;
                            List list12 = bs;
                            a = list11;
                            b = list12;
                            continue;
                        }
                    }
                }
            }
            if (!(quadTree instanceof QuadBranch)) break;
            QuadBranch quadBranch = QuadTree$QuadBranch$.MODULE$.unapply((QuadBranch)quadTree);
            BoundingBox boundingBox = quadBranch._1();
            QuadTree quadTree4 = quadBranch._2();
            QuadTree quadTree5 = quadBranch._3();
            QuadTree quadTree6 = quadBranch._4();
            QuadTree quadTree7 = quadBranch._5();
            BoundingBox bounds1 = boundingBox;
            QuadTree a1 = quadTree4;
            QuadTree b1 = quadTree5;
            QuadTree c1 = quadTree6;
            QuadTree d1 = quadTree7;
            List as = list6;
            if (!(list2 instanceof .colon.colon)) break;
            .colon.colon colon5 = (.colon.colon)list2;
            QuadTree quadTree8 = (QuadTree)colon5.head();
            List list13 = colon5.next$access$1();
            if (!(quadTree8 instanceof QuadBranch)) break;
            QuadBranch quadBranch2 = QuadTree$QuadBranch$.MODULE$.unapply((QuadBranch)quadTree8);
            BoundingBox boundingBox4 = quadBranch2._1();
            QuadTree quadTree9 = quadBranch2._2();
            QuadTree quadTree10 = quadBranch2._3();
            QuadTree quadTree11 = quadBranch2._4();
            QuadTree quadTree12 = quadBranch2._5();
            BoundingBox bounds2 = boundingBox4;
            QuadTree a2 = quadTree9;
            QuadTree b2 = quadTree10;
            QuadTree c2 = quadTree11;
            QuadTree d2 = quadTree12;
            List bs = list13;
            if (!bounds1.$tilde$eq$eq(bounds2)) break;
            List list14 = as.$colon$colon(d1).$colon$colon(c1).$colon$colon(b1).$colon$colon(a1);
            List list15 = bs.$colon$colon(d2).$colon$colon(c2).$colon$colon(b2).$colon$colon(a2);
            a = list14;
            b = list15;
        }
        return false;
    }

    public static final class QuadBranch<T>
    implements QuadTree<T>,
    Product,
    Serializable {
        private final BoundingBox bounds;
        private final QuadTree a;
        private final QuadTree b;
        private final QuadTree c;
        private final QuadTree d;

        public static <T> QuadBranch<T> apply(BoundingBox boundingBox, QuadTree<T> quadTree, QuadTree<T> quadTree2, QuadTree<T> quadTree3, QuadTree<T> quadTree4) {
            return QuadTree$QuadBranch$.MODULE$.apply(boundingBox, quadTree, quadTree2, quadTree3, quadTree4);
        }

        public static <T> QuadBranch<T> fromBounds(BoundingBox boundingBox) {
            return QuadTree$QuadBranch$.MODULE$.fromBounds(boundingBox);
        }

        public static <T> QuadBranch<T> fromBoundsAndQuads(BoundingBox boundingBox, Tuple4<BoundingBox, BoundingBox, BoundingBox, BoundingBox> tuple4) {
            return QuadTree$QuadBranch$.MODULE$.fromBoundsAndQuads(boundingBox, tuple4);
        }

        public static QuadBranch<?> fromProduct(Product product) {
            return QuadTree$QuadBranch$.MODULE$.fromProduct(product);
        }

        public static Tuple4<BoundingBox, BoundingBox, BoundingBox, BoundingBox> subdivide(BoundingBox boundingBox) {
            return QuadTree$QuadBranch$.MODULE$.subdivide(boundingBox);
        }

        public static <T> QuadBranch<T> unapply(QuadBranch<T> quadBranch) {
            return QuadTree$QuadBranch$.MODULE$.unapply(quadBranch);
        }

        public QuadBranch(BoundingBox bounds, QuadTree<T> a, QuadTree<T> b, QuadTree<T> c, QuadTree<T> d) {
            this.bounds = bounds;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof QuadBranch)) return false;
            QuadBranch quadBranch = (QuadBranch)object;
            BoundingBox boundingBox = this.bounds();
            BoundingBox boundingBox2 = quadBranch.bounds();
            if (boundingBox == null) {
                if (boundingBox2 != null) {
                    return false;
                }
            } else if (!((Object)boundingBox).equals(boundingBox2)) return false;
            QuadTree<T> quadTree = this.a();
            QuadTree<T> quadTree2 = quadBranch.a();
            if (quadTree == null) {
                if (quadTree2 != null) {
                    return false;
                }
            } else if (!quadTree.equals(quadTree2)) return false;
            QuadTree<T> quadTree3 = this.b();
            QuadTree<T> quadTree4 = quadBranch.b();
            if (quadTree3 == null) {
                if (quadTree4 != null) {
                    return false;
                }
            } else if (!quadTree3.equals(quadTree4)) return false;
            QuadTree<T> quadTree5 = this.c();
            QuadTree<T> quadTree6 = quadBranch.c();
            if (quadTree5 == null) {
                if (quadTree6 != null) {
                    return false;
                }
            } else if (!quadTree5.equals(quadTree6)) return false;
            QuadTree<T> quadTree7 = this.d();
            QuadTree<T> quadTree8 = quadBranch.d();
            if (quadTree7 == null) {
                if (quadTree8 == null) return true;
                return false;
            } else {
                if (!quadTree7.equals(quadTree8)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof QuadBranch;
        }

        public int productArity() {
            return 5;
        }

        public String productPrefix() {
            return "QuadBranch";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "bounds";
                }
                case 1: {
                    return "a";
                }
                case 2: {
                    return "b";
                }
                case 3: {
                    return "c";
                }
                case 4: {
                    return "d";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public BoundingBox bounds() {
            return this.bounds;
        }

        public QuadTree<T> a() {
            return this.a;
        }

        public QuadTree<T> b() {
            return this.b;
        }

        public QuadTree<T> c() {
            return this.c;
        }

        public QuadTree<T> d() {
            return this.d;
        }

        @Override
        public boolean isEmpty() {
            return this.a().isEmpty() && this.b().isEmpty() && this.c().isEmpty() && this.d().isEmpty();
        }

        public <T> QuadBranch<T> copy(BoundingBox bounds, QuadTree<T> a, QuadTree<T> b, QuadTree<T> c, QuadTree<T> d) {
            return new QuadBranch<T>(bounds, a, b, c, d);
        }

        public <T> BoundingBox copy$default$1() {
            return this.bounds();
        }

        public <T> QuadTree<T> copy$default$2() {
            return this.a();
        }

        public <T> QuadTree<T> copy$default$3() {
            return this.b();
        }

        public <T> QuadTree<T> copy$default$4() {
            return this.c();
        }

        public <T> QuadTree<T> copy$default$5() {
            return this.d();
        }

        public BoundingBox _1() {
            return this.bounds();
        }

        public QuadTree<T> _2() {
            return this.a();
        }

        public QuadTree<T> _3() {
            return this.b();
        }

        public QuadTree<T> _4() {
            return this.c();
        }

        public QuadTree<T> _5() {
            return this.d();
        }
    }

    public static final class QuadEmpty<T>
    implements QuadTree<T>,
    Product,
    Serializable {
        private final BoundingBox bounds;

        public static <T> QuadEmpty<T> apply(BoundingBox boundingBox) {
            return QuadTree$QuadEmpty$.MODULE$.apply(boundingBox);
        }

        public static QuadEmpty<?> fromProduct(Product product) {
            return QuadTree$QuadEmpty$.MODULE$.fromProduct(product);
        }

        public static <T> QuadEmpty<T> unapply(QuadEmpty<T> quadEmpty) {
            return QuadTree$QuadEmpty$.MODULE$.unapply(quadEmpty);
        }

        public QuadEmpty(BoundingBox bounds) {
            this.bounds = bounds;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof QuadEmpty)) return false;
            QuadEmpty quadEmpty = (QuadEmpty)object;
            BoundingBox boundingBox = this.bounds();
            BoundingBox boundingBox2 = quadEmpty.bounds();
            if (boundingBox != null) {
                if (!((Object)boundingBox).equals(boundingBox2)) return false;
                return true;
            }
            if (boundingBox2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof QuadEmpty;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "QuadEmpty";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "bounds";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public BoundingBox bounds() {
            return this.bounds;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        public <T> QuadEmpty<T> copy(BoundingBox bounds) {
            return new QuadEmpty<T>(bounds);
        }

        public <T> BoundingBox copy$default$1() {
            return this.bounds();
        }

        public BoundingBox _1() {
            return this.bounds();
        }
    }

    public static final class QuadLeaf<T>
    implements QuadTree<T>,
    Product,
    Serializable {
        private final BoundingBox bounds;
        private final Vertex exactPosition;
        private final Object value;

        public static <T> QuadLeaf<T> apply(BoundingBox boundingBox, Vertex vertex, T t) {
            return QuadTree$QuadLeaf$.MODULE$.apply(boundingBox, vertex, t);
        }

        public static QuadLeaf<?> fromProduct(Product product) {
            return QuadTree$QuadLeaf$.MODULE$.fromProduct(product);
        }

        public static <T> QuadLeaf<T> unapply(QuadLeaf<T> quadLeaf) {
            return QuadTree$QuadLeaf$.MODULE$.unapply(quadLeaf);
        }

        public QuadLeaf(BoundingBox bounds, Vertex exactPosition, T value) {
            this.bounds = bounds;
            this.exactPosition = exactPosition;
            this.value = value;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof QuadLeaf)) return false;
            QuadLeaf quadLeaf = (QuadLeaf)object;
            BoundingBox boundingBox = this.bounds();
            BoundingBox boundingBox2 = quadLeaf.bounds();
            if (boundingBox == null) {
                if (boundingBox2 != null) {
                    return false;
                }
            } else if (!((Object)boundingBox).equals(boundingBox2)) return false;
            Vertex vertex = this.exactPosition();
            Vertex vertex2 = quadLeaf.exactPosition();
            if (vertex == null) {
                if (vertex2 != null) {
                    return false;
                }
            } else if (!((Object)vertex).equals(vertex2)) return false;
            if (!BoxesRunTime.equals(this.value(), quadLeaf.value())) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof QuadLeaf;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "QuadLeaf";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "bounds";
                }
                case 1: {
                    return "exactPosition";
                }
                case 2: {
                    return "value";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public BoundingBox bounds() {
            return this.bounds;
        }

        public Vertex exactPosition() {
            return this.exactPosition;
        }

        public T value() {
            return (T)this.value;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        public <T> QuadLeaf<T> copy(BoundingBox bounds, Vertex exactPosition, T value) {
            return new QuadLeaf<T>(bounds, exactPosition, value);
        }

        public <T> BoundingBox copy$default$1() {
            return this.bounds();
        }

        public <T> Vertex copy$default$2() {
            return this.exactPosition();
        }

        public <T> T copy$default$3() {
            return this.value();
        }

        public BoundingBox _1() {
            return this.bounds();
        }

        public Vertex _2() {
            return this.exactPosition();
        }

        public T _3() {
            return this.value();
        }
    }
}

