/*
 * Decompiled with CFR 0.152.
 */
package indigoextras.ui;

import indigo.shared.Outcome;
import indigo.shared.Outcome$;
import indigo.shared.collections.Batch;
import indigo.shared.collections.Batch$;
import indigo.shared.datatypes.Point;
import indigo.shared.datatypes.Point$;
import indigo.shared.datatypes.Rectangle;
import indigo.shared.datatypes.Size;
import indigo.shared.datatypes.Size$;
import indigo.shared.events.GlobalEvent;
import indigo.shared.input.Mouse;
import indigo.shared.scenegraph.Graphic;
import indigo.shared.scenegraph.Group;
import indigo.shared.scenegraph.SceneNode;
import indigo.shared.scenegraph.Shape;
import indigo.shared.scenegraph.Sprite;
import indigo.shared.scenegraph.Text;
import indigo.shared.scenegraph.TextBox;
import indigoextras.ui.Button$;
import indigoextras.ui.ButtonAssets;
import indigoextras.ui.ButtonState;
import indigoextras.ui.ButtonState$Down$;
import indigoextras.ui.ButtonState$Over$;
import indigoextras.ui.ButtonState$Up$;
import java.io.Serializable;
import scala.CanEqual;
import scala.Function0;
import scala.MatchError;
import scala.Product;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class Button
implements Product,
Serializable {
    private final ButtonAssets buttonAssets;
    private final Rectangle bounds;
    private final int depth;
    private final ButtonState state;
    private final Function0 onUp;
    private final Function0 onDown;
    private final Function0 onHoverOver;
    private final Function0 onHoverOut;
    private final Function0 onClick;
    private final Function0 onHoldDown;

    public static Button apply(ButtonAssets buttonAssets, Rectangle rectangle, int n) {
        return Button$.MODULE$.apply(buttonAssets, rectangle, n);
    }

    public static Button apply(ButtonAssets buttonAssets, Rectangle rectangle, int n, ButtonState buttonState, Function0<Batch<GlobalEvent>> function0, Function0<Batch<GlobalEvent>> function02, Function0<Batch<GlobalEvent>> function03, Function0<Batch<GlobalEvent>> function04, Function0<Batch<GlobalEvent>> function05, Function0<Batch<GlobalEvent>> function06) {
        return Button$.MODULE$.apply(buttonAssets, rectangle, n, buttonState, function0, function02, function03, function04, function05, function06);
    }

    public static CanEqual<Button, Button> derived$CanEqual() {
        return Button$.MODULE$.derived$CanEqual();
    }

    public static Button fromProduct(Product product) {
        return Button$.MODULE$.fromProduct(product);
    }

    public static Button unapply(Button button) {
        return Button$.MODULE$.unapply(button);
    }

    public Button(ButtonAssets buttonAssets, Rectangle bounds, int depth, ButtonState state, Function0<Batch<GlobalEvent>> onUp, Function0<Batch<GlobalEvent>> onDown, Function0<Batch<GlobalEvent>> onHoverOver, Function0<Batch<GlobalEvent>> onHoverOut, Function0<Batch<GlobalEvent>> onClick, Function0<Batch<GlobalEvent>> onHoldDown) {
        this.buttonAssets = buttonAssets;
        this.bounds = bounds;
        this.depth = depth;
        this.state = state;
        this.onUp = onUp;
        this.onDown = onDown;
        this.onHoverOver = onHoverOver;
        this.onHoverOut = onHoverOut;
        this.onClick = onClick;
        this.onHoldDown = onHoldDown;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Button)) return false;
        Button button = (Button)object;
        ButtonAssets buttonAssets = this.buttonAssets();
        ButtonAssets buttonAssets2 = button.buttonAssets();
        if (buttonAssets == null) {
            if (buttonAssets2 != null) {
                return false;
            }
        } else if (!((Object)buttonAssets).equals(buttonAssets2)) return false;
        Rectangle rectangle = this.bounds();
        Rectangle rectangle2 = button.bounds();
        if (rectangle == null) {
            if (rectangle2 != null) {
                return false;
            }
        } else if (!rectangle.equals(rectangle2)) return false;
        if (this.depth() != button.depth()) return false;
        ButtonState buttonState = this.state();
        ButtonState buttonState2 = button.state();
        if (buttonState == null) {
            if (buttonState2 != null) {
                return false;
            }
        } else if (!buttonState.equals(buttonState2)) return false;
        Function0<Batch<GlobalEvent>> function0 = this.onUp();
        Function0<Batch<GlobalEvent>> function02 = button.onUp();
        if (function0 == null) {
            if (function02 != null) {
                return false;
            }
        } else if (!function0.equals(function02)) return false;
        Function0<Batch<GlobalEvent>> function03 = this.onDown();
        Function0<Batch<GlobalEvent>> function04 = button.onDown();
        if (function03 == null) {
            if (function04 != null) {
                return false;
            }
        } else if (!function03.equals(function04)) return false;
        Function0<Batch<GlobalEvent>> function05 = this.onHoverOver();
        Function0<Batch<GlobalEvent>> function06 = button.onHoverOver();
        if (function05 == null) {
            if (function06 != null) {
                return false;
            }
        } else if (!function05.equals(function06)) return false;
        Function0<Batch<GlobalEvent>> function07 = this.onHoverOut();
        Function0<Batch<GlobalEvent>> function08 = button.onHoverOut();
        if (function07 == null) {
            if (function08 != null) {
                return false;
            }
        } else if (!function07.equals(function08)) return false;
        Function0<Batch<GlobalEvent>> function09 = this.onClick();
        Function0<Batch<GlobalEvent>> function010 = button.onClick();
        if (function09 == null) {
            if (function010 != null) {
                return false;
            }
        } else if (!function09.equals(function010)) return false;
        Function0<Batch<GlobalEvent>> function011 = this.onHoldDown();
        Function0<Batch<GlobalEvent>> function012 = button.onHoldDown();
        if (function011 == null) {
            if (function012 == null) return true;
            return false;
        } else {
            if (!function011.equals(function012)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof Button;
    }

    public int productArity() {
        return 10;
    }

    public String productPrefix() {
        return "Button";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return BoxesRunTime.boxToInteger((int)this._3());
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return this._5();
            }
            case 5: {
                return this._6();
            }
            case 6: {
                return this._7();
            }
            case 7: {
                return this._8();
            }
            case 8: {
                return this._9();
            }
            case 9: {
                return this._10();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "buttonAssets";
            }
            case 1: {
                return "bounds";
            }
            case 2: {
                return "depth";
            }
            case 3: {
                return "state";
            }
            case 4: {
                return "onUp";
            }
            case 5: {
                return "onDown";
            }
            case 6: {
                return "onHoverOver";
            }
            case 7: {
                return "onHoverOut";
            }
            case 8: {
                return "onClick";
            }
            case 9: {
                return "onHoldDown";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public ButtonAssets buttonAssets() {
        return this.buttonAssets;
    }

    public Rectangle bounds() {
        return this.bounds;
    }

    public int depth() {
        return this.depth;
    }

    public ButtonState state() {
        return this.state;
    }

    public Function0<Batch<GlobalEvent>> onUp() {
        return this.onUp;
    }

    public Function0<Batch<GlobalEvent>> onDown() {
        return this.onDown;
    }

    public Function0<Batch<GlobalEvent>> onHoverOver() {
        return this.onHoverOver;
    }

    public Function0<Batch<GlobalEvent>> onHoverOut() {
        return this.onHoverOut;
    }

    public Function0<Batch<GlobalEvent>> onClick() {
        return this.onClick;
    }

    public Function0<Batch<GlobalEvent>> onHoldDown() {
        return this.onHoldDown;
    }

    public Button moveBy(Point point) {
        Rectangle rectangle = this.bounds().moveBy(point);
        ButtonAssets buttonAssets = this.copy$default$1();
        int n = this.copy$default$3();
        ButtonState buttonState = this.copy$default$4();
        Function0<Batch<GlobalEvent>> function0 = this.copy$default$5();
        Function0<Batch<GlobalEvent>> function02 = this.copy$default$6();
        Function0<Batch<GlobalEvent>> function03 = this.copy$default$7();
        Function0<Batch<GlobalEvent>> function04 = this.copy$default$8();
        Function0<Batch<GlobalEvent>> function05 = this.copy$default$9();
        Function0<Batch<GlobalEvent>> function06 = this.copy$default$10();
        return this.copy(buttonAssets, rectangle, n, buttonState, function0, function02, function03, function04, function05, function06);
    }

    public Button moveBy(int x, int y) {
        return this.moveBy(Point$.MODULE$.apply(x, y));
    }

    public Button moveTo(Point point) {
        Rectangle rectangle = this.bounds().moveTo(point);
        ButtonAssets buttonAssets = this.copy$default$1();
        int n = this.copy$default$3();
        ButtonState buttonState = this.copy$default$4();
        Function0<Batch<GlobalEvent>> function0 = this.copy$default$5();
        Function0<Batch<GlobalEvent>> function02 = this.copy$default$6();
        Function0<Batch<GlobalEvent>> function03 = this.copy$default$7();
        Function0<Batch<GlobalEvent>> function04 = this.copy$default$8();
        Function0<Batch<GlobalEvent>> function05 = this.copy$default$9();
        Function0<Batch<GlobalEvent>> function06 = this.copy$default$10();
        return this.copy(buttonAssets, rectangle, n, buttonState, function0, function02, function03, function04, function05, function06);
    }

    public Button moveTo(int x, int y) {
        return this.moveTo(Point$.MODULE$.apply(x, y));
    }

    public Button resize(Size newSize) {
        Rectangle rectangle = this.bounds().resize(newSize);
        ButtonAssets buttonAssets = this.copy$default$1();
        int n = this.copy$default$3();
        ButtonState buttonState = this.copy$default$4();
        Function0<Batch<GlobalEvent>> function0 = this.copy$default$5();
        Function0<Batch<GlobalEvent>> function02 = this.copy$default$6();
        Function0<Batch<GlobalEvent>> function03 = this.copy$default$7();
        Function0<Batch<GlobalEvent>> function04 = this.copy$default$8();
        Function0<Batch<GlobalEvent>> function05 = this.copy$default$9();
        Function0<Batch<GlobalEvent>> function06 = this.copy$default$10();
        return this.copy(buttonAssets, rectangle, n, buttonState, function0, function02, function03, function04, function05, function06);
    }

    public Button resize(int x, int y) {
        return this.resize(Size$.MODULE$.apply(x, y));
    }

    public Button withBounds(Rectangle newBounds) {
        return this.copy(this.copy$default$1(), newBounds, this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10());
    }

    public Button withDepth(int newDepth) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), newDepth, this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10());
    }

    public Outcome<Button> update(Mouse mouse) {
        boolean mouseInBounds = this.bounds().isPointWithin(mouse.position());
        Batch upEvents = mouseInBounds && mouse.mouseReleased() ? (Batch)this.onUp().apply() : Batch$.MODULE$.empty();
        Batch clickEvents = mouseInBounds && mouse.mouseClicked() ? (Batch)this.onClick().apply() : Batch$.MODULE$.empty();
        Batch downEvents = mouseInBounds && mouse.mousePressed() ? (Batch)this.onDown().apply() : Batch$.MODULE$.empty();
        Batch mouseButtonEvents = downEvents.$plus$plus(upEvents).$plus$plus(clickEvents);
        ButtonState buttonState = this.state();
        if (ButtonState$Down$.MODULE$.equals(buttonState) && mouseInBounds && mouse.isLeftDown()) {
            return Outcome$.MODULE$.apply(this::update$$anonfun$1).addGlobalEvents(() -> this.update$$anonfun$2(mouseButtonEvents));
        }
        if (ButtonState$Up$.MODULE$.equals(buttonState) && mouseInBounds && mouse.mousePressed()) {
            return Outcome$.MODULE$.apply(this::update$$anonfun$3).addGlobalEvents(() -> this.update$$anonfun$4(mouseButtonEvents));
        }
        if (ButtonState$Over$.MODULE$.equals(buttonState) && mouseInBounds && mouse.mousePressed()) {
            return Outcome$.MODULE$.apply(this::update$$anonfun$5).addGlobalEvents(() -> Button.update$$anonfun$6(mouseButtonEvents));
        }
        if (ButtonState$Down$.MODULE$.equals(buttonState)) {
            if (mouseInBounds && !mouse.isLeftDown()) {
                return Outcome$.MODULE$.apply(this::update$$anonfun$7).addGlobalEvents(() -> this.update$$anonfun$8(mouseButtonEvents));
            }
            if (!mouseInBounds && !mouse.isLeftDown()) {
                return Outcome$.MODULE$.apply(this::update$$anonfun$9).addGlobalEvents(() -> this.update$$anonfun$10(mouseButtonEvents));
            }
        }
        if (ButtonState$Up$.MODULE$.equals(buttonState) && mouseInBounds) {
            return Outcome$.MODULE$.apply(this::update$$anonfun$11).addGlobalEvents(() -> this.update$$anonfun$12(mouseButtonEvents));
        }
        if (ButtonState$Over$.MODULE$.equals(buttonState) && !mouseInBounds) {
            return Outcome$.MODULE$.apply(this::update$$anonfun$13).addGlobalEvents(() -> this.update$$anonfun$14(mouseButtonEvents));
        }
        return Outcome$.MODULE$.apply(this::update$$anonfun$15).addGlobalEvents(() -> Button.update$$anonfun$16(mouseButtonEvents));
    }

    private SceneNode applyPositionAndDepth(SceneNode sceneNode, Point pt, int d) {
        SceneNode sceneNode2 = sceneNode;
        if (sceneNode2 instanceof Shape) {
            Shape n = (Shape)sceneNode2;
            return n.withPosition(pt).withDepth(d);
        }
        if (sceneNode2 instanceof Graphic) {
            Graphic n = (Graphic)sceneNode2;
            return n.withPosition(pt).withDepth(d);
        }
        if (sceneNode2 instanceof Sprite) {
            Sprite n = (Sprite)sceneNode2;
            return n.withPosition(pt).withDepth(d);
        }
        if (sceneNode2 instanceof Text) {
            Text n = (Text)sceneNode2;
            return n.withPosition(pt).withDepth(d);
        }
        if (sceneNode2 instanceof TextBox) {
            TextBox n = (TextBox)sceneNode2;
            return n.withPosition(pt).withDepth(d);
        }
        if (sceneNode2 instanceof Group) {
            Group n = (Group)sceneNode2;
            return n.withPosition(pt).withDepth(d);
        }
        SceneNode n = sceneNode2;
        return n;
    }

    public SceneNode draw() {
        ButtonState buttonState = this.state();
        if (ButtonState$Up$.MODULE$.equals(buttonState)) {
            return this.applyPositionAndDepth(this.buttonAssets().up(), this.bounds().position(), this.depth());
        }
        if (ButtonState$Over$.MODULE$.equals(buttonState)) {
            return this.applyPositionAndDepth(this.buttonAssets().over(), this.bounds().position(), this.depth());
        }
        if (ButtonState$Down$.MODULE$.equals(buttonState)) {
            return this.applyPositionAndDepth(this.buttonAssets().down(), this.bounds().position(), this.depth());
        }
        throw new MatchError((Object)buttonState);
    }

    public Button withUpActions(Seq<GlobalEvent> actions) {
        return this.withUpActions((Function0<Batch<GlobalEvent>>)((Function0 & Serializable)() -> Button.withUpActions$$anonfun$1(actions)));
    }

    public Button withUpActions(Function0<Batch<GlobalEvent>> actions) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), actions, this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10());
    }

    public Button withDownActions(Seq<GlobalEvent> actions) {
        return this.withDownActions((Function0<Batch<GlobalEvent>>)((Function0 & Serializable)() -> Button.withDownActions$$anonfun$1(actions)));
    }

    public Button withDownActions(Function0<Batch<GlobalEvent>> actions) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), actions, this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10());
    }

    public Button withHoverOverActions(Seq<GlobalEvent> actions) {
        return this.withHoverOverActions((Function0<Batch<GlobalEvent>>)((Function0 & Serializable)() -> Button.withHoverOverActions$$anonfun$1(actions)));
    }

    public Button withHoverOverActions(Function0<Batch<GlobalEvent>> actions) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), actions, this.copy$default$8(), this.copy$default$9(), this.copy$default$10());
    }

    public Button withHoverOutActions(Seq<GlobalEvent> actions) {
        return this.withHoverOutActions((Function0<Batch<GlobalEvent>>)((Function0 & Serializable)() -> Button.withHoverOutActions$$anonfun$1(actions)));
    }

    public Button withHoverOutActions(Function0<Batch<GlobalEvent>> actions) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), actions, this.copy$default$9(), this.copy$default$10());
    }

    public Button withClickActions(Seq<GlobalEvent> actions) {
        return this.withClickActions((Function0<Batch<GlobalEvent>>)((Function0 & Serializable)() -> Button.withClickActions$$anonfun$1(actions)));
    }

    public Button withClickActions(Function0<Batch<GlobalEvent>> actions) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), actions, this.copy$default$10());
    }

    public Button withHoldDownActions(Seq<GlobalEvent> actions) {
        return this.withHoldDownActions((Function0<Batch<GlobalEvent>>)((Function0 & Serializable)() -> Button.withHoldDownActions$$anonfun$1(actions)));
    }

    public Button withHoldDownActions(Function0<Batch<GlobalEvent>> actions) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), actions);
    }

    public Button toUpState() {
        ButtonState$Up$ buttonState$Up$ = ButtonState$Up$.MODULE$;
        ButtonAssets buttonAssets = this.copy$default$1();
        Rectangle rectangle = this.copy$default$2();
        int n = this.copy$default$3();
        Function0<Batch<GlobalEvent>> function0 = this.copy$default$5();
        Function0<Batch<GlobalEvent>> function02 = this.copy$default$6();
        Function0<Batch<GlobalEvent>> function03 = this.copy$default$7();
        Function0<Batch<GlobalEvent>> function04 = this.copy$default$8();
        Function0<Batch<GlobalEvent>> function05 = this.copy$default$9();
        Function0<Batch<GlobalEvent>> function06 = this.copy$default$10();
        return this.copy(buttonAssets, rectangle, n, buttonState$Up$, function0, function02, function03, function04, function05, function06);
    }

    public Button toOverState() {
        ButtonState$Over$ buttonState$Over$ = ButtonState$Over$.MODULE$;
        ButtonAssets buttonAssets = this.copy$default$1();
        Rectangle rectangle = this.copy$default$2();
        int n = this.copy$default$3();
        Function0<Batch<GlobalEvent>> function0 = this.copy$default$5();
        Function0<Batch<GlobalEvent>> function02 = this.copy$default$6();
        Function0<Batch<GlobalEvent>> function03 = this.copy$default$7();
        Function0<Batch<GlobalEvent>> function04 = this.copy$default$8();
        Function0<Batch<GlobalEvent>> function05 = this.copy$default$9();
        Function0<Batch<GlobalEvent>> function06 = this.copy$default$10();
        return this.copy(buttonAssets, rectangle, n, buttonState$Over$, function0, function02, function03, function04, function05, function06);
    }

    public Button toDownState() {
        ButtonState$Down$ buttonState$Down$ = ButtonState$Down$.MODULE$;
        ButtonAssets buttonAssets = this.copy$default$1();
        Rectangle rectangle = this.copy$default$2();
        int n = this.copy$default$3();
        Function0<Batch<GlobalEvent>> function0 = this.copy$default$5();
        Function0<Batch<GlobalEvent>> function02 = this.copy$default$6();
        Function0<Batch<GlobalEvent>> function03 = this.copy$default$7();
        Function0<Batch<GlobalEvent>> function04 = this.copy$default$8();
        Function0<Batch<GlobalEvent>> function05 = this.copy$default$9();
        Function0<Batch<GlobalEvent>> function06 = this.copy$default$10();
        return this.copy(buttonAssets, rectangle, n, buttonState$Down$, function0, function02, function03, function04, function05, function06);
    }

    public Button withButtonState(ButtonState newState) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), newState, this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10());
    }

    public Button withButtonAssets(ButtonAssets newButtonAssets) {
        return this.copy(newButtonAssets, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10());
    }

    public Button copy(ButtonAssets buttonAssets, Rectangle bounds, int depth, ButtonState state, Function0<Batch<GlobalEvent>> onUp, Function0<Batch<GlobalEvent>> onDown, Function0<Batch<GlobalEvent>> onHoverOver, Function0<Batch<GlobalEvent>> onHoverOut, Function0<Batch<GlobalEvent>> onClick, Function0<Batch<GlobalEvent>> onHoldDown) {
        return new Button(buttonAssets, bounds, depth, state, onUp, onDown, onHoverOver, onHoverOut, onClick, onHoldDown);
    }

    public ButtonAssets copy$default$1() {
        return this.buttonAssets();
    }

    public Rectangle copy$default$2() {
        return this.bounds();
    }

    public int copy$default$3() {
        return this.depth();
    }

    public ButtonState copy$default$4() {
        return this.state();
    }

    public Function0<Batch<GlobalEvent>> copy$default$5() {
        return this.onUp();
    }

    public Function0<Batch<GlobalEvent>> copy$default$6() {
        return this.onDown();
    }

    public Function0<Batch<GlobalEvent>> copy$default$7() {
        return this.onHoverOver();
    }

    public Function0<Batch<GlobalEvent>> copy$default$8() {
        return this.onHoverOut();
    }

    public Function0<Batch<GlobalEvent>> copy$default$9() {
        return this.onClick();
    }

    public Function0<Batch<GlobalEvent>> copy$default$10() {
        return this.onHoldDown();
    }

    public ButtonAssets _1() {
        return this.buttonAssets();
    }

    public Rectangle _2() {
        return this.bounds();
    }

    public int _3() {
        return this.depth();
    }

    public ButtonState _4() {
        return this.state();
    }

    public Function0<Batch<GlobalEvent>> _5() {
        return this.onUp();
    }

    public Function0<Batch<GlobalEvent>> _6() {
        return this.onDown();
    }

    public Function0<Batch<GlobalEvent>> _7() {
        return this.onHoverOver();
    }

    public Function0<Batch<GlobalEvent>> _8() {
        return this.onHoverOut();
    }

    public Function0<Batch<GlobalEvent>> _9() {
        return this.onClick();
    }

    public Function0<Batch<GlobalEvent>> _10() {
        return this.onHoldDown();
    }

    private final Button update$$anonfun$1() {
        return this;
    }

    private final Batch update$$anonfun$2(Batch mouseButtonEvents$1) {
        return ((Batch)this.onHoldDown().apply()).$plus$plus(mouseButtonEvents$1);
    }

    private final Button update$$anonfun$3() {
        return this.toDownState();
    }

    private final Batch update$$anonfun$4(Batch mouseButtonEvents$2) {
        return ((Batch)this.onHoverOver().apply()).$plus$plus(mouseButtonEvents$2);
    }

    private final Button update$$anonfun$5() {
        return this.toDownState();
    }

    private static final Batch update$$anonfun$6(Batch mouseButtonEvents$3) {
        return mouseButtonEvents$3;
    }

    private final Button update$$anonfun$7() {
        return this.toOverState();
    }

    private final Batch update$$anonfun$8(Batch mouseButtonEvents$4) {
        return ((Batch)this.onHoverOver().apply()).$plus$plus(mouseButtonEvents$4);
    }

    private final Button update$$anonfun$9() {
        return this.toUpState();
    }

    private final Batch update$$anonfun$10(Batch mouseButtonEvents$5) {
        return ((Batch)this.onHoverOut().apply()).$plus$plus(mouseButtonEvents$5);
    }

    private final Button update$$anonfun$11() {
        return this.toOverState();
    }

    private final Batch update$$anonfun$12(Batch mouseButtonEvents$6) {
        return ((Batch)this.onHoverOver().apply()).$plus$plus(mouseButtonEvents$6);
    }

    private final Button update$$anonfun$13() {
        return this.toUpState();
    }

    private final Batch update$$anonfun$14(Batch mouseButtonEvents$7) {
        return ((Batch)this.onHoverOut().apply()).$plus$plus(mouseButtonEvents$7);
    }

    private final Button update$$anonfun$15() {
        return this;
    }

    private static final Batch update$$anonfun$16(Batch mouseButtonEvents$8) {
        return mouseButtonEvents$8;
    }

    private static final Batch withUpActions$$anonfun$1(Seq actions$1) {
        return Batch$.MODULE$.fromSeq(actions$1);
    }

    private static final Batch withDownActions$$anonfun$1(Seq actions$2) {
        return Batch$.MODULE$.fromSeq(actions$2);
    }

    private static final Batch withHoverOverActions$$anonfun$1(Seq actions$3) {
        return Batch$.MODULE$.fromSeq(actions$3);
    }

    private static final Batch withHoverOutActions$$anonfun$1(Seq actions$4) {
        return Batch$.MODULE$.fromSeq(actions$4);
    }

    private static final Batch withClickActions$$anonfun$1(Seq actions$5) {
        return Batch$.MODULE$.fromSeq(actions$5);
    }

    private static final Batch withHoldDownActions$$anonfun$1(Seq actions$6) {
        return Batch$.MODULE$.fromSeq(actions$6);
    }
}

