/*
 * Decompiled with CFR 0.152.
 */
package millindigo;

import geny.Writable$;
import java.io.Serializable;
import millindigo.DirectoryStructure;
import millindigo.TemplateOptions;
import millindigo.Utils$;
import os.Path;
import os.PathChunk;
import os.PathChunk$;
import os.Source;
import os.Source$;
import os.copy$;
import os.exists$;
import os.isDir$;
import os.write$;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;

public final class IndigoBuildJS$ {
    public static final IndigoBuildJS$ MODULE$ = new IndigoBuildJS$();

    public void build(Path baseDir, TemplateOptions templateOptions) {
        DirectoryStructure directoryStructure = this.createDirectoryStructure(baseDir);
        this.copyScript(directoryStructure.base(), templateOptions, directoryStructure.artefacts());
        this.copyAssets(templateOptions.gameAssetsDirectoryPath(), directoryStructure.assets());
        String html = this.template(templateOptions.title(), templateOptions.showCursor());
        Path outputPath = this.writeHtml(directoryStructure, html);
        Predef$.MODULE$.println((Object)outputPath.toString());
    }

    public DirectoryStructure createDirectoryStructure(Path baseDir) {
        Predef$.MODULE$.println((Object)new StringBuilder(9).append("dirPath: ").append(baseDir.toString()).toString());
        return new DirectoryStructure(Utils$.MODULE$.ensureDirectoryAt(baseDir), Utils$.MODULE$.ensureDirectoryAt(baseDir.$div((PathChunk)PathChunk$.MODULE$.StringPathChunk("assets"))), Utils$.MODULE$.ensureDirectoryAt(baseDir.$div((PathChunk)PathChunk$.MODULE$.StringPathChunk("scripts"))));
    }

    public void copyScript(Path base, TemplateOptions templateOptions, Path destScriptsFolder) {
        Path scriptFile = templateOptions.scriptPathBase().$div((PathChunk)PathChunk$.MODULE$.StringPathChunk("out.js"));
        if (!exists$.MODULE$.apply(scriptFile)) {
            throw new Exception(new StringBuilder(66).append("Script file does not exist, have you compiled the JS file? Tried: ").append(scriptFile.toString()).toString());
        }
        copy$.MODULE$.apply(scriptFile, destScriptsFolder.$div((PathChunk)PathChunk$.MODULE$.StringPathChunk("out.js")), copy$.MODULE$.apply$default$3(), copy$.MODULE$.apply$default$4(), copy$.MODULE$.apply$default$5(), copy$.MODULE$.apply$default$6());
    }

    public void copyAssets(Path gameAssetsDirectoryPath, Path destAssetsFolder) {
        if (!exists$.MODULE$.apply(gameAssetsDirectoryPath)) {
            throw new Exception(new StringBuilder(42).append("Supplied game assets path does not exist: ").append(gameAssetsDirectoryPath.toString()).toString());
        }
        if (!isDir$.MODULE$.apply(gameAssetsDirectoryPath)) {
            throw new Exception("Supplied game assets path was not a directory");
        }
        Predef$.MODULE$.println((Object)"Copying assets...");
        copy$.MODULE$.apply(gameAssetsDirectoryPath, destAssetsFolder, true, true, true, copy$.MODULE$.apply$default$6());
    }

    public String template(String title, boolean showCursor) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(1695).append("<!DOCTYPE html>\n      |<html>\n      |  <head>\n      |    <meta charset=\"UTF-8\">\n      |    <title>").append(title).append("</title>\n      |    <style>\n      |      body {\n      |        padding:0px;\n      |        margin:0px;\n      |      }\n      |\n      |      ").append((Object)(!showCursor ? "canvas { cursor: none }" : "")).append("\n      |    </style>\n      |  </head>\n      |  <body>\n      |    <script type=\"text/javascript\">\n      |window.onload = function () {\n      |    if (typeof history.pushState === \"function\") {\n      |        history.pushState(\"jibberish\", null, null);\n      |        window.onpopstate = function () {\n      |            history.pushState('newjibberish', null, null);\n      |            // Handle the back (or forward) buttons here\n      |            // Will NOT handle refresh, use onbeforeunload for this.\n      |        };\n      |    }\n      |    else {\n      |        var ignoreHashChange = true;\n      |        window.onhashchange = function () {\n      |            if (!ignoreHashChange) {\n      |                ignoreHashChange = true;\n      |                window.location.hash = Math.random();\n      |                // Detect and redirect change here\n      |                // Works in older FF and IE9\n      |                // * it does mess with your hash symbol (anchor?) pound sign\n      |                // delimiter on the end of the URL\n      |            }\n      |            else {\n      |                ignoreHashChange = false;\n      |            }\n      |        };\n      |    }\n      |}\n      |    </script>\n      |    <div id=\"indigo-container\"></div>\n      |    <script type=\"text/javascript\" src=\"scripts/out.js\"></script>\n      |    <script type=\"text/javascript\">IndigoGame.launch()</script>\n      |  </body>\n      |</html>\n    ").toString()));
    }

    /*
     * WARNING - void declaration
     */
    public Path writeHtml(DirectoryStructure directoryStructure, String html) {
        void var3_3;
        Path outFile = directoryStructure.base().$div((PathChunk)PathChunk$.MODULE$.StringPathChunk("index.html"));
        write$.MODULE$.apply(outFile, (Source)Source$.MODULE$.WritableSource((Object)html, (Function1 & Serializable)s -> Writable$.MODULE$.StringWritable(s)), write$.MODULE$.apply$default$3(), write$.MODULE$.apply$default$4());
        return var3_3;
    }

    private IndigoBuildJS$() {
    }
}

