/*
 * Decompiled with CFR 0.152.
 */
package io.infinitic.transport.config;

import io.infinitic.autoclose.AutoCloseKt;
import io.infinitic.common.transport.InfiniticConsumerAsync;
import io.infinitic.common.transport.InfiniticProducerAsync;
import io.infinitic.inMemory.InMemoryChannels;
import io.infinitic.inMemory.InMemoryInfiniticConsumerAsync;
import io.infinitic.inMemory.InMemoryInfiniticProducerAsync;
import io.infinitic.pulsar.PulsarInfiniticConsumerAsync;
import io.infinitic.pulsar.PulsarInfiniticProducerAsync;
import io.infinitic.pulsar.client.PulsarInfiniticClient;
import io.infinitic.pulsar.config.Pulsar;
import io.infinitic.pulsar.consumers.Consumer;
import io.infinitic.pulsar.producers.Producer;
import io.infinitic.pulsar.resources.PulsarResources;
import io.infinitic.transport.config.Transport;
import io.infinitic.transport.config.TransportConfigInterface;
import java.net.URLEncoder;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u001f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010 \u001a\u00020\u0007H\u00c6\u0003J)\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u00d6\u0003J\t\u0010&\u001a\u00020'H\u00d6\u0001J\t\u0010(\u001a\u00020\u0011H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006)"}, d2={"Lio/infinitic/transport/config/TransportConfig;", "Lio/infinitic/transport/config/TransportConfigInterface;", "transport", "Lio/infinitic/transport/config/Transport;", "pulsar", "Lio/infinitic/pulsar/config/Pulsar;", "shutdownGracePeriodInSeconds", "", "<init>", "(Lio/infinitic/transport/config/Transport;Lio/infinitic/pulsar/config/Pulsar;D)V", "getTransport", "()Lio/infinitic/transport/config/Transport;", "getPulsar", "()Lio/infinitic/pulsar/config/Pulsar;", "getShutdownGracePeriodInSeconds", "()D", "source", "", "getSource", "()Ljava/lang/String;", "cp", "Lkotlin/Pair;", "Lio/infinitic/common/transport/InfiniticConsumerAsync;", "Lio/infinitic/common/transport/InfiniticProducerAsync;", "consumerAsync", "getConsumerAsync", "()Lio/infinitic/common/transport/InfiniticConsumerAsync;", "producerAsync", "getProducerAsync", "()Lio/infinitic/common/transport/InfiniticProducerAsync;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "infinitic-transport"})
@SourceDebugExtension(value={"SMAP\nTransportConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransportConfig.kt\nio/infinitic/transport/config/TransportConfig\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,108:1\n1#2:109\n*E\n"})
public final class TransportConfig
implements TransportConfigInterface {
    @NotNull
    private final Transport transport;
    @Nullable
    private final Pulsar pulsar;
    private final double shutdownGracePeriodInSeconds;
    @NotNull
    private final String source;
    @NotNull
    private final Pair<InfiniticConsumerAsync, InfiniticProducerAsync> cp;
    @NotNull
    private final InfiniticConsumerAsync consumerAsync;
    @NotNull
    private final InfiniticProducerAsync producerAsync;

    /*
     * WARNING - void declaration
     */
    public TransportConfig(@NotNull Transport transport, @Nullable Pulsar pulsar, double shutdownGracePeriodInSeconds) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)((Object)transport), (String)"transport");
        this.transport = transport;
        this.pulsar = pulsar;
        this.shutdownGracePeriodInSeconds = shutdownGracePeriodInSeconds;
        if (this.getTransport() == Transport.pulsar && !(this.getPulsar() != null)) {
            boolean $i$a$-require-TransportConfig$32 = false;
            String $i$a$-require-TransportConfig$32 = "Missing Pulsar configuration";
            throw new IllegalArgumentException($i$a$-require-TransportConfig$32.toString());
        }
        if (!(this.getShutdownGracePeriodInSeconds() >= 0.0)) {
            boolean bl = false;
            String string = "shutdownGracePeriodInSeconds must be >= 0";
            throw new IllegalArgumentException(string.toString());
        }
        this.source = switch (WhenMappings.$EnumSwitchMapping$0[this.getTransport().ordinal()]) {
            case 1 -> {
                Pulsar v0 = this.getPulsar();
                Intrinsics.checkNotNull((Object)v0);
                yield StringsKt.removeSuffix((String)v0.getBrokerServiceUrl(), (CharSequence)"/") + "/" + URLEncoder.encode(this.getPulsar().getTenant(), Charsets.UTF_8) + "/" + URLEncoder.encode(this.getPulsar().getNamespace(), Charsets.UTF_8);
            }
            case 2 -> "inmemory";
            default -> throw new NoWhenBranchMatchedException();
        };
        TransportConfig transportConfig = this;
        switch (WhenMappings.$EnumSwitchMapping$0[this.getTransport().ordinal()]) {
            case 1: {
                void $this$cp_u24lambda_u242;
                Pulsar pulsar2 = this.getPulsar();
                Intrinsics.checkNotNull((Object)pulsar2);
                PulsarResources pulsarResources = PulsarResources.Companion.from(pulsar2);
                TransportConfig transportConfig2 = transportConfig;
                boolean bl = false;
                PulsarInfiniticClient client = new PulsarInfiniticClient(this.getPulsar().getClient());
                PulsarInfiniticConsumerAsync consumerAsync = new PulsarInfiniticConsumerAsync(new Consumer(client, this.getPulsar().getConsumer()), (PulsarResources)$this$cp_u24lambda_u242, this.getShutdownGracePeriodInSeconds());
                AutoCloseKt.addAutoCloseResource((AutoCloseable)((AutoCloseable)consumerAsync), (AutoCloseable)((AutoCloseable)this.getPulsar().getClient()));
                AutoCloseKt.addAutoCloseResource((AutoCloseable)((AutoCloseable)consumerAsync), (AutoCloseable)((AutoCloseable)this.getPulsar().getAdmin()));
                PulsarInfiniticProducerAsync producerAsync = new PulsarInfiniticProducerAsync(new Producer(client, this.getPulsar().getProducer()), (PulsarResources)$this$cp_u24lambda_u242);
                pair = new Pair((Object)consumerAsync, (Object)producerAsync);
                transportConfig = transportConfig2;
                break;
            }
            case 2: {
                InMemoryChannels mainChannels = new InMemoryChannels();
                InMemoryChannels listenerChannels = new InMemoryChannels();
                InMemoryInfiniticConsumerAsync consumerAsync = new InMemoryInfiniticConsumerAsync(mainChannels, listenerChannels);
                InMemoryInfiniticProducerAsync producerAsync = new InMemoryInfiniticProducerAsync(mainChannels, listenerChannels);
                pair = new Pair((Object)consumerAsync, (Object)producerAsync);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        transportConfig.cp = pair;
        this.consumerAsync = (InfiniticConsumerAsync)this.cp.getFirst();
        this.producerAsync = (InfiniticProducerAsync)this.cp.getSecond();
    }

    @Override
    @NotNull
    public Transport getTransport() {
        return this.transport;
    }

    @Override
    @Nullable
    public Pulsar getPulsar() {
        return this.pulsar;
    }

    @Override
    public double getShutdownGracePeriodInSeconds() {
        return this.shutdownGracePeriodInSeconds;
    }

    @NotNull
    public final String getSource() {
        return this.source;
    }

    @NotNull
    public final InfiniticConsumerAsync getConsumerAsync() {
        return this.consumerAsync;
    }

    @NotNull
    public final InfiniticProducerAsync getProducerAsync() {
        return this.producerAsync;
    }

    @NotNull
    public final Transport component1() {
        return this.transport;
    }

    @Nullable
    public final Pulsar component2() {
        return this.pulsar;
    }

    public final double component3() {
        return this.shutdownGracePeriodInSeconds;
    }

    @NotNull
    public final TransportConfig copy(@NotNull Transport transport, @Nullable Pulsar pulsar, double shutdownGracePeriodInSeconds) {
        Intrinsics.checkNotNullParameter((Object)((Object)transport), (String)"transport");
        return new TransportConfig(transport, pulsar, shutdownGracePeriodInSeconds);
    }

    public static /* synthetic */ TransportConfig copy$default(TransportConfig transportConfig, Transport transport, Pulsar pulsar, double d, int n, Object object) {
        if ((n & 1) != 0) {
            transport = transportConfig.transport;
        }
        if ((n & 2) != 0) {
            pulsar = transportConfig.pulsar;
        }
        if ((n & 4) != 0) {
            d = transportConfig.shutdownGracePeriodInSeconds;
        }
        return transportConfig.copy(transport, pulsar, d);
    }

    @NotNull
    public String toString() {
        return "TransportConfig(transport=" + this.transport + ", pulsar=" + this.pulsar + ", shutdownGracePeriodInSeconds=" + this.shutdownGracePeriodInSeconds + ")";
    }

    public int hashCode() {
        int result = this.transport.hashCode();
        result = result * 31 + (this.pulsar == null ? 0 : this.pulsar.hashCode());
        result = result * 31 + Double.hashCode(this.shutdownGracePeriodInSeconds);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TransportConfig)) {
            return false;
        }
        TransportConfig transportConfig = (TransportConfig)other;
        if (this.transport != transportConfig.transport) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.pulsar, (Object)transportConfig.pulsar)) {
            return false;
        }
        return Double.compare(this.shutdownGracePeriodInSeconds, transportConfig.shutdownGracePeriodInSeconds) == 0;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Transport.values().length];
            try {
                nArray[Transport.pulsar.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Transport.inMemory.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

