/*
 * Decompiled with CFR 0.152.
 */
package io.inkstand.http.undertow;

import io.inkstand.InkstandRuntimeException;
import io.inkstand.ProtectedService;
import io.inkstand.config.WebServerConfiguration;
import io.inkstand.http.undertow.UndertowWebServerProvider;
import io.undertow.Undertow;
import io.undertow.security.api.AuthenticationMode;
import io.undertow.security.handlers.AuthenticationCallHandler;
import io.undertow.security.handlers.AuthenticationConstraintHandler;
import io.undertow.security.handlers.AuthenticationMechanismsHandler;
import io.undertow.security.handlers.SecurityInitialHandler;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.impl.BasicAuthenticationMechanism;
import io.undertow.server.HttpHandler;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import java.util.Collections;
import java.util.List;
import javax.annotation.Priority;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.ServletException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Priority(value=0)
@ProtectedService
public class AuthenticatingUndertowWebServerProvider {
    private static final Logger LOG = LoggerFactory.getLogger(UndertowWebServerProvider.class);
    @Inject
    private WebServerConfiguration config;
    @Inject
    private DeploymentInfo deploymentInfo;
    @Inject
    private IdentityManager identityManager;

    @Produces
    public Undertow getLdapAuthUndertow() {
        this.deploymentInfo.setIdentityManager(this.identityManager);
        DeploymentManager deploymentManager = Servlets.defaultContainer().addDeployment(this.deploymentInfo);
        deploymentManager.deploy();
        try {
            LOG.info("Creating service endpoint {}:{}/{} for {} at ", new Object[]{this.config.getBindAddress(), this.config.getPort(), this.deploymentInfo.getContextPath(), this.deploymentInfo.getDeploymentName()});
            return Undertow.builder().addHttpListener(this.config.getPort(), this.config.getBindAddress()).setHandler(this.addSecurity(deploymentManager.start())).build();
        }
        catch (ServletException e) {
            throw new InkstandRuntimeException((Throwable)e);
        }
    }

    HttpHandler addSecurity(HttpHandler toWrap) {
        HttpHandler handler = toWrap;
        handler = new AuthenticationCallHandler(handler);
        handler = new AuthenticationConstraintHandler(handler);
        List<BasicAuthenticationMechanism> mechanisms = Collections.singletonList(new BasicAuthenticationMechanism("My Realm"));
        handler = new AuthenticationMechanismsHandler(handler, mechanisms);
        handler = new SecurityInitialHandler(AuthenticationMode.PRO_ACTIVE, this.identityManager, handler);
        return handler;
    }
}

