/*
 * Decompiled with CFR 0.152.
 */
package io.inkstand.http.undertow;

import io.inkstand.InkstandRuntimeException;
import io.inkstand.PublicService;
import io.inkstand.config.WebServerConfiguration;
import io.undertow.Undertow;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import javax.annotation.Priority;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.ServletException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Priority(value=0)
@PublicService
public class UndertowWebServerProvider {
    private static final Logger LOG = LoggerFactory.getLogger(UndertowWebServerProvider.class);
    @Inject
    private WebServerConfiguration config;
    @Inject
    private DeploymentInfo deploymentInfo;

    @Produces
    public Undertow getUndertow() {
        DeploymentManager deploymentManager = Servlets.defaultContainer().addDeployment(this.deploymentInfo);
        deploymentManager.deploy();
        try {
            LOG.info("Creating service endpoint {}:{}/{} for {} at ", new Object[]{this.config.getBindAddress(), this.config.getPort(), this.deploymentInfo.getContextPath(), this.deploymentInfo.getDeploymentName()});
            return Undertow.builder().addHttpListener(this.config.getPort(), this.config.getBindAddress()).setHandler(deploymentManager.start()).build();
        }
        catch (ServletException e) {
            throw new InkstandRuntimeException((Throwable)e);
        }
    }
}

