/*
 * Decompiled with CFR 0.152.
 */
package io.inkstand.http.undertow.auth.ldap;

import io.inkstand.security.SimplePrincipal;
import io.undertow.security.idm.Account;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class LdapAccount
implements Account {
    private final Principal principal;
    private final Set<String> roles;
    private final String dn;

    public LdapAccount(String userId, String dn) {
        this.principal = new SimplePrincipal(userId);
        this.dn = dn;
        this.roles = new HashSet<String>();
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public Set<String> getRoles() {
        return Collections.unmodifiableSet(this.roles);
    }

    protected void addRole(String roleName) {
        this.roles.add(roleName);
    }

    protected void addRoles(Collection<String> roles) {
        this.roles.addAll(roles);
    }

    public String getDn() {
        return this.dn;
    }
}

