/*
 * Decompiled with CFR 0.152.
 */
package io.inkstand.http.undertow.auth.ldap;

import io.inkstand.InkstandRuntimeException;
import io.inkstand.http.undertow.auth.ldap.LdapAccount;
import io.inkstand.security.LdapAuthConfiguration;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.Credential;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.idm.PasswordCredential;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.EntryCursor;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapIdentityManager
implements IdentityManager {
    private static final Logger LOG = LoggerFactory.getLogger(LdapIdentityManager.class);
    @Inject
    private LdapAuthConfiguration ldapConfig;
    private LdapConnection connection;

    @PostConstruct
    public void connect() {
        LOG.debug("Connecting to LDAP server ldap://{}:{}", (Object)this.ldapConfig.getHostname(), (Object)this.ldapConfig.getPort());
        this.connection = new LdapNetworkConnection(this.ldapConfig.getHostname(), this.ldapConfig.getPort());
    }

    @PreDestroy
    public void disconnect() {
        if (this.connection.isConnected()) {
            try {
                this.connection.close();
            }
            catch (IOException e) {
                LOG.warn("Closing connection failed", (Throwable)e);
            }
        }
    }

    public Account verify(Account account) {
        return account;
    }

    public Account verify(String id, Credential credential) {
        this.bind();
        try {
            EntryCursor result = this.connection.search(this.ldapConfig.getUserContextDn(), this.getUserFilter(id), this.getSearchScope(), new String[0]);
            if (result.next()) {
                Entry user = (Entry)result.get();
                LdapAccount ldapAccount = this.createUserAccout(user, credential, id);
                return ldapAccount;
            }
            try {
                throw new InkstandRuntimeException("No user with id " + id + " found");
            }
            catch (CursorException | LdapException e) {
                throw new InkstandRuntimeException(e);
            }
        }
        finally {
            this.unbind();
        }
    }

    private LdapAccount createUserAccout(Entry user, Credential credential, String id) throws LdapException, CursorException {
        LOG.debug("User {} found, collecting user groups", (Object)id);
        Set<String> roles = this.getRoles(id, user.getDn().toString());
        LOG.debug("User {} has roles {}", (Object)id, roles);
        LOG.debug("Authenticating user {}", (Object)id);
        char[] password = ((PasswordCredential)credential).getPassword();
        this.connection.bind(user.getDn(), String.valueOf(password));
        LOG.debug("User {} authenticated", (Object)id);
        LdapAccount account = new LdapAccount(id, user.getDn().toString());
        account.addRoles(roles);
        for (String role : roles) {
            account.addRole(role);
        }
        return account;
    }

    public Account verify(Credential credential) {
        throw new UnsupportedOperationException("verify with credentials not supported");
    }

    private void bind() {
        try {
            LOG.debug("binding user {}", (Object)this.ldapConfig.getBindDn());
            this.connection.bind(this.ldapConfig.getBindDn(), this.ldapConfig.getBindCredentials());
        }
        catch (LdapException e) {
            throw new InkstandRuntimeException("Ldap authentication failed", (Throwable)e);
        }
    }

    private void unbind() {
        try {
            this.connection.unBind();
        }
        catch (LdapException e) {
            throw new InkstandRuntimeException("Ldap unbind failed", (Throwable)e);
        }
    }

    private Set<String> getRoles(String uid, String dn) throws LdapException, CursorException {
        this.bind();
        EntryCursor result = this.connection.search(this.ldapConfig.getRoleContextDn(), this.getRoleFilter(uid, dn), this.getSearchScope(), new String[]{this.ldapConfig.getRoleNameAttribute()});
        HashSet<String> roles = new HashSet<String>();
        while (result.next()) {
            roles.add(((Entry)result.get()).get(this.ldapConfig.getRoleNameAttribute()).getString());
        }
        return roles;
    }

    private String getUserFilter(String userId) {
        return this.ldapConfig.getUserFilter().replaceAll("\\{0\\}", userId);
    }

    private String getRoleFilter(String userId, String userDn) {
        return this.ldapConfig.getRoleFilter().replaceAll("\\{0\\}", userId).replaceAll("\\{1\\}", userDn);
    }

    private SearchScope getSearchScope() {
        return SearchScope.getSearchScope((int)this.ldapConfig.getSearchScope().getValue());
    }
}

