/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.s3;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import io.inversion.Action;
import io.inversion.ApiException;
import io.inversion.Chain;
import io.inversion.Request;
import io.inversion.Response;
import io.inversion.utils.JSNode;
import io.inversion.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class S3UploadAction
extends Action<S3UploadAction> {
    protected final String s3AccessKey;
    protected final String s3SecretKey;
    protected final String s3AwsRegion;
    protected final String s3Bucket;
    protected final String s3BasePath = "uploads";
    protected final String s3DatePath = "yyyy/MM/dd";

    public S3UploadAction() {
        this.s3AccessKey = null;
        this.s3SecretKey = null;
        this.s3AwsRegion = null;
        this.s3Bucket = null;
    }

    private static String getHash(MessageDigest digest) throws IOException {
        byte[] md5sum = digest.digest();
        BigInteger bigInt = new BigInteger(1, md5sum);
        StringBuilder output = new StringBuilder(bigInt.toString(16));
        while (output.length() < 32) {
            output.insert(0, "0");
        }
        return output.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run(Request req, Response res) throws ApiException {
        Map<String, Object> responseContent;
        DigestInputStream uploadStream;
        Long fileSize;
        String fileName;
        String requestPath;
        block10: {
            requestPath = null;
            fileName = null;
            fileSize = null;
            uploadStream = null;
            List uploads = req.getUploads();
            if (uploads.size() > 0) {
                Request.Upload upload = (Request.Upload)uploads.get(0);
                uploadStream = new DigestInputStream(upload.getInputStream(), MessageDigest.getInstance("MD5"));
                String[] fileNameParts = upload.getFileName().split("[.]");
                fileName = "" + fileNameParts[0] + "-" + System.currentTimeMillis() + "." + fileNameParts[1];
                fileSize = upload.getFileSize();
                requestPath = upload.getRequestPath();
                if (requestPath.indexOf("/") == 0) {
                    requestPath = requestPath.substring(1);
                }
            }
            if (uploadStream != null) break block10;
            this.error(res, null, "No file was uploaded in the multipart request");
            if (uploadStream == null) return;
            Utils.close((Object[])new Object[]{uploadStream});
            return;
        }
        try {
            responseContent = this.saveFile(req.getChain(), uploadStream, fileName, requestPath);
        }
        catch (Exception e) {
            this.error(res, e, "S3 Key may be invalid - valid characters are [  0-9 a-z A-Z !-_.*'()  ] --- your requested key was: " + requestPath + "/" + fileName);
            if (uploadStream == null) return;
            Utils.close((Object[])new Object[]{uploadStream});
            return;
        }
        try {
            responseContent.put("fileMd5", S3UploadAction.getHash(uploadStream.getMessageDigest()));
            responseContent.put("fileSizeBytes", fileSize);
            res.withJson(new JSNode(responseContent));
            if (uploadStream == null) return;
        }
        catch (Exception ex) {
            try {
                throw ApiException.new500InternalServerError((Throwable)ex);
            }
            catch (Throwable throwable) {
                if (uploadStream == null) throw throwable;
                Utils.close((Object[])new Object[]{uploadStream});
                throw throwable;
            }
        }
        Utils.close((Object[])new Object[]{uploadStream});
        return;
    }

    void error(Response res, Exception exception, String message) {
        if (exception != null) {
            message = message + "\r\n\r\n" + Utils.getShortCause((Throwable)exception);
        }
        res.withStatus("400 Bad Request");
        HashMap<String, String> content = new HashMap<String, String>();
        content.put("message", message);
        content.put("error", "Bad Request Exception");
        res.withJson(new JSNode(content));
    }

    private Map<String, Object> saveFile(Chain chain, InputStream inputStream, String fileName, String requestPath) throws Exception {
        AmazonS3 s3 = this.buildS3Client(chain);
        String bucket = chain.getConfig("s3Bucket", this.s3Bucket);
        String pathAndFileName = this.buildFullPath(chain, requestPath, fileName);
        s3.putObject(new PutObjectRequest(bucket, pathAndFileName, inputStream, new ObjectMetadata()));
        HashMap<String, Object> resp = new HashMap<String, Object>();
        resp.put("url", "http://" + bucket + ".s3.amazonaws.com/" + pathAndFileName);
        resp.put("fileName", fileName);
        resp.put("path", pathAndFileName);
        return resp;
    }

    private String buildFullPath(Chain chain, String requestPath, String name) {
        StringBuilder sb = new StringBuilder();
        String basePath = chain.getConfig("s3BasePath", this.s3BasePath);
        String datePath = chain.getConfig("s3DatePath", this.s3DatePath);
        if (basePath != null) {
            sb.append(basePath);
            if (!basePath.endsWith("/")) {
                sb.append("/");
            }
        }
        if (datePath != null) {
            datePath = new SimpleDateFormat(datePath).format(new Date());
            sb.append(datePath).append("/");
        }
        if (requestPath != null) {
            if (requestPath.startsWith("/")) {
                sb.append(requestPath.substring(1));
            } else {
                sb.append(requestPath);
            }
            if (!requestPath.endsWith("/")) {
                sb.append("/");
            }
        }
        sb.append(name);
        return sb.toString();
    }

    private AmazonS3 buildS3Client(Chain chain) {
        AmazonS3ClientBuilder builder;
        String accessKey = chain.getConfig("s3AccessKey", this.s3AccessKey);
        String secretKey = chain.getConfig("s3SecretKey", this.s3SecretKey);
        String awsRegion = chain.getConfig("s3AwsRegion", this.s3AwsRegion);
        if (accessKey != null) {
            BasicAWSCredentials creds = new BasicAWSCredentials(accessKey, secretKey);
            builder = (AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)creds));
        } else {
            builder = AmazonS3ClientBuilder.standard();
        }
        if (awsRegion != null) {
            builder.withRegion(awsRegion);
        }
        return (AmazonS3)builder.build();
    }
}

