//
// This file is auto-generated by 'tools:code-generator'
//
@file:JvmMultifileClass
@file:JvmName("CenturiesKt")

package io.islandtime.measures

import io.islandtime.internal.DECADES_PER_CENTURY
import io.islandtime.internal.MONTHS_PER_CENTURY
import io.islandtime.internal.YEARS_PER_CENTURY
import io.islandtime.internal.minusExact
import io.islandtime.internal.negateExact
import io.islandtime.internal.plusExact
import io.islandtime.internal.timesExact
import io.islandtime.internal.toIntExact
import kotlin.Boolean
import kotlin.Comparable
import kotlin.Int
import kotlin.Long
import kotlin.PublishedApi
import kotlin.String
import kotlin.jvm.JvmMultifileClass
import kotlin.jvm.JvmName
import kotlin.math.absoluteValue

/**
 * A number of centuries.
 */
inline class IntCenturies(
  /**
   * The underlying value.
   */
  val value: Int
) : Comparable<IntCenturies> {
  /**
   * Returns the absolute value.
   * @throws ArithmeticException if overflow occurs
   */
  val absoluteValue: IntCenturies
    get() = if (value < 0) -this else this
  /**
   * Convert to months.
   * @throws ArithmeticException if overflow occurs
   */
  val inMonths: IntMonths
    get() = (value timesExact MONTHS_PER_CENTURY).months

  /**
   * Convert to months without checking for overflow.
   */
  internal val inMonthsUnchecked: IntMonths
    get() = (value * MONTHS_PER_CENTURY).months

  /**
   * Convert to years.
   * @throws ArithmeticException if overflow occurs
   */
  val inYears: IntYears
    get() = (value timesExact YEARS_PER_CENTURY).years

  /**
   * Convert to years without checking for overflow.
   */
  internal val inYearsUnchecked: IntYears
    get() = (value * YEARS_PER_CENTURY).years

  /**
   * Convert to decades.
   * @throws ArithmeticException if overflow occurs
   */
  val inDecades: IntDecades
    get() = (value timesExact DECADES_PER_CENTURY).decades

  /**
   * Convert to decades without checking for overflow.
   */
  internal val inDecadesUnchecked: IntDecades
    get() = (value * DECADES_PER_CENTURY).decades

  /**
   * Is this duration zero?
   */
  fun isZero(): Boolean = value == 0

  /**
   * Is this duration negative?
   */
  fun isNegative(): Boolean = value < 0

  /**
   * Is this duration positive?
   */
  fun isPositive(): Boolean = value > 0

  override fun compareTo(other: IntCenturies): Int = value.compareTo(other.value)

  /**
   * Convert to an ISO-8601 time interval representation.
   */
  override fun toString(): String {
     return when (value) {
       0 -> "P0Y"
       Int.MIN_VALUE -> "-P2147483648Y"
       else -> buildString {
         if (value < 0) { append('-') }
         append("P")
         append(value.absoluteValue timesExact 100)
         append('Y')
       }
     }
  }

  /**
   * Negate the value.
   * @throws ArithmeticException if overflow occurs
   */
  operator fun unaryMinus() = IntCenturies(value.negateExact())

  /**
   * Negate the value without checking for overflow.
   */
  internal fun negateUnchecked() = IntCenturies(-value)

  /**
   * Multiply by a scalar value.
   * @throws ArithmeticException if overflow occurs
   */
  operator fun times(scalar: Int) = IntCenturies(value timesExact scalar)

  /**
   * Multiply by a scalar value.
   * @throws ArithmeticException if overflow occurs
   */
  operator fun times(scalar: Long) = this.toLongCenturies() * scalar

  /**
   * Divide by a scalar value.
   * @throws ArithmeticException if overflow occurs or the scalar is zero
   */
  operator fun div(scalar: Int): IntCenturies {
     return if (scalar == -1) {
       -this
     } else {
       IntCenturies(value / scalar)
     }
  }

  /**
   * Divide by a scalar value.
   * @throws ArithmeticException if the scalar is zero
   */
  operator fun div(scalar: Long): LongCenturies = this.toLongCenturies() / scalar
  operator fun rem(scalar: Int) = IntCenturies(value % scalar)

  operator fun rem(scalar: Long) = this.toLongCenturies() % scalar

  operator fun plus(months: IntMonths) = this.inMonths + months

  operator fun minus(months: IntMonths) = this.inMonths - months

  operator fun plus(months: LongMonths) = this.toLongCenturies().inMonths + months

  operator fun minus(months: LongMonths) = this.toLongCenturies().inMonths - months

  operator fun plus(years: IntYears) = this.inYears + years

  operator fun minus(years: IntYears) = this.inYears - years

  operator fun plus(years: LongYears) = this.toLongCenturies().inYears + years

  operator fun minus(years: LongYears) = this.toLongCenturies().inYears - years

  operator fun plus(decades: IntDecades) = this.inDecades + decades

  operator fun minus(decades: IntDecades) = this.inDecades - decades

  operator fun plus(decades: LongDecades) = this.toLongCenturies().inDecades + decades

  operator fun minus(decades: LongDecades) = this.toLongCenturies().inDecades - decades

  operator fun plus(centuries: IntCenturies) = IntCenturies(value plusExact centuries.value)

  operator fun minus(centuries: IntCenturies) = IntCenturies(value minusExact centuries.value)

  operator fun plus(centuries: LongCenturies) = LongCenturies(value.toLong() plusExact
      centuries.value)

  operator fun minus(centuries: LongCenturies) = LongCenturies(value.toLong() minusExact
      centuries.value)

  /**
   * Convert to [LongCenturies].
   */
  fun toLongCenturies() = LongCenturies(value.toLong())

  /**
   * Convert to a unit-less `Long` value.
   */
  fun toLong() = value.toLong()

  companion object {
    /**
     * The smallest supported value.
     */
    val MIN: IntCenturies = IntCenturies(Int.MIN_VALUE)

    /**
     * The largest supported value.
     */
    val MAX: IntCenturies = IntCenturies(Int.MAX_VALUE)
  }
}

/**
 * Convert to [IntCenturies].
 */
val Int.centuries: IntCenturies
  get() = IntCenturies(this)

/**
 * Multiply by a number of centuries.
 * @throws ArithmeticException if overflow occurs
 */
operator fun Int.times(centuries: IntCenturies) = centuries * this

/**
 * Multiply by a number of centuries.
 * @throws ArithmeticException if overflow occurs
 */
operator fun Long.times(centuries: IntCenturies) = centuries * this

/**
 * A number of centuries.
 */
inline class LongCenturies(
  /**
   * The underlying value.
   */
  val value: Long
) : Comparable<LongCenturies> {
  /**
   * Returns the absolute value.
   * @throws ArithmeticException if overflow occurs
   */
  val absoluteValue: LongCenturies
    get() = if (value < 0) -this else this
  /**
   * Convert to months.
   * @throws ArithmeticException if overflow occurs
   */
  val inMonths: LongMonths
    get() = (value timesExact MONTHS_PER_CENTURY).months

  /**
   * Convert to months without checking for overflow.
   */
  internal val inMonthsUnchecked: LongMonths
    get() = (value * MONTHS_PER_CENTURY).months

  /**
   * Convert to years.
   * @throws ArithmeticException if overflow occurs
   */
  val inYears: LongYears
    get() = (value timesExact YEARS_PER_CENTURY).years

  /**
   * Convert to years without checking for overflow.
   */
  internal val inYearsUnchecked: LongYears
    get() = (value * YEARS_PER_CENTURY).years

  /**
   * Convert to decades.
   * @throws ArithmeticException if overflow occurs
   */
  val inDecades: LongDecades
    get() = (value timesExact DECADES_PER_CENTURY).decades

  /**
   * Convert to decades without checking for overflow.
   */
  internal val inDecadesUnchecked: LongDecades
    get() = (value * DECADES_PER_CENTURY).decades

  /**
   * Is this duration zero?
   */
  fun isZero(): Boolean = value == 0L

  /**
   * Is this duration negative?
   */
  fun isNegative(): Boolean = value < 0L

  /**
   * Is this duration positive?
   */
  fun isPositive(): Boolean = value > 0L

  override fun compareTo(other: LongCenturies): Int = value.compareTo(other.value)

  /**
   * Convert to an ISO-8601 time interval representation.
   */
  override fun toString(): String {
     return when (value) {
       0L -> "P0Y"
       Long.MIN_VALUE -> "-P9223372036854775808Y"
       else -> buildString {
         if (value < 0) { append('-') }
         append("P")
         append(value.absoluteValue timesExact 100)
         append('Y')
       }
     }
  }

  /**
   * Negate the value.
   * @throws ArithmeticException if overflow occurs
   */
  operator fun unaryMinus() = LongCenturies(value.negateExact())

  /**
   * Negate the value without checking for overflow.
   */
  internal fun negateUnchecked() = LongCenturies(-value)

  /**
   * Multiply by a scalar value.
   * @throws ArithmeticException if overflow occurs
   */
  operator fun times(scalar: Int) = LongCenturies(value timesExact scalar)

  /**
   * Multiply by a scalar value.
   * @throws ArithmeticException if overflow occurs
   */
  operator fun times(scalar: Long) = LongCenturies(value timesExact scalar)

  /**
   * Divide by a scalar value.
   * @throws ArithmeticException if overflow occurs or the scalar is zero
   */
  operator fun div(scalar: Int): LongCenturies {
     return if (scalar == -1) {
       -this
     } else {
       LongCenturies(value / scalar)
     }
  }

  /**
   * Divide by a scalar value.
   * @throws ArithmeticException if overflow occurs or the scalar is zero
   */
  operator fun div(scalar: Long): LongCenturies {
     return if (scalar == -1L) {
       -this
     } else {
       LongCenturies(value / scalar)
     }
  }

  operator fun rem(scalar: Int) = LongCenturies(value % scalar)

  operator fun rem(scalar: Long) = LongCenturies(value % scalar)

  operator fun plus(months: IntMonths) = this.inMonths + months

  operator fun minus(months: IntMonths) = this.inMonths - months

  operator fun plus(months: LongMonths) = this.inMonths + months

  operator fun minus(months: LongMonths) = this.inMonths - months

  operator fun plus(years: IntYears) = this.inYears + years

  operator fun minus(years: IntYears) = this.inYears - years

  operator fun plus(years: LongYears) = this.inYears + years

  operator fun minus(years: LongYears) = this.inYears - years

  operator fun plus(decades: IntDecades) = this.inDecades + decades

  operator fun minus(decades: IntDecades) = this.inDecades - decades

  operator fun plus(decades: LongDecades) = this.inDecades + decades

  operator fun minus(decades: LongDecades) = this.inDecades - decades

  operator fun plus(centuries: IntCenturies) = LongCenturies(value plusExact centuries.value)

  operator fun minus(centuries: IntCenturies) = LongCenturies(value minusExact centuries.value)

  operator fun plus(centuries: LongCenturies) = LongCenturies(value plusExact centuries.value)

  operator fun minus(centuries: LongCenturies) = LongCenturies(value minusExact centuries.value)

  /**
   * Convert to [IntCenturies].
   * @throws ArithmeticException if overflow occurs
   */
  fun toIntCenturies() = IntCenturies(value.toIntExact())

  /**
   * Convert to [IntCenturies] without checking for overflow.
   */
  @PublishedApi
  internal fun toIntCenturiesUnchecked() = IntCenturies(value.toInt())

  /**
   * Convert to a unit-less `Int` value.
   * @throws ArithmeticException if overflow occurs
   */
  fun toInt() = value.toIntExact()

  /**
   * Convert to a unit-less `Int` value without checking for overflow.
   */
  internal fun toIntUnchecked() = value.toInt()

  companion object {
    /**
     * The smallest supported value.
     */
    val MIN: LongCenturies = LongCenturies(Long.MIN_VALUE)

    /**
     * The largest supported value.
     */
    val MAX: LongCenturies = LongCenturies(Long.MAX_VALUE)
  }
}

/**
 * Convert to [LongCenturies].
 */
val Long.centuries: LongCenturies
  get() = LongCenturies(this)

/**
 * Multiply by a number of centuries.
 * @throws ArithmeticException if overflow occurs
 */
operator fun Int.times(centuries: LongCenturies) = centuries * this

/**
 * Multiply by a number of centuries.
 * @throws ArithmeticException if overflow occurs
 */
operator fun Long.times(centuries: LongCenturies) = centuries * this
