//
// This file is auto-generated by 'tools:code-generator'
//
@file:JvmMultifileClass
@file:JvmName("WeeksKt")

package io.islandtime.measures

import io.islandtime.internal.DAYS_PER_WEEK
import io.islandtime.internal.minusExact
import io.islandtime.internal.negateExact
import io.islandtime.internal.plusExact
import io.islandtime.internal.timesExact
import io.islandtime.internal.toIntExact
import kotlin.Boolean
import kotlin.Comparable
import kotlin.Int
import kotlin.Long
import kotlin.PublishedApi
import kotlin.String
import kotlin.jvm.JvmMultifileClass
import kotlin.jvm.JvmName
import kotlin.math.absoluteValue

/**
 * A number of weeks.
 */
inline class IntWeeks(
  /**
   * The underlying value.
   */
  val value: Int
) : Comparable<IntWeeks> {
  /**
   * Returns the absolute value.
   * @throws ArithmeticException if overflow occurs
   */
  val absoluteValue: IntWeeks
    get() = if (value < 0) -this else this
  /**
   * Convert to days.
   * @throws ArithmeticException if overflow occurs
   */
  val inDays: IntDays
    get() = (value timesExact DAYS_PER_WEEK).days

  /**
   * Convert to days without checking for overflow.
   */
  internal val inDaysUnchecked: IntDays
    get() = (value * DAYS_PER_WEEK).days

  /**
   * Is this duration zero?
   */
  fun isZero(): Boolean = value == 0

  /**
   * Is this duration negative?
   */
  fun isNegative(): Boolean = value < 0

  /**
   * Is this duration positive?
   */
  fun isPositive(): Boolean = value > 0

  override fun compareTo(other: IntWeeks): Int = value.compareTo(other.value)

  /**
   * Convert to an ISO-8601 time interval representation.
   */
  override fun toString(): String {
     return when (value) {
       0 -> "P0W"
       Int.MIN_VALUE -> "-P2147483648W"
       else -> buildString {
         if (value < 0) { append('-') }
         append("P")
         append(value.absoluteValue)
         append('W')
       }
     }
  }

  /**
   * Negate the value.
   * @throws ArithmeticException if overflow occurs
   */
  operator fun unaryMinus() = IntWeeks(value.negateExact())

  /**
   * Negate the value without checking for overflow.
   */
  internal fun negateUnchecked() = IntWeeks(-value)

  /**
   * Multiply by a scalar value.
   * @throws ArithmeticException if overflow occurs
   */
  operator fun times(scalar: Int) = IntWeeks(value timesExact scalar)

  /**
   * Multiply by a scalar value.
   * @throws ArithmeticException if overflow occurs
   */
  operator fun times(scalar: Long) = this.toLongWeeks() * scalar

  /**
   * Divide by a scalar value.
   * @throws ArithmeticException if overflow occurs or the scalar is zero
   */
  operator fun div(scalar: Int): IntWeeks {
     return if (scalar == -1) {
       -this
     } else {
       IntWeeks(value / scalar)
     }
  }

  /**
   * Divide by a scalar value.
   * @throws ArithmeticException if the scalar is zero
   */
  operator fun div(scalar: Long): LongWeeks = this.toLongWeeks() / scalar
  operator fun rem(scalar: Int) = IntWeeks(value % scalar)

  operator fun rem(scalar: Long) = this.toLongWeeks() % scalar

  operator fun plus(days: IntDays) = this.inDays + days

  operator fun minus(days: IntDays) = this.inDays - days

  operator fun plus(days: LongDays) = this.toLongWeeks().inDays + days

  operator fun minus(days: LongDays) = this.toLongWeeks().inDays - days

  operator fun plus(weeks: IntWeeks) = IntWeeks(value plusExact weeks.value)

  operator fun minus(weeks: IntWeeks) = IntWeeks(value minusExact weeks.value)

  operator fun plus(weeks: LongWeeks) = LongWeeks(value.toLong() plusExact weeks.value)

  operator fun minus(weeks: LongWeeks) = LongWeeks(value.toLong() minusExact weeks.value)

  /**
   * Convert to [LongWeeks].
   */
  fun toLongWeeks() = LongWeeks(value.toLong())

  /**
   * Convert to a unit-less `Long` value.
   */
  fun toLong() = value.toLong()

  companion object {
    /**
     * The smallest supported value.
     */
    val MIN: IntWeeks = IntWeeks(Int.MIN_VALUE)

    /**
     * The largest supported value.
     */
    val MAX: IntWeeks = IntWeeks(Int.MAX_VALUE)
  }
}

/**
 * Convert to [IntWeeks].
 */
val Int.weeks: IntWeeks
  get() = IntWeeks(this)

/**
 * Multiply by a number of weeks.
 * @throws ArithmeticException if overflow occurs
 */
operator fun Int.times(weeks: IntWeeks) = weeks * this

/**
 * Multiply by a number of weeks.
 * @throws ArithmeticException if overflow occurs
 */
operator fun Long.times(weeks: IntWeeks) = weeks * this

/**
 * A number of weeks.
 */
inline class LongWeeks(
  /**
   * The underlying value.
   */
  val value: Long
) : Comparable<LongWeeks> {
  /**
   * Returns the absolute value.
   * @throws ArithmeticException if overflow occurs
   */
  val absoluteValue: LongWeeks
    get() = if (value < 0) -this else this
  /**
   * Convert to days.
   * @throws ArithmeticException if overflow occurs
   */
  val inDays: LongDays
    get() = (value timesExact DAYS_PER_WEEK).days

  /**
   * Convert to days without checking for overflow.
   */
  internal val inDaysUnchecked: LongDays
    get() = (value * DAYS_PER_WEEK).days

  /**
   * Is this duration zero?
   */
  fun isZero(): Boolean = value == 0L

  /**
   * Is this duration negative?
   */
  fun isNegative(): Boolean = value < 0L

  /**
   * Is this duration positive?
   */
  fun isPositive(): Boolean = value > 0L

  override fun compareTo(other: LongWeeks): Int = value.compareTo(other.value)

  /**
   * Convert to an ISO-8601 time interval representation.
   */
  override fun toString(): String {
     return when (value) {
       0L -> "P0W"
       Long.MIN_VALUE -> "-P9223372036854775808W"
       else -> buildString {
         if (value < 0) { append('-') }
         append("P")
         append(value.absoluteValue)
         append('W')
       }
     }
  }

  /**
   * Negate the value.
   * @throws ArithmeticException if overflow occurs
   */
  operator fun unaryMinus() = LongWeeks(value.negateExact())

  /**
   * Negate the value without checking for overflow.
   */
  internal fun negateUnchecked() = LongWeeks(-value)

  /**
   * Multiply by a scalar value.
   * @throws ArithmeticException if overflow occurs
   */
  operator fun times(scalar: Int) = LongWeeks(value timesExact scalar)

  /**
   * Multiply by a scalar value.
   * @throws ArithmeticException if overflow occurs
   */
  operator fun times(scalar: Long) = LongWeeks(value timesExact scalar)

  /**
   * Divide by a scalar value.
   * @throws ArithmeticException if overflow occurs or the scalar is zero
   */
  operator fun div(scalar: Int): LongWeeks {
     return if (scalar == -1) {
       -this
     } else {
       LongWeeks(value / scalar)
     }
  }

  /**
   * Divide by a scalar value.
   * @throws ArithmeticException if overflow occurs or the scalar is zero
   */
  operator fun div(scalar: Long): LongWeeks {
     return if (scalar == -1L) {
       -this
     } else {
       LongWeeks(value / scalar)
     }
  }

  operator fun rem(scalar: Int) = LongWeeks(value % scalar)

  operator fun rem(scalar: Long) = LongWeeks(value % scalar)

  operator fun plus(days: IntDays) = this.inDays + days

  operator fun minus(days: IntDays) = this.inDays - days

  operator fun plus(days: LongDays) = this.inDays + days

  operator fun minus(days: LongDays) = this.inDays - days

  operator fun plus(weeks: IntWeeks) = LongWeeks(value plusExact weeks.value)

  operator fun minus(weeks: IntWeeks) = LongWeeks(value minusExact weeks.value)

  operator fun plus(weeks: LongWeeks) = LongWeeks(value plusExact weeks.value)

  operator fun minus(weeks: LongWeeks) = LongWeeks(value minusExact weeks.value)

  /**
   * Convert to [IntWeeks].
   * @throws ArithmeticException if overflow occurs
   */
  fun toIntWeeks() = IntWeeks(value.toIntExact())

  /**
   * Convert to [IntWeeks] without checking for overflow.
   */
  @PublishedApi
  internal fun toIntWeeksUnchecked() = IntWeeks(value.toInt())

  /**
   * Convert to a unit-less `Int` value.
   * @throws ArithmeticException if overflow occurs
   */
  fun toInt() = value.toIntExact()

  /**
   * Convert to a unit-less `Int` value without checking for overflow.
   */
  internal fun toIntUnchecked() = value.toInt()

  companion object {
    /**
     * The smallest supported value.
     */
    val MIN: LongWeeks = LongWeeks(Long.MIN_VALUE)

    /**
     * The largest supported value.
     */
    val MAX: LongWeeks = LongWeeks(Long.MAX_VALUE)
  }
}

/**
 * Convert to [LongWeeks].
 */
val Long.weeks: LongWeeks
  get() = LongWeeks(this)

/**
 * Multiply by a number of weeks.
 * @throws ArithmeticException if overflow occurs
 */
operator fun Int.times(weeks: LongWeeks) = weeks * this

/**
 * Multiply by a number of weeks.
 * @throws ArithmeticException if overflow occurs
 */
operator fun Long.times(weeks: LongWeeks) = weeks * this
