/*
 * Decompiled with CFR 0.152.
 */
package io.iworkflow.core;

import io.iworkflow.core.ClientOptions;
import io.iworkflow.core.ImmutableUnregisteredWorkflowOptions;
import io.iworkflow.core.ObjectWorkflow;
import io.iworkflow.core.Registry;
import io.iworkflow.core.ResetWorkflowTypeAndOptions;
import io.iworkflow.core.StateDef;
import io.iworkflow.core.StopWorkflowOptions;
import io.iworkflow.core.UnregisteredClient;
import io.iworkflow.core.WorkflowDefinitionException;
import io.iworkflow.core.WorkflowOptions;
import io.iworkflow.core.WorkflowState;
import io.iworkflow.gen.models.KeyValue;
import io.iworkflow.gen.models.SearchAttribute;
import io.iworkflow.gen.models.SearchAttributeKeyAndType;
import io.iworkflow.gen.models.SearchAttributeValueType;
import io.iworkflow.gen.models.StateCompletionOutput;
import io.iworkflow.gen.models.WorkflowGetDataObjectsResponse;
import io.iworkflow.gen.models.WorkflowGetSearchAttributesResponse;
import io.iworkflow.gen.models.WorkflowSearchRequest;
import io.iworkflow.gen.models.WorkflowSearchResponse;
import io.iworkflow.gen.models.WorkflowStateOptions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Client {
    private final Registry registry;
    private final UnregisteredClient unregisteredClient;
    final ClientOptions clientOptions;

    public Client(Registry registry, ClientOptions clientOptions) {
        this.registry = registry;
        this.clientOptions = clientOptions;
        this.unregisteredClient = new UnregisteredClient(clientOptions);
    }

    public UnregisteredClient getUnregisteredClient() {
        return this.unregisteredClient;
    }

    public String startWorkflow(ObjectWorkflow workflow, String workflowId, int workflowTimeoutSeconds) {
        return this.startWorkflow(workflow, workflowId, workflowTimeoutSeconds, null, null);
    }

    public String startWorkflow(ObjectWorkflow workflow, String workflowId, int workflowTimeoutSeconds, Object input) {
        return this.startWorkflow(workflow, workflowId, workflowTimeoutSeconds, input, null);
    }

    public String startWorkflow(ObjectWorkflow workflow, String workflowId, int workflowTimeoutSeconds, Object input, WorkflowOptions options) {
        String wfType = Registry.getWorkflowType(workflow);
        return this.doStartWorkflow(wfType, workflowId, workflowTimeoutSeconds, input, options);
    }

    public String startWorkflow(Class<? extends ObjectWorkflow> workflowClass, String workflowId, int workflowTimeoutSeconds) {
        return this.startWorkflow(workflowClass, workflowId, workflowTimeoutSeconds, null, null);
    }

    public String startWorkflow(Class<? extends ObjectWorkflow> workflowClass, String workflowId, int workflowTimeoutSeconds, Object input) {
        return this.startWorkflow(workflowClass, workflowId, workflowTimeoutSeconds, input, null);
    }

    public String startWorkflow(Class<? extends ObjectWorkflow> workflowClass, String workflowId, int workflowTimeoutSeconds, Object input, WorkflowOptions option) {
        String wfType = workflowClass.getSimpleName();
        return this.doStartWorkflow(wfType, workflowId, workflowTimeoutSeconds, input, option);
    }

    private String doStartWorkflow(String wfType, String workflowId, int workflowTimeoutSeconds, Object input, WorkflowOptions options) {
        ImmutableUnregisteredWorkflowOptions.Builder unregisterWorkflowOptions = ImmutableUnregisteredWorkflowOptions.builder();
        StateDef stateDef = this.registry.getWorkflowStartingState(wfType);
        Class registeredInputType = stateDef.getWorkflowState().getInputType();
        if (input != null && !registeredInputType.isAssignableFrom(input.getClass())) {
            throw new WorkflowDefinitionException(String.format("input cannot be assigned to the starting state, input type: %s, starting state input type: %s", input.getClass(), registeredInputType));
        }
        WorkflowStateOptions stateOptions = stateDef.getWorkflowState().getStateOptions();
        if (WorkflowState.shouldSkipWaitUntil(stateDef.getWorkflowState())) {
            if (stateOptions == null) {
                stateOptions = new WorkflowStateOptions().skipWaitUntil(true);
            } else {
                stateOptions.skipWaitUntil(true);
            }
        }
        if (stateOptions != null) {
            unregisterWorkflowOptions.startStateOptions(stateOptions);
        }
        if (options != null) {
            unregisterWorkflowOptions.workflowIdReusePolicy(options.getWorkflowIdReusePolicy());
            unregisterWorkflowOptions.cronSchedule(options.getCronSchedule());
            unregisterWorkflowOptions.workflowRetryPolicy(options.getWorkflowRetryPolicy());
            unregisterWorkflowOptions.workflowConfigOverride(options.getWorkflowConfigOverride());
            Map<String, SearchAttributeValueType> saTypes = this.registry.getSearchAttributeKeyToTypeMap(wfType);
            List<SearchAttribute> convertedSAs = this.convertToSearchAttributeList(saTypes, options.getInitialSearchAttribute());
            unregisterWorkflowOptions.initialSearchAttribute(convertedSAs);
        }
        return this.unregisteredClient.startWorkflow(wfType, stateDef.getWorkflowState().getStateId(), workflowId, workflowTimeoutSeconds, input, unregisterWorkflowOptions.build());
    }

    private List<SearchAttribute> convertToSearchAttributeList(Map<String, SearchAttributeValueType> saTypes, Map<String, Object> initialSearchAttribute) {
        ArrayList<SearchAttribute> convertedSAs = new ArrayList<SearchAttribute>();
        if (initialSearchAttribute.size() > 0) {
            initialSearchAttribute.forEach((saKey, val) -> {
                if (!saTypes.containsKey(saKey)) {
                    throw new WorkflowDefinitionException(String.format("key %s is not defined as search attribute, all keys are: %s ", saKey, saTypes.keySet()));
                }
                SearchAttributeValueType valType = (SearchAttributeValueType)((Object)((Object)saTypes.get(saKey)));
                SearchAttribute newSa = new SearchAttribute().key((String)saKey).valueType(valType);
                boolean isValCorrectType = false;
                switch (valType) {
                    case INT: {
                        if (val instanceof Integer) {
                            Long lVal = ((Integer)val).longValue();
                            convertedSAs.add(newSa.integerValue(lVal));
                            isValCorrectType = true;
                        }
                        if (!(val instanceof Long)) break;
                        convertedSAs.add(newSa.integerValue((Long)val));
                        isValCorrectType = true;
                        break;
                    }
                    case DOUBLE: {
                        if (val instanceof Float) {
                            Double lVal = ((Float)val).doubleValue();
                            convertedSAs.add(newSa.doubleValue(lVal));
                            isValCorrectType = true;
                        }
                        if (!(val instanceof Double)) break;
                        convertedSAs.add(new SearchAttribute().doubleValue((Double)val));
                        isValCorrectType = true;
                        break;
                    }
                    case BOOL: {
                        if (!(val instanceof Boolean)) break;
                        convertedSAs.add(newSa.boolValue((Boolean)val));
                        isValCorrectType = true;
                        break;
                    }
                    case KEYWORD: 
                    case TEXT: 
                    case DATETIME: {
                        if (!(val instanceof String)) break;
                        convertedSAs.add(newSa.stringValue((String)val));
                        isValCorrectType = true;
                        break;
                    }
                    case KEYWORD_ARRAY: {
                        if (!(val instanceof List)) break;
                        List listArr = (List)val;
                        convertedSAs.add(newSa.stringArrayValue(listArr));
                        isValCorrectType = true;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("unsupported type");
                    }
                }
                if (!isValCorrectType) {
                    throw new IllegalArgumentException(String.format("search attribute value is not set correctly for key %s with value type %s", new Object[]{saKey, valType}));
                }
            });
        }
        return convertedSAs;
    }

    public <T> T getSimpleWorkflowResultWithWait(Class<T> valueClass, String workflowId, String workflowRunId) {
        return this.unregisteredClient.getSimpleWorkflowResultWithWait(valueClass, workflowId, workflowRunId);
    }

    public <T> T getSimpleWorkflowResultWithWait(Class<T> valueClass, String workflowId) {
        return this.getSimpleWorkflowResultWithWait(valueClass, workflowId, "");
    }

    public List<StateCompletionOutput> getComplexWorkflowResultWithWait(String workflowId, String workflowRunId) {
        return this.unregisteredClient.getComplexWorkflowResultWithWait(workflowId, workflowRunId);
    }

    public List<StateCompletionOutput> getComplexWorkflowResultWithWait(String workflowId) {
        return this.getComplexWorkflowResultWithWait(workflowId, "");
    }

    public void signalWorkflow(Class<? extends ObjectWorkflow> workflowClass, String workflowId, String workflowRunId, String signalChannelName, Object signalValue) {
        String wfType = workflowClass.getSimpleName();
        Map<String, Class<?>> nameToTypeMap = this.registry.getSignalChannelNameToSignalTypeMap(wfType);
        if (nameToTypeMap == null) {
            throw new IllegalArgumentException(String.format("Workflow %s is not registered", wfType));
        }
        if (!nameToTypeMap.containsKey(signalChannelName)) {
            throw new IllegalArgumentException(String.format("Workflow %s doesn't have signal %s", wfType, signalChannelName));
        }
        Class<?> signalType = nameToTypeMap.get(signalChannelName);
        if (signalValue != null && !signalType.isInstance(signalValue)) {
            throw new IllegalArgumentException(String.format("Signal value is not of type %s", signalType.getName()));
        }
        this.unregisteredClient.signalWorkflow(workflowId, workflowRunId, signalChannelName, signalValue);
    }

    public String resetWorkflow(String workflowId, String workflowRunId, ResetWorkflowTypeAndOptions resetWorkflowTypeAndOptions) {
        return this.unregisteredClient.resetWorkflow(workflowId, workflowRunId, resetWorkflowTypeAndOptions);
    }

    public void stopWorkflow(String workflowId, String workflowRunId) {
        this.unregisteredClient.stopWorkflow(workflowId, workflowRunId);
    }

    public void stopWorkflow(String workflowId, String workflowRunId, StopWorkflowOptions options) {
        this.unregisteredClient.stopWorkflow(workflowId, workflowRunId, options);
    }

    public Map<String, Object> getWorkflowDataObjects(Class<? extends ObjectWorkflow> workflowClass, String workflowId, String workflowRunId, List<String> keys) {
        if (keys == null || keys.isEmpty()) {
            throw new IllegalArgumentException("keys must contain at least one entry, or use getAllDataObjects API to get all");
        }
        return this.doGetWorkflowDataObjects(workflowClass, workflowId, workflowRunId, keys);
    }

    public Map<String, Object> getAllDataObjects(Class<? extends ObjectWorkflow> workflowClass, String workflowId, String workflowRunId) {
        return this.doGetWorkflowDataObjects(workflowClass, workflowId, workflowRunId, null);
    }

    private Map<String, Object> doGetWorkflowDataObjects(Class<? extends ObjectWorkflow> workflowClass, String workflowId, String workflowRunId, List<String> keys) {
        List nonExistingDataObjectKeyList;
        String wfType = workflowClass.getSimpleName();
        Map<String, Class<?>> queryDataObjectKeyToTypeMap = this.registry.getDataAttributeKeyToTypeMap(wfType);
        if (queryDataObjectKeyToTypeMap == null) {
            throw new IllegalArgumentException(String.format("Workflow %s is not registered", wfType));
        }
        if (keys != null && !keys.isEmpty() && !(nonExistingDataObjectKeyList = keys.stream().filter(s -> !queryDataObjectKeyToTypeMap.containsKey(s)).collect(Collectors.toList())).isEmpty()) {
            throw new IllegalArgumentException(String.format("data attributes not registered: %s", String.join((CharSequence)", ", nonExistingDataObjectKeyList)));
        }
        WorkflowGetDataObjectsResponse response = this.unregisteredClient.getAnyWorkflowDataObjects(workflowId, workflowRunId, keys);
        if (response.getObjects() == null) {
            throw new IllegalStateException("data attributes not returned");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (KeyValue keyValue : response.getObjects()) {
            if (keyValue.getValue() == null) continue;
            result.put(keyValue.getKey(), this.clientOptions.getObjectEncoder().decode(keyValue.getValue(), queryDataObjectKeyToTypeMap.get(keyValue.getKey())));
        }
        return result;
    }

    public WorkflowSearchResponse searchWorkflow(String query, int pageSize) {
        return this.unregisteredClient.searchWorkflow(query, pageSize);
    }

    public WorkflowSearchResponse searchWorkflow(WorkflowSearchRequest request) {
        return this.unregisteredClient.searchWorkflow(request);
    }

    public Map<String, Object> getWorkflowSearchAttributes(Class<? extends ObjectWorkflow> workflowClass, String workflowId, String workflowRunId, List<String> attributeKeys) {
        if (attributeKeys == null || attributeKeys.isEmpty()) {
            throw new IllegalArgumentException("attributeKeys must contain at least one entry, or use GetAllSearchAttributes API to get all");
        }
        return this.doGetWorkflowSearchAttributes(workflowClass, workflowId, workflowRunId, attributeKeys);
    }

    public Map<String, Object> getAllSearchAttributes(Class<? extends ObjectWorkflow> workflowClass, String workflowId, String workflowRunId) {
        return this.doGetWorkflowSearchAttributes(workflowClass, workflowId, workflowRunId, null);
    }

    private Map<String, Object> doGetWorkflowSearchAttributes(Class<? extends ObjectWorkflow> workflowClass, String workflowId, String workflowRunId, List<String> attributeKeys) {
        List nonExistingSearchAttributeList;
        String wfType = workflowClass.getSimpleName();
        Map<String, SearchAttributeValueType> searchAttributeKeyToTypeMap = this.registry.getSearchAttributeKeyToTypeMap(wfType);
        if (searchAttributeKeyToTypeMap == null) {
            throw new IllegalArgumentException(String.format("Workflow %s is not registered", wfType));
        }
        if (attributeKeys != null && !attributeKeys.isEmpty() && !(nonExistingSearchAttributeList = attributeKeys.stream().filter(s -> !searchAttributeKeyToTypeMap.containsKey(s)).collect(Collectors.toList())).isEmpty()) {
            throw new IllegalArgumentException(String.format("Search attributes not registered: %s", String.join((CharSequence)", ", nonExistingSearchAttributeList)));
        }
        ArrayList<SearchAttributeKeyAndType> keyAndTypes = new ArrayList<SearchAttributeKeyAndType>();
        if (attributeKeys == null) {
            searchAttributeKeyToTypeMap.forEach((key, type) -> {
                SearchAttributeKeyAndType keyAndType = new SearchAttributeKeyAndType().key((String)key).valueType((SearchAttributeValueType)((Object)type));
                keyAndTypes.add(keyAndType);
            });
        } else {
            attributeKeys.forEach(key -> {
                SearchAttributeValueType saType = (SearchAttributeValueType)((Object)((Object)searchAttributeKeyToTypeMap.get(key)));
                SearchAttributeKeyAndType keyAndType = new SearchAttributeKeyAndType().key((String)key).valueType(saType);
                keyAndTypes.add(keyAndType);
            });
        }
        WorkflowGetSearchAttributesResponse response = this.unregisteredClient.getAnyWorkflowSearchAttributes(workflowId, workflowRunId, keyAndTypes);
        if (response.getSearchAttributes() == null) {
            throw new IllegalStateException("search attributes not returned");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (SearchAttribute searchAttribute : response.getSearchAttributes()) {
            SearchAttributeValueType saType = searchAttributeKeyToTypeMap.get(searchAttribute.getKey());
            Object value = Client.getSearchAttributeValue(saType, searchAttribute);
            result.put(searchAttribute.getKey(), value);
        }
        return result;
    }

    static Object getSearchAttributeValue(SearchAttributeValueType saType, SearchAttribute searchAttribute) {
        switch (saType) {
            case INT: {
                return searchAttribute.getIntegerValue();
            }
            case DOUBLE: {
                return searchAttribute.getDoubleValue();
            }
            case BOOL: {
                return searchAttribute.getBoolValue();
            }
            case KEYWORD: 
            case TEXT: 
            case DATETIME: {
                return searchAttribute.getStringValue();
            }
            case KEYWORD_ARRAY: {
                return searchAttribute.getStringArrayValue();
            }
        }
        throw new IllegalStateException("unsupported type");
    }

    public void skipTimer(String workflowId, String workflowRunId, Class<? extends WorkflowState> stateClass, int stateExecutionNumber, String timerCommandId) {
        this.skipTimer(workflowId, workflowRunId, stateClass.getSimpleName(), stateExecutionNumber, timerCommandId);
    }

    public void skipTimer(String workflowId, String workflowRunId, String workflowStateId, int stateExecutionNumber, String timerCommandId) {
        this.unregisteredClient.skipTimer(workflowId, workflowRunId, workflowStateId, stateExecutionNumber, timerCommandId);
    }

    public void skipTimer(String workflowId, String workflowRunId, Class<? extends WorkflowState> stateClass, int stateExecutionNumber, int timerCommandIndex) {
        this.skipTimer(workflowId, workflowRunId, stateClass.getSimpleName(), stateExecutionNumber, timerCommandIndex);
    }

    public void skipTimer(String workflowId, String workflowRunId, String workflowStateId, int stateExecutionNumber, int timerCommandIndex) {
        this.unregisteredClient.skipTimer(workflowId, workflowRunId, workflowStateId, stateExecutionNumber, timerCommandIndex);
    }
}

