/*
 * Decompiled with CFR 0.152.
 */
package io.iworkflow.core;

import io.iworkflow.core.ImmutableClientOptions;
import io.iworkflow.core.JacksonJsonObjectEncoder;
import io.iworkflow.core.ObjectEncoder;
import org.immutables.value.Value;

@Value.Immutable
public abstract class ClientOptions {
    public static final String defaultWorkerUrl = "http://localhost:8802";
    public static final String workerUrlFromDocker = "http://host.docker.internal:8802";
    public static final String defaultServerUrl = "http://localhost:8801";
    public static final ClientOptions localDefault = ClientOptions.minimum("http://localhost:8802", "http://localhost:8801");
    public static final ClientOptions dockerDefault = ClientOptions.minimum("http://host.docker.internal:8802", "http://localhost:8801");

    public abstract String getServerUrl();

    public abstract String getWorkerUrl();

    public abstract ObjectEncoder getObjectEncoder();

    public static ClientOptions minimum(String workerUrl, String serverUrl) {
        return ImmutableClientOptions.builder().workerUrl(workerUrl).serverUrl(serverUrl).objectEncoder(new JacksonJsonObjectEncoder()).build();
    }

    public static ImmutableClientOptions.Builder builder() {
        return ImmutableClientOptions.builder();
    }
}

