/*
 * Decompiled with CFR 0.152.
 */
package io.iworkflow.core;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.iworkflow.core.ClientOptions;
import io.iworkflow.core.ObjectEncoder;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ClientOptions", generator="Immutables")
@Immutable
public final class ImmutableClientOptions
extends ClientOptions {
    private final String serverUrl;
    private final String workerUrl;
    private final ObjectEncoder objectEncoder;

    private ImmutableClientOptions(String serverUrl, String workerUrl, ObjectEncoder objectEncoder) {
        this.serverUrl = serverUrl;
        this.workerUrl = workerUrl;
        this.objectEncoder = objectEncoder;
    }

    @Override
    public String getServerUrl() {
        return this.serverUrl;
    }

    @Override
    public String getWorkerUrl() {
        return this.workerUrl;
    }

    @Override
    public ObjectEncoder getObjectEncoder() {
        return this.objectEncoder;
    }

    public final ImmutableClientOptions withServerUrl(String value) {
        String newValue = Objects.requireNonNull(value, "serverUrl");
        if (this.serverUrl.equals(newValue)) {
            return this;
        }
        return new ImmutableClientOptions(newValue, this.workerUrl, this.objectEncoder);
    }

    public final ImmutableClientOptions withWorkerUrl(String value) {
        String newValue = Objects.requireNonNull(value, "workerUrl");
        if (this.workerUrl.equals(newValue)) {
            return this;
        }
        return new ImmutableClientOptions(this.serverUrl, newValue, this.objectEncoder);
    }

    public final ImmutableClientOptions withObjectEncoder(ObjectEncoder value) {
        if (this.objectEncoder == value) {
            return this;
        }
        ObjectEncoder newValue = Objects.requireNonNull(value, "objectEncoder");
        return new ImmutableClientOptions(this.serverUrl, this.workerUrl, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableClientOptions && this.equalTo(0, (ImmutableClientOptions)another);
    }

    private boolean equalTo(int synthetic, ImmutableClientOptions another) {
        return this.serverUrl.equals(another.serverUrl) && this.workerUrl.equals(another.workerUrl) && this.objectEncoder.equals(another.objectEncoder);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.serverUrl.hashCode();
        h += (h << 5) + this.workerUrl.hashCode();
        h += (h << 5) + this.objectEncoder.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ClientOptions").omitNullValues().add("serverUrl", (Object)this.serverUrl).add("workerUrl", (Object)this.workerUrl).add("objectEncoder", (Object)this.objectEncoder).toString();
    }

    public static ImmutableClientOptions copyOf(ClientOptions instance) {
        if (instance instanceof ImmutableClientOptions) {
            return (ImmutableClientOptions)instance;
        }
        return ImmutableClientOptions.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ClientOptions", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SERVER_URL = 1L;
        private static final long INIT_BIT_WORKER_URL = 2L;
        private static final long INIT_BIT_OBJECT_ENCODER = 4L;
        private long initBits = 7L;
        @Nullable
        private String serverUrl;
        @Nullable
        private String workerUrl;
        @Nullable
        private ObjectEncoder objectEncoder;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ClientOptions instance) {
            Objects.requireNonNull(instance, "instance");
            this.serverUrl(instance.getServerUrl());
            this.workerUrl(instance.getWorkerUrl());
            this.objectEncoder(instance.getObjectEncoder());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder serverUrl(String serverUrl) {
            this.serverUrl = Objects.requireNonNull(serverUrl, "serverUrl");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder workerUrl(String workerUrl) {
            this.workerUrl = Objects.requireNonNull(workerUrl, "workerUrl");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder objectEncoder(ObjectEncoder objectEncoder) {
            this.objectEncoder = Objects.requireNonNull(objectEncoder, "objectEncoder");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableClientOptions build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableClientOptions(this.serverUrl, this.workerUrl, this.objectEncoder);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("serverUrl");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("workerUrl");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("objectEncoder");
            }
            return "Cannot build ClientOptions, some of required attributes are not set " + attributes;
        }
    }
}

