/*
 * Decompiled with CFR 0.152.
 */
package io.iworkflow.core;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.iworkflow.core.Context;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Context", generator="Immutables")
@Immutable
public final class ImmutableContext
extends Context {
    private final Long workflowStartTimestampSeconds;
    private final String stateExecutionId;
    private final String workflowRunId;
    private final String workflowId;
    private final Long firstAttemptTimestampSeconds;
    private final int attempt;

    private ImmutableContext(Long workflowStartTimestampSeconds, String stateExecutionId, String workflowRunId, String workflowId, Long firstAttemptTimestampSeconds, int attempt) {
        this.workflowStartTimestampSeconds = workflowStartTimestampSeconds;
        this.stateExecutionId = stateExecutionId;
        this.workflowRunId = workflowRunId;
        this.workflowId = workflowId;
        this.firstAttemptTimestampSeconds = firstAttemptTimestampSeconds;
        this.attempt = attempt;
    }

    @Override
    public Long getWorkflowStartTimestampSeconds() {
        return this.workflowStartTimestampSeconds;
    }

    @Override
    public String getStateExecutionId() {
        return this.stateExecutionId;
    }

    @Override
    public String getWorkflowRunId() {
        return this.workflowRunId;
    }

    @Override
    public String getWorkflowId() {
        return this.workflowId;
    }

    @Override
    public Long getFirstAttemptTimestampSeconds() {
        return this.firstAttemptTimestampSeconds;
    }

    @Override
    public int getAttempt() {
        return this.attempt;
    }

    public final ImmutableContext withWorkflowStartTimestampSeconds(Long value) {
        Long newValue = Objects.requireNonNull(value, "workflowStartTimestampSeconds");
        if (this.workflowStartTimestampSeconds.equals(newValue)) {
            return this;
        }
        return new ImmutableContext(newValue, this.stateExecutionId, this.workflowRunId, this.workflowId, this.firstAttemptTimestampSeconds, this.attempt);
    }

    public final ImmutableContext withStateExecutionId(String value) {
        String newValue = Objects.requireNonNull(value, "stateExecutionId");
        if (this.stateExecutionId.equals(newValue)) {
            return this;
        }
        return new ImmutableContext(this.workflowStartTimestampSeconds, newValue, this.workflowRunId, this.workflowId, this.firstAttemptTimestampSeconds, this.attempt);
    }

    public final ImmutableContext withWorkflowRunId(String value) {
        String newValue = Objects.requireNonNull(value, "workflowRunId");
        if (this.workflowRunId.equals(newValue)) {
            return this;
        }
        return new ImmutableContext(this.workflowStartTimestampSeconds, this.stateExecutionId, newValue, this.workflowId, this.firstAttemptTimestampSeconds, this.attempt);
    }

    public final ImmutableContext withWorkflowId(String value) {
        String newValue = Objects.requireNonNull(value, "workflowId");
        if (this.workflowId.equals(newValue)) {
            return this;
        }
        return new ImmutableContext(this.workflowStartTimestampSeconds, this.stateExecutionId, this.workflowRunId, newValue, this.firstAttemptTimestampSeconds, this.attempt);
    }

    public final ImmutableContext withFirstAttemptTimestampSeconds(Long value) {
        Long newValue = Objects.requireNonNull(value, "firstAttemptTimestampSeconds");
        if (this.firstAttemptTimestampSeconds.equals(newValue)) {
            return this;
        }
        return new ImmutableContext(this.workflowStartTimestampSeconds, this.stateExecutionId, this.workflowRunId, this.workflowId, newValue, this.attempt);
    }

    public final ImmutableContext withAttempt(int value) {
        if (this.attempt == value) {
            return this;
        }
        return new ImmutableContext(this.workflowStartTimestampSeconds, this.stateExecutionId, this.workflowRunId, this.workflowId, this.firstAttemptTimestampSeconds, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableContext && this.equalTo(0, (ImmutableContext)another);
    }

    private boolean equalTo(int synthetic, ImmutableContext another) {
        return this.workflowStartTimestampSeconds.equals(another.workflowStartTimestampSeconds) && this.stateExecutionId.equals(another.stateExecutionId) && this.workflowRunId.equals(another.workflowRunId) && this.workflowId.equals(another.workflowId) && this.firstAttemptTimestampSeconds.equals(another.firstAttemptTimestampSeconds) && this.attempt == another.attempt;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.workflowStartTimestampSeconds.hashCode();
        h += (h << 5) + this.stateExecutionId.hashCode();
        h += (h << 5) + this.workflowRunId.hashCode();
        h += (h << 5) + this.workflowId.hashCode();
        h += (h << 5) + this.firstAttemptTimestampSeconds.hashCode();
        h += (h << 5) + this.attempt;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Context").omitNullValues().add("workflowStartTimestampSeconds", (Object)this.workflowStartTimestampSeconds).add("stateExecutionId", (Object)this.stateExecutionId).add("workflowRunId", (Object)this.workflowRunId).add("workflowId", (Object)this.workflowId).add("firstAttemptTimestampSeconds", (Object)this.firstAttemptTimestampSeconds).add("attempt", this.attempt).toString();
    }

    public static ImmutableContext copyOf(Context instance) {
        if (instance instanceof ImmutableContext) {
            return (ImmutableContext)instance;
        }
        return ImmutableContext.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Context", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_WORKFLOW_START_TIMESTAMP_SECONDS = 1L;
        private static final long INIT_BIT_STATE_EXECUTION_ID = 2L;
        private static final long INIT_BIT_WORKFLOW_RUN_ID = 4L;
        private static final long INIT_BIT_WORKFLOW_ID = 8L;
        private static final long INIT_BIT_FIRST_ATTEMPT_TIMESTAMP_SECONDS = 16L;
        private static final long INIT_BIT_ATTEMPT = 32L;
        private long initBits = 63L;
        @Nullable
        private Long workflowStartTimestampSeconds;
        @Nullable
        private String stateExecutionId;
        @Nullable
        private String workflowRunId;
        @Nullable
        private String workflowId;
        @Nullable
        private Long firstAttemptTimestampSeconds;
        private int attempt;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Context instance) {
            Objects.requireNonNull(instance, "instance");
            this.workflowStartTimestampSeconds(instance.getWorkflowStartTimestampSeconds());
            this.stateExecutionId(instance.getStateExecutionId());
            this.workflowRunId(instance.getWorkflowRunId());
            this.workflowId(instance.getWorkflowId());
            this.firstAttemptTimestampSeconds(instance.getFirstAttemptTimestampSeconds());
            this.attempt(instance.getAttempt());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder workflowStartTimestampSeconds(Long workflowStartTimestampSeconds) {
            this.workflowStartTimestampSeconds = Objects.requireNonNull(workflowStartTimestampSeconds, "workflowStartTimestampSeconds");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder stateExecutionId(String stateExecutionId) {
            this.stateExecutionId = Objects.requireNonNull(stateExecutionId, "stateExecutionId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder workflowRunId(String workflowRunId) {
            this.workflowRunId = Objects.requireNonNull(workflowRunId, "workflowRunId");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder workflowId(String workflowId) {
            this.workflowId = Objects.requireNonNull(workflowId, "workflowId");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder firstAttemptTimestampSeconds(Long firstAttemptTimestampSeconds) {
            this.firstAttemptTimestampSeconds = Objects.requireNonNull(firstAttemptTimestampSeconds, "firstAttemptTimestampSeconds");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder attempt(int attempt) {
            this.attempt = attempt;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public ImmutableContext build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableContext(this.workflowStartTimestampSeconds, this.stateExecutionId, this.workflowRunId, this.workflowId, this.firstAttemptTimestampSeconds, this.attempt);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("workflowStartTimestampSeconds");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("stateExecutionId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("workflowRunId");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("workflowId");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("firstAttemptTimestampSeconds");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("attempt");
            }
            return "Cannot build Context, some of required attributes are not set " + attributes;
        }
    }
}

