/*
 * Decompiled with CFR 0.152.
 */
package io.iworkflow.core;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.iworkflow.core.ResetWorkflowTypeAndOptions;
import io.iworkflow.gen.models.WorkflowResetType;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ResetWorkflowTypeAndOptions", generator="Immutables")
@Immutable
public final class ImmutableResetWorkflowTypeAndOptions
extends ResetWorkflowTypeAndOptions {
    private final WorkflowResetType resetType;
    @Nullable
    private final Integer historyEventId;
    private final String reason;
    @Nullable
    private final String historyEventTime;
    @Nullable
    private final String stateId;
    @Nullable
    private final String stateExecutionId;
    @Nullable
    private final Boolean skipSignalReapply;

    private ImmutableResetWorkflowTypeAndOptions(WorkflowResetType resetType, @Nullable Integer historyEventId, String reason, @Nullable String historyEventTime, @Nullable String stateId, @Nullable String stateExecutionId, @Nullable Boolean skipSignalReapply) {
        this.resetType = resetType;
        this.historyEventId = historyEventId;
        this.reason = reason;
        this.historyEventTime = historyEventTime;
        this.stateId = stateId;
        this.stateExecutionId = stateExecutionId;
        this.skipSignalReapply = skipSignalReapply;
    }

    @Override
    public WorkflowResetType getResetType() {
        return this.resetType;
    }

    @Override
    public Optional<Integer> getHistoryEventId() {
        return Optional.ofNullable(this.historyEventId);
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public Optional<String> getHistoryEventTime() {
        return Optional.ofNullable(this.historyEventTime);
    }

    @Override
    public Optional<String> getStateId() {
        return Optional.ofNullable(this.stateId);
    }

    @Override
    public Optional<String> getStateExecutionId() {
        return Optional.ofNullable(this.stateExecutionId);
    }

    @Override
    public Optional<Boolean> getSkipSignalReapply() {
        return Optional.ofNullable(this.skipSignalReapply);
    }

    public final ImmutableResetWorkflowTypeAndOptions withResetType(WorkflowResetType value) {
        WorkflowResetType newValue = Objects.requireNonNull(value, "resetType");
        if (this.resetType == newValue) {
            return this;
        }
        return new ImmutableResetWorkflowTypeAndOptions(newValue, this.historyEventId, this.reason, this.historyEventTime, this.stateId, this.stateExecutionId, this.skipSignalReapply);
    }

    public final ImmutableResetWorkflowTypeAndOptions withHistoryEventId(int value) {
        Integer newValue = value;
        if (Objects.equals(this.historyEventId, newValue)) {
            return this;
        }
        return new ImmutableResetWorkflowTypeAndOptions(this.resetType, newValue, this.reason, this.historyEventTime, this.stateId, this.stateExecutionId, this.skipSignalReapply);
    }

    public final ImmutableResetWorkflowTypeAndOptions withHistoryEventId(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.historyEventId, value)) {
            return this;
        }
        return new ImmutableResetWorkflowTypeAndOptions(this.resetType, value, this.reason, this.historyEventTime, this.stateId, this.stateExecutionId, this.skipSignalReapply);
    }

    public final ImmutableResetWorkflowTypeAndOptions withReason(String value) {
        String newValue = Objects.requireNonNull(value, "reason");
        if (this.reason.equals(newValue)) {
            return this;
        }
        return new ImmutableResetWorkflowTypeAndOptions(this.resetType, this.historyEventId, newValue, this.historyEventTime, this.stateId, this.stateExecutionId, this.skipSignalReapply);
    }

    public final ImmutableResetWorkflowTypeAndOptions withHistoryEventTime(String value) {
        String newValue = Objects.requireNonNull(value, "historyEventTime");
        if (Objects.equals(this.historyEventTime, newValue)) {
            return this;
        }
        return new ImmutableResetWorkflowTypeAndOptions(this.resetType, this.historyEventId, this.reason, newValue, this.stateId, this.stateExecutionId, this.skipSignalReapply);
    }

    public final ImmutableResetWorkflowTypeAndOptions withHistoryEventTime(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.historyEventTime, value)) {
            return this;
        }
        return new ImmutableResetWorkflowTypeAndOptions(this.resetType, this.historyEventId, this.reason, value, this.stateId, this.stateExecutionId, this.skipSignalReapply);
    }

    public final ImmutableResetWorkflowTypeAndOptions withStateId(String value) {
        String newValue = Objects.requireNonNull(value, "stateId");
        if (Objects.equals(this.stateId, newValue)) {
            return this;
        }
        return new ImmutableResetWorkflowTypeAndOptions(this.resetType, this.historyEventId, this.reason, this.historyEventTime, newValue, this.stateExecutionId, this.skipSignalReapply);
    }

    public final ImmutableResetWorkflowTypeAndOptions withStateId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.stateId, value)) {
            return this;
        }
        return new ImmutableResetWorkflowTypeAndOptions(this.resetType, this.historyEventId, this.reason, this.historyEventTime, value, this.stateExecutionId, this.skipSignalReapply);
    }

    public final ImmutableResetWorkflowTypeAndOptions withStateExecutionId(String value) {
        String newValue = Objects.requireNonNull(value, "stateExecutionId");
        if (Objects.equals(this.stateExecutionId, newValue)) {
            return this;
        }
        return new ImmutableResetWorkflowTypeAndOptions(this.resetType, this.historyEventId, this.reason, this.historyEventTime, this.stateId, newValue, this.skipSignalReapply);
    }

    public final ImmutableResetWorkflowTypeAndOptions withStateExecutionId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.stateExecutionId, value)) {
            return this;
        }
        return new ImmutableResetWorkflowTypeAndOptions(this.resetType, this.historyEventId, this.reason, this.historyEventTime, this.stateId, value, this.skipSignalReapply);
    }

    public final ImmutableResetWorkflowTypeAndOptions withSkipSignalReapply(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.skipSignalReapply, newValue)) {
            return this;
        }
        return new ImmutableResetWorkflowTypeAndOptions(this.resetType, this.historyEventId, this.reason, this.historyEventTime, this.stateId, this.stateExecutionId, newValue);
    }

    public final ImmutableResetWorkflowTypeAndOptions withSkipSignalReapply(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.skipSignalReapply, value)) {
            return this;
        }
        return new ImmutableResetWorkflowTypeAndOptions(this.resetType, this.historyEventId, this.reason, this.historyEventTime, this.stateId, this.stateExecutionId, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableResetWorkflowTypeAndOptions && this.equalTo(0, (ImmutableResetWorkflowTypeAndOptions)another);
    }

    private boolean equalTo(int synthetic, ImmutableResetWorkflowTypeAndOptions another) {
        return this.resetType.equals((Object)another.resetType) && Objects.equals(this.historyEventId, another.historyEventId) && this.reason.equals(another.reason) && Objects.equals(this.historyEventTime, another.historyEventTime) && Objects.equals(this.stateId, another.stateId) && Objects.equals(this.stateExecutionId, another.stateExecutionId) && Objects.equals(this.skipSignalReapply, another.skipSignalReapply);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.resetType.hashCode();
        h += (h << 5) + Objects.hashCode(this.historyEventId);
        h += (h << 5) + this.reason.hashCode();
        h += (h << 5) + Objects.hashCode(this.historyEventTime);
        h += (h << 5) + Objects.hashCode(this.stateId);
        h += (h << 5) + Objects.hashCode(this.stateExecutionId);
        h += (h << 5) + Objects.hashCode(this.skipSignalReapply);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ResetWorkflowTypeAndOptions").omitNullValues().add("resetType", (Object)this.resetType).add("historyEventId", (Object)this.historyEventId).add("reason", (Object)this.reason).add("historyEventTime", (Object)this.historyEventTime).add("stateId", (Object)this.stateId).add("stateExecutionId", (Object)this.stateExecutionId).add("skipSignalReapply", (Object)this.skipSignalReapply).toString();
    }

    public static ImmutableResetWorkflowTypeAndOptions copyOf(ResetWorkflowTypeAndOptions instance) {
        if (instance instanceof ImmutableResetWorkflowTypeAndOptions) {
            return (ImmutableResetWorkflowTypeAndOptions)instance;
        }
        return ImmutableResetWorkflowTypeAndOptions.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ResetWorkflowTypeAndOptions", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_RESET_TYPE = 1L;
        private static final long INIT_BIT_REASON = 2L;
        private long initBits = 3L;
        @Nullable
        private WorkflowResetType resetType;
        @Nullable
        private Integer historyEventId;
        @Nullable
        private String reason;
        @Nullable
        private String historyEventTime;
        @Nullable
        private String stateId;
        @Nullable
        private String stateExecutionId;
        @Nullable
        private Boolean skipSignalReapply;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ResetWorkflowTypeAndOptions instance) {
            Optional<Boolean> skipSignalReapplyOptional;
            Optional<String> stateExecutionIdOptional;
            Optional<String> stateIdOptional;
            Objects.requireNonNull(instance, "instance");
            this.resetType(instance.getResetType());
            Optional<Integer> historyEventIdOptional = instance.getHistoryEventId();
            if (historyEventIdOptional.isPresent()) {
                this.historyEventId(historyEventIdOptional);
            }
            this.reason(instance.getReason());
            Optional<String> historyEventTimeOptional = instance.getHistoryEventTime();
            if (historyEventTimeOptional.isPresent()) {
                this.historyEventTime(historyEventTimeOptional);
            }
            if ((stateIdOptional = instance.getStateId()).isPresent()) {
                this.stateId(stateIdOptional);
            }
            if ((stateExecutionIdOptional = instance.getStateExecutionId()).isPresent()) {
                this.stateExecutionId(stateExecutionIdOptional);
            }
            if ((skipSignalReapplyOptional = instance.getSkipSignalReapply()).isPresent()) {
                this.skipSignalReapply(skipSignalReapplyOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder resetType(WorkflowResetType resetType) {
            this.resetType = Objects.requireNonNull(resetType, "resetType");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder historyEventId(int historyEventId) {
            this.historyEventId = historyEventId;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder historyEventId(Optional<Integer> historyEventId) {
            this.historyEventId = historyEventId.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder reason(String reason) {
            this.reason = Objects.requireNonNull(reason, "reason");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder historyEventTime(String historyEventTime) {
            this.historyEventTime = Objects.requireNonNull(historyEventTime, "historyEventTime");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder historyEventTime(Optional<String> historyEventTime) {
            this.historyEventTime = historyEventTime.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder stateId(String stateId) {
            this.stateId = Objects.requireNonNull(stateId, "stateId");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder stateId(Optional<String> stateId) {
            this.stateId = stateId.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder stateExecutionId(String stateExecutionId) {
            this.stateExecutionId = Objects.requireNonNull(stateExecutionId, "stateExecutionId");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder stateExecutionId(Optional<String> stateExecutionId) {
            this.stateExecutionId = stateExecutionId.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder skipSignalReapply(boolean skipSignalReapply) {
            this.skipSignalReapply = skipSignalReapply;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder skipSignalReapply(Optional<Boolean> skipSignalReapply) {
            this.skipSignalReapply = skipSignalReapply.orElse(null);
            return this;
        }

        public ImmutableResetWorkflowTypeAndOptions build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableResetWorkflowTypeAndOptions(this.resetType, this.historyEventId, this.reason, this.historyEventTime, this.stateId, this.stateExecutionId, this.skipSignalReapply);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("resetType");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("reason");
            }
            return "Cannot build ResetWorkflowTypeAndOptions, some of required attributes are not set " + attributes;
        }
    }
}

