/*
 * Decompiled with CFR 0.152.
 */
package io.iworkflow.core;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.iworkflow.core.StateDef;
import io.iworkflow.core.WorkflowState;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="StateDef", generator="Immutables")
@Immutable
public final class ImmutableStateDef
extends StateDef {
    private final WorkflowState workflowState;
    private final boolean canStartWorkflow;

    private ImmutableStateDef(WorkflowState workflowState, boolean canStartWorkflow) {
        this.workflowState = workflowState;
        this.canStartWorkflow = canStartWorkflow;
    }

    @Override
    public WorkflowState getWorkflowState() {
        return this.workflowState;
    }

    @Override
    public boolean getCanStartWorkflow() {
        return this.canStartWorkflow;
    }

    public final ImmutableStateDef withWorkflowState(WorkflowState value) {
        if (this.workflowState == value) {
            return this;
        }
        WorkflowState newValue = Objects.requireNonNull(value, "workflowState");
        return new ImmutableStateDef(newValue, this.canStartWorkflow);
    }

    public final ImmutableStateDef withCanStartWorkflow(boolean value) {
        if (this.canStartWorkflow == value) {
            return this;
        }
        return new ImmutableStateDef(this.workflowState, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStateDef && this.equalTo(0, (ImmutableStateDef)another);
    }

    private boolean equalTo(int synthetic, ImmutableStateDef another) {
        return this.workflowState.equals(another.workflowState) && this.canStartWorkflow == another.canStartWorkflow;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.workflowState.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.canStartWorkflow);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"StateDef").omitNullValues().add("workflowState", (Object)this.workflowState).add("canStartWorkflow", this.canStartWorkflow).toString();
    }

    public static ImmutableStateDef copyOf(StateDef instance) {
        if (instance instanceof ImmutableStateDef) {
            return (ImmutableStateDef)instance;
        }
        return ImmutableStateDef.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="StateDef", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_WORKFLOW_STATE = 1L;
        private static final long INIT_BIT_CAN_START_WORKFLOW = 2L;
        private long initBits = 3L;
        @Nullable
        private WorkflowState workflowState;
        private boolean canStartWorkflow;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(StateDef instance) {
            Objects.requireNonNull(instance, "instance");
            this.workflowState(instance.getWorkflowState());
            this.canStartWorkflow(instance.getCanStartWorkflow());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder workflowState(WorkflowState workflowState) {
            this.workflowState = Objects.requireNonNull(workflowState, "workflowState");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder canStartWorkflow(boolean canStartWorkflow) {
            this.canStartWorkflow = canStartWorkflow;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableStateDef build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStateDef(this.workflowState, this.canStartWorkflow);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("workflowState");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("canStartWorkflow");
            }
            return "Cannot build StateDef, some of required attributes are not set " + attributes;
        }
    }
}

