/*
 * Decompiled with CFR 0.152.
 */
package io.iworkflow.core;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.iworkflow.core.StateMovement;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="StateMovement", generator="Immutables")
@Immutable
public final class ImmutableStateMovement
extends StateMovement {
    private final String stateId;
    @Nullable
    private final Object stateInput;

    private ImmutableStateMovement(String stateId, @Nullable Object stateInput) {
        this.stateId = stateId;
        this.stateInput = stateInput;
    }

    @Override
    public String getStateId() {
        return this.stateId;
    }

    @Override
    public Optional<Object> getStateInput() {
        return Optional.ofNullable(this.stateInput);
    }

    public final ImmutableStateMovement withStateId(String value) {
        String newValue = Objects.requireNonNull(value, "stateId");
        if (this.stateId.equals(newValue)) {
            return this;
        }
        return new ImmutableStateMovement(newValue, this.stateInput);
    }

    public final ImmutableStateMovement withStateInput(Object value) {
        Object newValue = Objects.requireNonNull(value, "stateInput");
        if (this.stateInput == newValue) {
            return this;
        }
        return new ImmutableStateMovement(this.stateId, newValue);
    }

    public final ImmutableStateMovement withStateInput(Optional<? extends Object> optional) {
        Object value = optional.orElse(null);
        if (this.stateInput == value) {
            return this;
        }
        return new ImmutableStateMovement(this.stateId, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStateMovement && this.equalTo(0, (ImmutableStateMovement)another);
    }

    private boolean equalTo(int synthetic, ImmutableStateMovement another) {
        return this.stateId.equals(another.stateId) && Objects.equals(this.stateInput, another.stateInput);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.stateId.hashCode();
        h += (h << 5) + Objects.hashCode(this.stateInput);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"StateMovement").omitNullValues().add("stateId", (Object)this.stateId).add("stateInput", this.stateInput).toString();
    }

    public static ImmutableStateMovement copyOf(StateMovement instance) {
        if (instance instanceof ImmutableStateMovement) {
            return (ImmutableStateMovement)instance;
        }
        return ImmutableStateMovement.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="StateMovement", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_STATE_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private String stateId;
        @Nullable
        private Object stateInput;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(StateMovement instance) {
            Objects.requireNonNull(instance, "instance");
            this.stateId(instance.getStateId());
            Optional<Object> stateInputOptional = instance.getStateInput();
            if (stateInputOptional.isPresent()) {
                this.stateInput(stateInputOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder stateId(String stateId) {
            this.stateId = Objects.requireNonNull(stateId, "stateId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder stateInput(Object stateInput) {
            this.stateInput = Objects.requireNonNull(stateInput, "stateInput");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder stateInput(Optional<? extends Object> stateInput) {
            this.stateInput = stateInput.orElse(null);
            return this;
        }

        public ImmutableStateMovement build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStateMovement(this.stateId, this.stateInput);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("stateId");
            }
            return "Cannot build StateMovement, some of required attributes are not set " + attributes;
        }
    }
}

