/*
 * Decompiled with CFR 0.152.
 */
package io.iworkflow.core;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.iworkflow.core.StopWorkflowOptions;
import io.iworkflow.gen.models.WorkflowStopType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="StopWorkflowOptions", generator="Immutables")
@Immutable
public final class ImmutableStopWorkflowOptions
extends StopWorkflowOptions {
    @Nullable
    private final WorkflowStopType workflowStopType;
    @Nullable
    private final String reason;

    private ImmutableStopWorkflowOptions(@Nullable WorkflowStopType workflowStopType, @Nullable String reason) {
        this.workflowStopType = workflowStopType;
        this.reason = reason;
    }

    @Override
    public Optional<WorkflowStopType> getWorkflowStopType() {
        return Optional.ofNullable(this.workflowStopType);
    }

    @Override
    public Optional<String> getReason() {
        return Optional.ofNullable(this.reason);
    }

    public final ImmutableStopWorkflowOptions withWorkflowStopType(WorkflowStopType value) {
        WorkflowStopType newValue = Objects.requireNonNull(value, "workflowStopType");
        if (this.workflowStopType == newValue) {
            return this;
        }
        return new ImmutableStopWorkflowOptions(newValue, this.reason);
    }

    public final ImmutableStopWorkflowOptions withWorkflowStopType(Optional<? extends WorkflowStopType> optional) {
        WorkflowStopType value = optional.orElse(null);
        if (this.workflowStopType == value) {
            return this;
        }
        return new ImmutableStopWorkflowOptions(value, this.reason);
    }

    public final ImmutableStopWorkflowOptions withReason(String value) {
        String newValue = Objects.requireNonNull(value, "reason");
        if (Objects.equals(this.reason, newValue)) {
            return this;
        }
        return new ImmutableStopWorkflowOptions(this.workflowStopType, newValue);
    }

    public final ImmutableStopWorkflowOptions withReason(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.reason, value)) {
            return this;
        }
        return new ImmutableStopWorkflowOptions(this.workflowStopType, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStopWorkflowOptions && this.equalTo(0, (ImmutableStopWorkflowOptions)another);
    }

    private boolean equalTo(int synthetic, ImmutableStopWorkflowOptions another) {
        return Objects.equals((Object)this.workflowStopType, (Object)another.workflowStopType) && Objects.equals(this.reason, another.reason);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode((Object)this.workflowStopType);
        h += (h << 5) + Objects.hashCode(this.reason);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"StopWorkflowOptions").omitNullValues().add("workflowStopType", (Object)this.workflowStopType).add("reason", (Object)this.reason).toString();
    }

    public static ImmutableStopWorkflowOptions copyOf(StopWorkflowOptions instance) {
        if (instance instanceof ImmutableStopWorkflowOptions) {
            return (ImmutableStopWorkflowOptions)instance;
        }
        return ImmutableStopWorkflowOptions.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="StopWorkflowOptions", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private WorkflowStopType workflowStopType;
        @Nullable
        private String reason;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(StopWorkflowOptions instance) {
            Optional<String> reasonOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<WorkflowStopType> workflowStopTypeOptional = instance.getWorkflowStopType();
            if (workflowStopTypeOptional.isPresent()) {
                this.workflowStopType(workflowStopTypeOptional);
            }
            if ((reasonOptional = instance.getReason()).isPresent()) {
                this.reason(reasonOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder workflowStopType(WorkflowStopType workflowStopType) {
            this.workflowStopType = Objects.requireNonNull(workflowStopType, "workflowStopType");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder workflowStopType(Optional<? extends WorkflowStopType> workflowStopType) {
            this.workflowStopType = workflowStopType.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder reason(String reason) {
            this.reason = Objects.requireNonNull(reason, "reason");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder reason(Optional<String> reason) {
            this.reason = reason.orElse(null);
            return this;
        }

        public ImmutableStopWorkflowOptions build() {
            return new ImmutableStopWorkflowOptions(this.workflowStopType, this.reason);
        }
    }
}

