/*
 * Decompiled with CFR 0.152.
 */
package io.iworkflow.core;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.iworkflow.core.UnregisteredWorkflowOptions;
import io.iworkflow.gen.models.IDReusePolicy;
import io.iworkflow.gen.models.SearchAttribute;
import io.iworkflow.gen.models.WorkflowConfig;
import io.iworkflow.gen.models.WorkflowRetryPolicy;
import io.iworkflow.gen.models.WorkflowStateOptions;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="UnregisteredWorkflowOptions", generator="Immutables")
@Immutable
public final class ImmutableUnregisteredWorkflowOptions
extends UnregisteredWorkflowOptions {
    @Nullable
    private final IDReusePolicy workflowIdReusePolicy;
    @Nullable
    private final String cronSchedule;
    @Nullable
    private final WorkflowRetryPolicy workflowRetryPolicy;
    @Nullable
    private final WorkflowStateOptions startStateOptions;
    private final ImmutableList<SearchAttribute> initialSearchAttribute;
    @Nullable
    private final WorkflowConfig workflowConfigOverride;

    private ImmutableUnregisteredWorkflowOptions(@Nullable IDReusePolicy workflowIdReusePolicy, @Nullable String cronSchedule, @Nullable WorkflowRetryPolicy workflowRetryPolicy, @Nullable WorkflowStateOptions startStateOptions, ImmutableList<SearchAttribute> initialSearchAttribute, @Nullable WorkflowConfig workflowConfigOverride) {
        this.workflowIdReusePolicy = workflowIdReusePolicy;
        this.cronSchedule = cronSchedule;
        this.workflowRetryPolicy = workflowRetryPolicy;
        this.startStateOptions = startStateOptions;
        this.initialSearchAttribute = initialSearchAttribute;
        this.workflowConfigOverride = workflowConfigOverride;
    }

    @Override
    public Optional<IDReusePolicy> getWorkflowIdReusePolicy() {
        return Optional.ofNullable(this.workflowIdReusePolicy);
    }

    @Override
    public Optional<String> getCronSchedule() {
        return Optional.ofNullable(this.cronSchedule);
    }

    @Override
    public Optional<WorkflowRetryPolicy> getWorkflowRetryPolicy() {
        return Optional.ofNullable(this.workflowRetryPolicy);
    }

    @Override
    public Optional<WorkflowStateOptions> getStartStateOptions() {
        return Optional.ofNullable(this.startStateOptions);
    }

    public ImmutableList<SearchAttribute> getInitialSearchAttribute() {
        return this.initialSearchAttribute;
    }

    @Override
    public Optional<WorkflowConfig> getWorkflowConfigOverride() {
        return Optional.ofNullable(this.workflowConfigOverride);
    }

    public final ImmutableUnregisteredWorkflowOptions withWorkflowIdReusePolicy(IDReusePolicy value) {
        IDReusePolicy newValue = Objects.requireNonNull(value, "workflowIdReusePolicy");
        if (this.workflowIdReusePolicy == newValue) {
            return this;
        }
        return new ImmutableUnregisteredWorkflowOptions(newValue, this.cronSchedule, this.workflowRetryPolicy, this.startStateOptions, this.initialSearchAttribute, this.workflowConfigOverride);
    }

    public final ImmutableUnregisteredWorkflowOptions withWorkflowIdReusePolicy(Optional<? extends IDReusePolicy> optional) {
        IDReusePolicy value = optional.orElse(null);
        if (this.workflowIdReusePolicy == value) {
            return this;
        }
        return new ImmutableUnregisteredWorkflowOptions(value, this.cronSchedule, this.workflowRetryPolicy, this.startStateOptions, this.initialSearchAttribute, this.workflowConfigOverride);
    }

    public final ImmutableUnregisteredWorkflowOptions withCronSchedule(String value) {
        String newValue = Objects.requireNonNull(value, "cronSchedule");
        if (Objects.equals(this.cronSchedule, newValue)) {
            return this;
        }
        return new ImmutableUnregisteredWorkflowOptions(this.workflowIdReusePolicy, newValue, this.workflowRetryPolicy, this.startStateOptions, this.initialSearchAttribute, this.workflowConfigOverride);
    }

    public final ImmutableUnregisteredWorkflowOptions withCronSchedule(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.cronSchedule, value)) {
            return this;
        }
        return new ImmutableUnregisteredWorkflowOptions(this.workflowIdReusePolicy, value, this.workflowRetryPolicy, this.startStateOptions, this.initialSearchAttribute, this.workflowConfigOverride);
    }

    public final ImmutableUnregisteredWorkflowOptions withWorkflowRetryPolicy(WorkflowRetryPolicy value) {
        WorkflowRetryPolicy newValue = Objects.requireNonNull(value, "workflowRetryPolicy");
        if (this.workflowRetryPolicy == newValue) {
            return this;
        }
        return new ImmutableUnregisteredWorkflowOptions(this.workflowIdReusePolicy, this.cronSchedule, newValue, this.startStateOptions, this.initialSearchAttribute, this.workflowConfigOverride);
    }

    public final ImmutableUnregisteredWorkflowOptions withWorkflowRetryPolicy(Optional<? extends WorkflowRetryPolicy> optional) {
        WorkflowRetryPolicy value = optional.orElse(null);
        if (this.workflowRetryPolicy == value) {
            return this;
        }
        return new ImmutableUnregisteredWorkflowOptions(this.workflowIdReusePolicy, this.cronSchedule, value, this.startStateOptions, this.initialSearchAttribute, this.workflowConfigOverride);
    }

    public final ImmutableUnregisteredWorkflowOptions withStartStateOptions(WorkflowStateOptions value) {
        WorkflowStateOptions newValue = Objects.requireNonNull(value, "startStateOptions");
        if (this.startStateOptions == newValue) {
            return this;
        }
        return new ImmutableUnregisteredWorkflowOptions(this.workflowIdReusePolicy, this.cronSchedule, this.workflowRetryPolicy, newValue, this.initialSearchAttribute, this.workflowConfigOverride);
    }

    public final ImmutableUnregisteredWorkflowOptions withStartStateOptions(Optional<? extends WorkflowStateOptions> optional) {
        WorkflowStateOptions value = optional.orElse(null);
        if (this.startStateOptions == value) {
            return this;
        }
        return new ImmutableUnregisteredWorkflowOptions(this.workflowIdReusePolicy, this.cronSchedule, this.workflowRetryPolicy, value, this.initialSearchAttribute, this.workflowConfigOverride);
    }

    public final ImmutableUnregisteredWorkflowOptions withInitialSearchAttribute(SearchAttribute ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableUnregisteredWorkflowOptions(this.workflowIdReusePolicy, this.cronSchedule, this.workflowRetryPolicy, this.startStateOptions, (ImmutableList<SearchAttribute>)newValue, this.workflowConfigOverride);
    }

    public final ImmutableUnregisteredWorkflowOptions withInitialSearchAttribute(Iterable<? extends SearchAttribute> elements) {
        if (this.initialSearchAttribute == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableUnregisteredWorkflowOptions(this.workflowIdReusePolicy, this.cronSchedule, this.workflowRetryPolicy, this.startStateOptions, (ImmutableList<SearchAttribute>)newValue, this.workflowConfigOverride);
    }

    public final ImmutableUnregisteredWorkflowOptions withWorkflowConfigOverride(WorkflowConfig value) {
        WorkflowConfig newValue = Objects.requireNonNull(value, "workflowConfigOverride");
        if (this.workflowConfigOverride == newValue) {
            return this;
        }
        return new ImmutableUnregisteredWorkflowOptions(this.workflowIdReusePolicy, this.cronSchedule, this.workflowRetryPolicy, this.startStateOptions, this.initialSearchAttribute, newValue);
    }

    public final ImmutableUnregisteredWorkflowOptions withWorkflowConfigOverride(Optional<? extends WorkflowConfig> optional) {
        WorkflowConfig value = optional.orElse(null);
        if (this.workflowConfigOverride == value) {
            return this;
        }
        return new ImmutableUnregisteredWorkflowOptions(this.workflowIdReusePolicy, this.cronSchedule, this.workflowRetryPolicy, this.startStateOptions, this.initialSearchAttribute, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUnregisteredWorkflowOptions && this.equalTo(0, (ImmutableUnregisteredWorkflowOptions)another);
    }

    private boolean equalTo(int synthetic, ImmutableUnregisteredWorkflowOptions another) {
        return Objects.equals((Object)this.workflowIdReusePolicy, (Object)another.workflowIdReusePolicy) && Objects.equals(this.cronSchedule, another.cronSchedule) && Objects.equals(this.workflowRetryPolicy, another.workflowRetryPolicy) && Objects.equals(this.startStateOptions, another.startStateOptions) && this.initialSearchAttribute.equals(another.initialSearchAttribute) && Objects.equals(this.workflowConfigOverride, another.workflowConfigOverride);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode((Object)this.workflowIdReusePolicy);
        h += (h << 5) + Objects.hashCode(this.cronSchedule);
        h += (h << 5) + Objects.hashCode(this.workflowRetryPolicy);
        h += (h << 5) + Objects.hashCode(this.startStateOptions);
        h += (h << 5) + this.initialSearchAttribute.hashCode();
        h += (h << 5) + Objects.hashCode(this.workflowConfigOverride);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"UnregisteredWorkflowOptions").omitNullValues().add("workflowIdReusePolicy", (Object)this.workflowIdReusePolicy).add("cronSchedule", (Object)this.cronSchedule).add("workflowRetryPolicy", (Object)this.workflowRetryPolicy).add("startStateOptions", (Object)this.startStateOptions).add("initialSearchAttribute", this.initialSearchAttribute).add("workflowConfigOverride", (Object)this.workflowConfigOverride).toString();
    }

    public static ImmutableUnregisteredWorkflowOptions copyOf(UnregisteredWorkflowOptions instance) {
        if (instance instanceof ImmutableUnregisteredWorkflowOptions) {
            return (ImmutableUnregisteredWorkflowOptions)instance;
        }
        return ImmutableUnregisteredWorkflowOptions.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="UnregisteredWorkflowOptions", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private IDReusePolicy workflowIdReusePolicy;
        @Nullable
        private String cronSchedule;
        @Nullable
        private WorkflowRetryPolicy workflowRetryPolicy;
        @Nullable
        private WorkflowStateOptions startStateOptions;
        private ImmutableList.Builder<SearchAttribute> initialSearchAttribute = ImmutableList.builder();
        @Nullable
        private WorkflowConfig workflowConfigOverride;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(UnregisteredWorkflowOptions instance) {
            Optional<WorkflowStateOptions> startStateOptionsOptional;
            Optional<WorkflowRetryPolicy> workflowRetryPolicyOptional;
            Optional<String> cronScheduleOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<IDReusePolicy> workflowIdReusePolicyOptional = instance.getWorkflowIdReusePolicy();
            if (workflowIdReusePolicyOptional.isPresent()) {
                this.workflowIdReusePolicy(workflowIdReusePolicyOptional);
            }
            if ((cronScheduleOptional = instance.getCronSchedule()).isPresent()) {
                this.cronSchedule(cronScheduleOptional);
            }
            if ((workflowRetryPolicyOptional = instance.getWorkflowRetryPolicy()).isPresent()) {
                this.workflowRetryPolicy(workflowRetryPolicyOptional);
            }
            if ((startStateOptionsOptional = instance.getStartStateOptions()).isPresent()) {
                this.startStateOptions(startStateOptionsOptional);
            }
            this.addAllInitialSearchAttribute(instance.getInitialSearchAttribute());
            Optional<WorkflowConfig> workflowConfigOverrideOptional = instance.getWorkflowConfigOverride();
            if (workflowConfigOverrideOptional.isPresent()) {
                this.workflowConfigOverride(workflowConfigOverrideOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder workflowIdReusePolicy(IDReusePolicy workflowIdReusePolicy) {
            this.workflowIdReusePolicy = Objects.requireNonNull(workflowIdReusePolicy, "workflowIdReusePolicy");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder workflowIdReusePolicy(Optional<? extends IDReusePolicy> workflowIdReusePolicy) {
            this.workflowIdReusePolicy = workflowIdReusePolicy.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder cronSchedule(String cronSchedule) {
            this.cronSchedule = Objects.requireNonNull(cronSchedule, "cronSchedule");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder cronSchedule(Optional<String> cronSchedule) {
            this.cronSchedule = cronSchedule.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder workflowRetryPolicy(WorkflowRetryPolicy workflowRetryPolicy) {
            this.workflowRetryPolicy = Objects.requireNonNull(workflowRetryPolicy, "workflowRetryPolicy");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder workflowRetryPolicy(Optional<? extends WorkflowRetryPolicy> workflowRetryPolicy) {
            this.workflowRetryPolicy = workflowRetryPolicy.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder startStateOptions(WorkflowStateOptions startStateOptions) {
            this.startStateOptions = Objects.requireNonNull(startStateOptions, "startStateOptions");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder startStateOptions(Optional<? extends WorkflowStateOptions> startStateOptions) {
            this.startStateOptions = startStateOptions.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addInitialSearchAttribute(SearchAttribute element) {
            this.initialSearchAttribute.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addInitialSearchAttribute(SearchAttribute ... elements) {
            this.initialSearchAttribute.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder initialSearchAttribute(Iterable<? extends SearchAttribute> elements) {
            this.initialSearchAttribute = ImmutableList.builder();
            return this.addAllInitialSearchAttribute(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllInitialSearchAttribute(Iterable<? extends SearchAttribute> elements) {
            this.initialSearchAttribute.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder workflowConfigOverride(WorkflowConfig workflowConfigOverride) {
            this.workflowConfigOverride = Objects.requireNonNull(workflowConfigOverride, "workflowConfigOverride");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder workflowConfigOverride(Optional<? extends WorkflowConfig> workflowConfigOverride) {
            this.workflowConfigOverride = workflowConfigOverride.orElse(null);
            return this;
        }

        public ImmutableUnregisteredWorkflowOptions build() {
            return new ImmutableUnregisteredWorkflowOptions(this.workflowIdReusePolicy, this.cronSchedule, this.workflowRetryPolicy, this.startStateOptions, this.initialSearchAttribute.build(), this.workflowConfigOverride);
        }
    }
}

