/*
 * Decompiled with CFR 0.152.
 */
package io.iworkflow.core;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.iworkflow.core.WorkflowOptions;
import io.iworkflow.gen.models.IDReusePolicy;
import io.iworkflow.gen.models.WorkflowConfig;
import io.iworkflow.gen.models.WorkflowRetryPolicy;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="WorkflowOptions", generator="Immutables")
@Immutable
public final class ImmutableWorkflowOptions
extends WorkflowOptions {
    @Nullable
    private final IDReusePolicy workflowIdReusePolicy;
    @Nullable
    private final String cronSchedule;
    @Nullable
    private final WorkflowRetryPolicy workflowRetryPolicy;
    private final ImmutableMap<String, Object> initialSearchAttribute;
    @Nullable
    private final WorkflowConfig workflowConfigOverride;

    private ImmutableWorkflowOptions(@Nullable IDReusePolicy workflowIdReusePolicy, @Nullable String cronSchedule, @Nullable WorkflowRetryPolicy workflowRetryPolicy, ImmutableMap<String, Object> initialSearchAttribute, @Nullable WorkflowConfig workflowConfigOverride) {
        this.workflowIdReusePolicy = workflowIdReusePolicy;
        this.cronSchedule = cronSchedule;
        this.workflowRetryPolicy = workflowRetryPolicy;
        this.initialSearchAttribute = initialSearchAttribute;
        this.workflowConfigOverride = workflowConfigOverride;
    }

    @Override
    public Optional<IDReusePolicy> getWorkflowIdReusePolicy() {
        return Optional.ofNullable(this.workflowIdReusePolicy);
    }

    @Override
    public Optional<String> getCronSchedule() {
        return Optional.ofNullable(this.cronSchedule);
    }

    @Override
    public Optional<WorkflowRetryPolicy> getWorkflowRetryPolicy() {
        return Optional.ofNullable(this.workflowRetryPolicy);
    }

    public ImmutableMap<String, Object> getInitialSearchAttribute() {
        return this.initialSearchAttribute;
    }

    @Override
    public Optional<WorkflowConfig> getWorkflowConfigOverride() {
        return Optional.ofNullable(this.workflowConfigOverride);
    }

    public final ImmutableWorkflowOptions withWorkflowIdReusePolicy(IDReusePolicy value) {
        IDReusePolicy newValue = Objects.requireNonNull(value, "workflowIdReusePolicy");
        if (this.workflowIdReusePolicy == newValue) {
            return this;
        }
        return new ImmutableWorkflowOptions(newValue, this.cronSchedule, this.workflowRetryPolicy, this.initialSearchAttribute, this.workflowConfigOverride);
    }

    public final ImmutableWorkflowOptions withWorkflowIdReusePolicy(Optional<? extends IDReusePolicy> optional) {
        IDReusePolicy value = optional.orElse(null);
        if (this.workflowIdReusePolicy == value) {
            return this;
        }
        return new ImmutableWorkflowOptions(value, this.cronSchedule, this.workflowRetryPolicy, this.initialSearchAttribute, this.workflowConfigOverride);
    }

    public final ImmutableWorkflowOptions withCronSchedule(String value) {
        String newValue = Objects.requireNonNull(value, "cronSchedule");
        if (Objects.equals(this.cronSchedule, newValue)) {
            return this;
        }
        return new ImmutableWorkflowOptions(this.workflowIdReusePolicy, newValue, this.workflowRetryPolicy, this.initialSearchAttribute, this.workflowConfigOverride);
    }

    public final ImmutableWorkflowOptions withCronSchedule(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.cronSchedule, value)) {
            return this;
        }
        return new ImmutableWorkflowOptions(this.workflowIdReusePolicy, value, this.workflowRetryPolicy, this.initialSearchAttribute, this.workflowConfigOverride);
    }

    public final ImmutableWorkflowOptions withWorkflowRetryPolicy(WorkflowRetryPolicy value) {
        WorkflowRetryPolicy newValue = Objects.requireNonNull(value, "workflowRetryPolicy");
        if (this.workflowRetryPolicy == newValue) {
            return this;
        }
        return new ImmutableWorkflowOptions(this.workflowIdReusePolicy, this.cronSchedule, newValue, this.initialSearchAttribute, this.workflowConfigOverride);
    }

    public final ImmutableWorkflowOptions withWorkflowRetryPolicy(Optional<? extends WorkflowRetryPolicy> optional) {
        WorkflowRetryPolicy value = optional.orElse(null);
        if (this.workflowRetryPolicy == value) {
            return this;
        }
        return new ImmutableWorkflowOptions(this.workflowIdReusePolicy, this.cronSchedule, value, this.initialSearchAttribute, this.workflowConfigOverride);
    }

    public final ImmutableWorkflowOptions withInitialSearchAttribute(Map<String, ? extends Object> entries) {
        if (this.initialSearchAttribute == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableWorkflowOptions(this.workflowIdReusePolicy, this.cronSchedule, this.workflowRetryPolicy, (ImmutableMap<String, Object>)newValue, this.workflowConfigOverride);
    }

    public final ImmutableWorkflowOptions withWorkflowConfigOverride(WorkflowConfig value) {
        WorkflowConfig newValue = Objects.requireNonNull(value, "workflowConfigOverride");
        if (this.workflowConfigOverride == newValue) {
            return this;
        }
        return new ImmutableWorkflowOptions(this.workflowIdReusePolicy, this.cronSchedule, this.workflowRetryPolicy, this.initialSearchAttribute, newValue);
    }

    public final ImmutableWorkflowOptions withWorkflowConfigOverride(Optional<? extends WorkflowConfig> optional) {
        WorkflowConfig value = optional.orElse(null);
        if (this.workflowConfigOverride == value) {
            return this;
        }
        return new ImmutableWorkflowOptions(this.workflowIdReusePolicy, this.cronSchedule, this.workflowRetryPolicy, this.initialSearchAttribute, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableWorkflowOptions && this.equalTo(0, (ImmutableWorkflowOptions)another);
    }

    private boolean equalTo(int synthetic, ImmutableWorkflowOptions another) {
        return Objects.equals((Object)this.workflowIdReusePolicy, (Object)another.workflowIdReusePolicy) && Objects.equals(this.cronSchedule, another.cronSchedule) && Objects.equals(this.workflowRetryPolicy, another.workflowRetryPolicy) && this.initialSearchAttribute.equals(another.initialSearchAttribute) && Objects.equals(this.workflowConfigOverride, another.workflowConfigOverride);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode((Object)this.workflowIdReusePolicy);
        h += (h << 5) + Objects.hashCode(this.cronSchedule);
        h += (h << 5) + Objects.hashCode(this.workflowRetryPolicy);
        h += (h << 5) + this.initialSearchAttribute.hashCode();
        h += (h << 5) + Objects.hashCode(this.workflowConfigOverride);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"WorkflowOptions").omitNullValues().add("workflowIdReusePolicy", (Object)this.workflowIdReusePolicy).add("cronSchedule", (Object)this.cronSchedule).add("workflowRetryPolicy", (Object)this.workflowRetryPolicy).add("initialSearchAttribute", this.initialSearchAttribute).add("workflowConfigOverride", (Object)this.workflowConfigOverride).toString();
    }

    public static ImmutableWorkflowOptions copyOf(WorkflowOptions instance) {
        if (instance instanceof ImmutableWorkflowOptions) {
            return (ImmutableWorkflowOptions)instance;
        }
        return ImmutableWorkflowOptions.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="WorkflowOptions", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private IDReusePolicy workflowIdReusePolicy;
        @Nullable
        private String cronSchedule;
        @Nullable
        private WorkflowRetryPolicy workflowRetryPolicy;
        private ImmutableMap.Builder<String, Object> initialSearchAttribute = ImmutableMap.builder();
        @Nullable
        private WorkflowConfig workflowConfigOverride;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(WorkflowOptions instance) {
            Optional<WorkflowRetryPolicy> workflowRetryPolicyOptional;
            Optional<String> cronScheduleOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<IDReusePolicy> workflowIdReusePolicyOptional = instance.getWorkflowIdReusePolicy();
            if (workflowIdReusePolicyOptional.isPresent()) {
                this.workflowIdReusePolicy(workflowIdReusePolicyOptional);
            }
            if ((cronScheduleOptional = instance.getCronSchedule()).isPresent()) {
                this.cronSchedule(cronScheduleOptional);
            }
            if ((workflowRetryPolicyOptional = instance.getWorkflowRetryPolicy()).isPresent()) {
                this.workflowRetryPolicy(workflowRetryPolicyOptional);
            }
            this.putAllInitialSearchAttribute(instance.getInitialSearchAttribute());
            Optional<WorkflowConfig> workflowConfigOverrideOptional = instance.getWorkflowConfigOverride();
            if (workflowConfigOverrideOptional.isPresent()) {
                this.workflowConfigOverride(workflowConfigOverrideOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder workflowIdReusePolicy(IDReusePolicy workflowIdReusePolicy) {
            this.workflowIdReusePolicy = Objects.requireNonNull(workflowIdReusePolicy, "workflowIdReusePolicy");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder workflowIdReusePolicy(Optional<? extends IDReusePolicy> workflowIdReusePolicy) {
            this.workflowIdReusePolicy = workflowIdReusePolicy.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder cronSchedule(String cronSchedule) {
            this.cronSchedule = Objects.requireNonNull(cronSchedule, "cronSchedule");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder cronSchedule(Optional<String> cronSchedule) {
            this.cronSchedule = cronSchedule.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder workflowRetryPolicy(WorkflowRetryPolicy workflowRetryPolicy) {
            this.workflowRetryPolicy = Objects.requireNonNull(workflowRetryPolicy, "workflowRetryPolicy");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder workflowRetryPolicy(Optional<? extends WorkflowRetryPolicy> workflowRetryPolicy) {
            this.workflowRetryPolicy = workflowRetryPolicy.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putInitialSearchAttribute(String key, Object value) {
            this.initialSearchAttribute.put((Object)key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putInitialSearchAttribute(Map.Entry<String, ? extends Object> entry) {
            this.initialSearchAttribute.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder initialSearchAttribute(Map<String, ? extends Object> entries) {
            this.initialSearchAttribute = ImmutableMap.builder();
            return this.putAllInitialSearchAttribute(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllInitialSearchAttribute(Map<String, ? extends Object> entries) {
            this.initialSearchAttribute.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder workflowConfigOverride(WorkflowConfig workflowConfigOverride) {
            this.workflowConfigOverride = Objects.requireNonNull(workflowConfigOverride, "workflowConfigOverride");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder workflowConfigOverride(Optional<? extends WorkflowConfig> workflowConfigOverride) {
            this.workflowConfigOverride = workflowConfigOverride.orElse(null);
            return this;
        }

        public ImmutableWorkflowOptions build() {
            return new ImmutableWorkflowOptions(this.workflowIdReusePolicy, this.cronSchedule, this.workflowRetryPolicy, this.initialSearchAttribute.build(), this.workflowConfigOverride);
        }
    }
}

