/*
 * Decompiled with CFR 0.152.
 */
package io.iworkflow.core;

import feign.FeignException;
import io.iworkflow.core.ClientSideException;
import io.iworkflow.core.ObjectEncoder;
import io.iworkflow.core.ServerSideException;
import io.iworkflow.gen.models.EncodedObject;
import io.iworkflow.gen.models.ErrorResponse;
import io.iworkflow.gen.models.ErrorSubStatus;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Optional;

public abstract class IwfHttpException
extends RuntimeException {
    private final int statusCode;
    private ErrorResponse errorResponse;

    public IwfHttpException(ObjectEncoder objectEncoder, FeignException.FeignClientException exception) {
        super(exception);
        this.statusCode = exception.status();
        String decodeErrorMessage = "";
        Optional respBody = exception.responseBody();
        if (respBody.isPresent()) {
            String data = StandardCharsets.UTF_8.decode((ByteBuffer)respBody.get()).toString();
            try {
                this.errorResponse = objectEncoder.decode(new EncodedObject().data(data), ErrorResponse.class);
                return;
            }
            catch (Exception e) {
                decodeErrorMessage = e.getMessage();
            }
        }
        this.errorResponse = new ErrorResponse().detail("empty or unable to decode to ErrorResponse:" + decodeErrorMessage).subStatus(ErrorSubStatus.UNCATEGORIZED_SUB_STATUS);
    }

    public IwfHttpException() {
        this.statusCode = 500;
    }

    public String getErrorDetails() {
        return this.errorResponse.getDetail();
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public ErrorSubStatus getErrorSubStatus() {
        return this.errorResponse.getSubStatus();
    }

    public static IwfHttpException fromFeignException(ObjectEncoder objectEncoder, FeignException.FeignClientException exception) {
        if (exception.status() >= 400 && exception.status() < 500) {
            return new ClientSideException(objectEncoder, exception);
        }
        return new ServerSideException(objectEncoder, exception);
    }
}

