/*
 * Decompiled with CFR 0.152.
 */
package io.iworkflow.core;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.iworkflow.core.ObjectEncoder;
import io.iworkflow.core.ObjectEncoderException;
import io.iworkflow.gen.models.EncodedObject;
import java.io.IOException;

public class JacksonJsonObjectEncoder
implements ObjectEncoder {
    private final ObjectMapper mapper;
    private final String encodingType;

    public JacksonJsonObjectEncoder() {
        this.mapper = new ObjectMapper();
        this.mapper.configure(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE, false);
        this.mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper.registerModule((Module)new JavaTimeModule());
        this.mapper.registerModule((Module)new Jdk8Module());
        this.mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        this.encodingType = "BuiltinJacksonJson";
    }

    public JacksonJsonObjectEncoder(ObjectMapper mapper, String encodingType) {
        this.mapper = mapper;
        this.encodingType = encodingType;
    }

    @Override
    public String getEncodingType() {
        return this.encodingType;
    }

    @Override
    public EncodedObject encode(Object object) {
        if (object == null) {
            return null;
        }
        try {
            String data = this.mapper.writeValueAsString(object);
            return new EncodedObject().encoding(this.getEncodingType()).data(data);
        }
        catch (JsonProcessingException e) {
            throw new ObjectEncoderException(e);
        }
    }

    @Override
    public <T> T decode(EncodedObject encodedObject, Class<T> type) {
        if (encodedObject == null) {
            return null;
        }
        String data = encodedObject.getData();
        if (data == null || data.isEmpty()) {
            return null;
        }
        try {
            JavaType reference = this.mapper.getTypeFactory().constructType(type, type);
            return (T)this.mapper.readValue(data, reference);
        }
        catch (IOException e) {
            throw new ObjectEncoderException(e);
        }
    }
}

