/*
 * Decompiled with CFR 0.152.
 */
package io.iworkflow.core;

import io.iworkflow.core.ObjectWorkflow;
import io.iworkflow.core.StateDef;
import io.iworkflow.core.WorkflowDefinitionException;
import io.iworkflow.core.communication.InterStateChannelDef;
import io.iworkflow.core.communication.SignalChannelDef;
import io.iworkflow.core.persistence.DataAttributeDef;
import io.iworkflow.core.persistence.PersistenceFieldDef;
import io.iworkflow.core.persistence.SearchAttributeDef;
import io.iworkflow.gen.models.SearchAttributeValueType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class Registry {
    private final Map<String, ObjectWorkflow> workflowStore = new HashMap<String, ObjectWorkflow>();
    private final Map<String, StateDef> workflowStateStore = new HashMap<String, StateDef>();
    private final Map<String, StateDef> workflowStartStateStore = new HashMap<String, StateDef>();
    private final Map<String, Map<String, Class<?>>> signalTypeStore = new HashMap();
    private final Map<String, Map<String, Class<?>>> interstateChannelTypeStore = new HashMap();
    private final Map<String, Map<String, Class<?>>> dataAttributeTypeStore = new HashMap();
    private final Map<String, Map<String, SearchAttributeValueType>> searchAttributeTypeStore = new HashMap<String, Map<String, SearchAttributeValueType>>();
    private static final String DELIMITER = "_";

    public void addWorkflows(ObjectWorkflow ... wfs) {
        Arrays.stream(wfs).forEach(this::addWorkflow);
    }

    public void addWorkflows(List<ObjectWorkflow> wfs) {
        wfs.forEach(this::addWorkflow);
    }

    public void addWorkflow(ObjectWorkflow wf) {
        this.registerWorkflow(wf);
        this.registerWorkflowState(wf);
        this.registerWorkflowSignal(wf);
        this.registerWorkflowInterstateChannel(wf);
        this.registerWorkflowDataAttributes(wf);
        this.registerWorkflowSearchAttributes(wf);
    }

    public static String getWorkflowType(ObjectWorkflow wf) {
        if (wf.getWorkflowType().isEmpty()) {
            return wf.getClass().getSimpleName();
        }
        return wf.getWorkflowType();
    }

    private void registerWorkflow(ObjectWorkflow wf) {
        String workflowType = Registry.getWorkflowType(wf);
        if (this.workflowStore.containsKey(workflowType)) {
            throw new WorkflowDefinitionException(String.format("Workflow type %s already exists", workflowType));
        }
        this.workflowStore.put(workflowType, wf);
    }

    private void registerWorkflowState(ObjectWorkflow wf) {
        String workflowType = Registry.getWorkflowType(wf);
        if (wf.getWorkflowStates() == null || wf.getWorkflowStates().size() == 0) {
            throw new WorkflowDefinitionException(String.format("Workflow type %s must contain at least one state", workflowType));
        }
        int startingStates = 0;
        StateDef startState = null;
        for (StateDef stateDef : wf.getWorkflowStates()) {
            String key = this.getStateDefKey(workflowType, stateDef.getWorkflowState().getStateId());
            if (this.workflowStateStore.containsKey(key)) {
                throw new WorkflowDefinitionException(String.format("Workflow state definition %s already exists", key));
            }
            this.workflowStateStore.put(key, stateDef);
            if (!stateDef.getCanStartWorkflow()) continue;
            ++startingStates;
            startState = stateDef;
        }
        if (startingStates != 1) {
            throw new WorkflowDefinitionException(String.format("Workflow must contain exactly one starting states, found %d", startingStates));
        }
        this.workflowStartStateStore.put(workflowType, startState);
    }

    private void registerWorkflowSignal(ObjectWorkflow wf) {
        String workflowType = Registry.getWorkflowType(wf);
        List<SignalChannelDef> channels = this.getSignalChannels(wf);
        if (channels == null || channels.isEmpty()) {
            this.signalTypeStore.put(workflowType, new HashMap());
            return;
        }
        for (SignalChannelDef signalChannelDef : channels) {
            Map signalNameToTypeMap = this.signalTypeStore.computeIfAbsent(workflowType, s -> new HashMap());
            if (signalNameToTypeMap.containsKey(signalChannelDef.getSignalChannelName())) {
                throw new WorkflowDefinitionException(String.format("Signal channel name  %s already exists", signalChannelDef.getSignalChannelName()));
            }
            signalNameToTypeMap.put(signalChannelDef.getSignalChannelName(), signalChannelDef.getSignalValueType());
        }
    }

    private void registerWorkflowInterstateChannel(ObjectWorkflow wf) {
        String workflowType = Registry.getWorkflowType(wf);
        List<InterStateChannelDef> channels = this.getInterStateChannels(wf);
        if (channels == null || channels.isEmpty()) {
            this.interstateChannelTypeStore.put(workflowType, new HashMap());
            return;
        }
        for (InterStateChannelDef interstateChannelDef : channels) {
            Map nameToTypeMap = this.interstateChannelTypeStore.computeIfAbsent(workflowType, s -> new HashMap());
            if (nameToTypeMap.containsKey(interstateChannelDef.getChannelName())) {
                throw new WorkflowDefinitionException(String.format("InterStateChannel name  %s already exists", interstateChannelDef.getChannelName()));
            }
            nameToTypeMap.put(interstateChannelDef.getChannelName(), interstateChannelDef.getValueType());
        }
    }

    private void registerWorkflowDataAttributes(ObjectWorkflow wf) {
        String workflowType = Registry.getWorkflowType(wf);
        List<DataAttributeDef> fields = this.getDataAttributeFields(wf);
        if (fields == null || fields.isEmpty()) {
            this.dataAttributeTypeStore.put(workflowType, new HashMap());
            return;
        }
        for (DataAttributeDef dataAttributeField : fields) {
            Map dataAttributeKeyToTypeMap = this.dataAttributeTypeStore.computeIfAbsent(workflowType, s -> new HashMap());
            if (dataAttributeKeyToTypeMap.containsKey(dataAttributeField.getKey())) {
                throw new WorkflowDefinitionException(String.format("data attribute key %s already exists", dataAttributeField.getDataAttributeType()));
            }
            dataAttributeKeyToTypeMap.put(dataAttributeField.getKey(), dataAttributeField.getDataAttributeType());
        }
    }

    private List<DataAttributeDef> getDataAttributeFields(ObjectWorkflow wf) {
        Set keySet = wf.getPersistenceSchema().stream().map(PersistenceFieldDef::getKey).collect(Collectors.toSet());
        if (keySet.size() != wf.getPersistenceSchema().size()) {
            throw new WorkflowDefinitionException("cannot have conflict key definition in persistence schema");
        }
        return wf.getPersistenceSchema().stream().filter(f -> f instanceof DataAttributeDef).map(f -> (DataAttributeDef)f).collect(Collectors.toList());
    }

    private List<SearchAttributeDef> getSearchAttributeFields(ObjectWorkflow wf) {
        Set keySet = wf.getPersistenceSchema().stream().map(PersistenceFieldDef::getKey).collect(Collectors.toSet());
        if (keySet.size() != wf.getPersistenceSchema().size()) {
            throw new WorkflowDefinitionException("cannot have conflict key definition in persistence schema");
        }
        return wf.getPersistenceSchema().stream().filter(f -> f instanceof SearchAttributeDef).map(f -> (SearchAttributeDef)f).collect(Collectors.toList());
    }

    private List<InterStateChannelDef> getInterStateChannels(ObjectWorkflow wf) {
        return wf.getCommunicationSchema().stream().filter(f -> f instanceof InterStateChannelDef).map(f -> (InterStateChannelDef)f).collect(Collectors.toList());
    }

    private List<SignalChannelDef> getSignalChannels(ObjectWorkflow wf) {
        return wf.getCommunicationSchema().stream().filter(f -> f instanceof SignalChannelDef).map(f -> (SignalChannelDef)f).collect(Collectors.toList());
    }

    private void registerWorkflowSearchAttributes(ObjectWorkflow wf) {
        String workflowType = Registry.getWorkflowType(wf);
        List<SearchAttributeDef> fields = this.getSearchAttributeFields(wf);
        if (fields == null || fields.isEmpty()) {
            this.searchAttributeTypeStore.put(workflowType, new HashMap());
            return;
        }
        for (SearchAttributeDef searchAttributeField : fields) {
            Map searchAttributeKeyToTypeMap = this.searchAttributeTypeStore.computeIfAbsent(workflowType, s -> new HashMap());
            if (searchAttributeKeyToTypeMap.containsKey(searchAttributeField.getKey())) {
                throw new WorkflowDefinitionException(String.format("Search attribute key %s already exists", searchAttributeField.getKey()));
            }
            searchAttributeKeyToTypeMap.put(searchAttributeField.getKey(), searchAttributeField.getSearchAttributeType());
        }
    }

    public ObjectWorkflow getWorkflow(String workflowType) {
        return this.workflowStore.get(workflowType);
    }

    public StateDef getWorkflowState(String workflowType, String stateId) {
        return this.workflowStateStore.get(this.getStateDefKey(workflowType, stateId));
    }

    public StateDef getWorkflowStartingState(String workflowType) {
        StateDef state = this.workflowStartStateStore.get(workflowType);
        if (state == null) {
            throw new WorkflowDefinitionException(String.format("workflow type %s is not registered, all registered types are: %s", workflowType, this.workflowStartStateStore.keySet()));
        }
        return state;
    }

    public Map<String, Class<?>> getSignalChannelNameToSignalTypeMap(String workflowType) {
        return this.signalTypeStore.get(workflowType);
    }

    public Map<String, Class<?>> getInterStateChannelNameToTypeMap(String workflowType) {
        return this.interstateChannelTypeStore.get(workflowType);
    }

    public Map<String, Class<?>> getDataAttributeKeyToTypeMap(String workflowType) {
        return this.dataAttributeTypeStore.get(workflowType);
    }

    public Map<String, SearchAttributeValueType> getSearchAttributeKeyToTypeMap(String workflowType) {
        return this.searchAttributeTypeStore.get(workflowType);
    }

    private String getStateDefKey(String workflowType, String stateId) {
        return workflowType + DELIMITER + stateId;
    }
}

