/*
 * Decompiled with CFR 0.152.
 */
package io.iworkflow.core;

import io.iworkflow.core.ImmutableResetWorkflowTypeAndOptions;
import io.iworkflow.gen.models.WorkflowResetType;
import java.util.Optional;
import org.immutables.value.Value;

@Value.Immutable
public abstract class ResetWorkflowTypeAndOptions {
    public abstract WorkflowResetType getResetType();

    public abstract Optional<Integer> getHistoryEventId();

    public abstract String getReason();

    public abstract Optional<String> getHistoryEventTime();

    public abstract Optional<String> getStateId();

    public abstract Optional<String> getStateExecutionId();

    public abstract Optional<Boolean> getSkipSignalReapply();

    public static ResetWorkflowTypeAndOptions resetToBeginning(String reason) {
        return ResetWorkflowTypeAndOptions.builder().resetType(WorkflowResetType.BEGINNING).reason(reason).build();
    }

    public static ResetWorkflowTypeAndOptions resetToHistoryEventId(int historyEventId, String reason) {
        return ResetWorkflowTypeAndOptions.builder().resetType(WorkflowResetType.HISTORY_EVENT_ID).historyEventId(historyEventId).reason(reason).build();
    }

    public static ResetWorkflowTypeAndOptions resetToHistoryEventId(String historyEventTime, String reason) {
        return ResetWorkflowTypeAndOptions.builder().resetType(WorkflowResetType.HISTORY_EVENT_ID).historyEventTime(historyEventTime).reason(reason).build();
    }

    public static ResetWorkflowTypeAndOptions resetToStateId(String stateId, String reason) {
        return ResetWorkflowTypeAndOptions.builder().resetType(WorkflowResetType.STATE_ID).stateId(stateId).reason(reason).build();
    }

    public static ResetWorkflowTypeAndOptions resetToStateExecutionId(String stateExecution, String reason) {
        return ResetWorkflowTypeAndOptions.builder().resetType(WorkflowResetType.STATE_EXECUTION_ID).stateExecutionId(stateExecution).reason(reason).build();
    }

    public static ImmutableResetWorkflowTypeAndOptions.Builder builder() {
        return ImmutableResetWorkflowTypeAndOptions.builder();
    }
}

