/*
 * Decompiled with CFR 0.152.
 */
package io.iworkflow.core;

import io.iworkflow.core.ImmutableStateDecision;
import io.iworkflow.core.StateMovement;
import io.iworkflow.core.WorkflowState;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.immutables.value.Value;

@Value.Immutable
public abstract class StateDecision {
    public static final StateDecision DEAD_END = ImmutableStateDecision.builder().build();
    public static final StateDecision FORCE_FAILING_WORKFLOW = ImmutableStateDecision.builder().nextStates(Arrays.asList(StateMovement.FORCE_FAILING_WORKFLOW_MOVEMENT)).build();

    public abstract List<StateMovement> getNextStates();

    public static ImmutableStateDecision.Builder builder() {
        return ImmutableStateDecision.builder();
    }

    public static StateDecision gracefulCompleteWorkflow(Object output) {
        return ImmutableStateDecision.builder().nextStates(Arrays.asList(StateMovement.gracefulCompleteWorkflow(output))).build();
    }

    public static StateDecision gracefulCompleteWorkflow() {
        return ImmutableStateDecision.builder().nextStates(Arrays.asList(StateMovement.gracefulCompleteWorkflow())).build();
    }

    public static StateDecision forceCompleteWorkflow(Object output) {
        return ImmutableStateDecision.builder().nextStates(Arrays.asList(StateMovement.forceCompleteWorkflow(output))).build();
    }

    public static StateDecision forceCompleteWorkflow() {
        return ImmutableStateDecision.builder().nextStates(Arrays.asList(StateMovement.forceCompleteWorkflow())).build();
    }

    public static StateDecision forceFailWorkflow(Object output) {
        return ImmutableStateDecision.builder().nextStates(Arrays.asList(StateMovement.forceFailWorkflow(output))).build();
    }

    public static StateDecision forceFailWorkflow() {
        return FORCE_FAILING_WORKFLOW;
    }

    public static StateDecision singleNextState(Class<? extends WorkflowState> stateClass) {
        return StateDecision.singleNextState(stateClass.getSimpleName());
    }

    public static StateDecision singleNextState(String stateId) {
        return ImmutableStateDecision.builder().nextStates(Arrays.asList(StateMovement.create(stateId))).build();
    }

    public static StateDecision singleNextState(Class<? extends WorkflowState> stateClass, Object stateInput) {
        return StateDecision.singleNextState(stateClass.getSimpleName(), stateInput);
    }

    public static StateDecision singleNextState(String stateId, Object stateInput) {
        return ImmutableStateDecision.builder().nextStates(Arrays.asList(StateMovement.create(stateId, stateInput))).build();
    }

    public static StateDecision multiNextStates(StateMovement ... stateMovements) {
        return ImmutableStateDecision.builder().nextStates(Arrays.asList(stateMovements)).build();
    }

    public static StateDecision multiNextStates(Class<? extends WorkflowState> ... states) {
        ArrayList stateIds = new ArrayList();
        Arrays.stream(states).forEach(s -> stateIds.add(s.getSimpleName()));
        return StateDecision.multiNextStates(stateIds.toArray(new String[0]));
    }

    public static StateDecision multiNextStates(String ... stateIds) {
        ArrayList stateMovements = new ArrayList();
        Arrays.stream(stateIds).forEach(id -> stateMovements.add(StateMovement.create(id)));
        return ImmutableStateDecision.builder().nextStates(stateMovements).build();
    }
}

