/*
 * Decompiled with CFR 0.152.
 */
package io.iworkflow.core;

import io.iworkflow.core.ImmutableStateMovement;
import io.iworkflow.core.WorkflowDefinitionException;
import io.iworkflow.core.WorkflowState;
import java.util.Optional;
import org.immutables.value.Value;

@Value.Immutable
public abstract class StateMovement {
    public static final String RESERVED_STATE_ID_PREFIX = "_SYS_";
    private static final String GRACEFUL_COMPLETING_WORKFLOW_STATE_ID = "_SYS_GRACEFUL_COMPLETING_WORKFLOW";
    private static final String FORCE_COMPLETING_WORKFLOW_STATE_ID = "_SYS_FORCE_COMPLETING_WORKFLOW";
    private static final String FORCE_FAILING_WORKFLOW_STATE_ID = "_SYS_FORCE_FAILING_WORKFLOW";
    public static final StateMovement FORCE_FAILING_WORKFLOW_MOVEMENT = ImmutableStateMovement.builder().stateId("_SYS_FORCE_FAILING_WORKFLOW").build();

    public abstract String getStateId();

    public abstract Optional<Object> getStateInput();

    public static StateMovement gracefulCompleteWorkflow() {
        return ImmutableStateMovement.builder().stateId(GRACEFUL_COMPLETING_WORKFLOW_STATE_ID).build();
    }

    public static StateMovement gracefulCompleteWorkflow(Object output) {
        return ImmutableStateMovement.builder().stateId(GRACEFUL_COMPLETING_WORKFLOW_STATE_ID).stateInput(output).build();
    }

    public static StateMovement forceCompleteWorkflow() {
        return ImmutableStateMovement.builder().stateId(FORCE_COMPLETING_WORKFLOW_STATE_ID).build();
    }

    public static StateMovement forceCompleteWorkflow(Object output) {
        return ImmutableStateMovement.builder().stateId(FORCE_COMPLETING_WORKFLOW_STATE_ID).stateInput(output).build();
    }

    public static StateMovement forceFailWorkflow(Object output) {
        return ImmutableStateMovement.builder().stateId(FORCE_FAILING_WORKFLOW_STATE_ID).stateInput(output).build();
    }

    public static StateMovement create(Class<? extends WorkflowState> stateClass, Object stateInput) {
        return StateMovement.create(stateClass.getSimpleName(), stateInput);
    }

    public static StateMovement create(String stateId, Object stateInput) {
        if (stateId.startsWith(RESERVED_STATE_ID_PREFIX)) {
            throw new WorkflowDefinitionException("Cannot use reserved stateId prefix for your stateId");
        }
        return ImmutableStateMovement.builder().stateId(stateId).stateInput(stateInput).build();
    }

    public static StateMovement create(Class<? extends WorkflowState> stateClass) {
        return StateMovement.create(stateClass.getSimpleName());
    }

    public static StateMovement create(String stateId) {
        if (stateId.startsWith(RESERVED_STATE_ID_PREFIX)) {
            throw new WorkflowDefinitionException("Cannot use reserved stateId prefix for your stateId");
        }
        return ImmutableStateMovement.builder().stateId(stateId).build();
    }
}

