/*
 * Decompiled with CFR 0.152.
 */
package io.iworkflow.core;

import com.google.common.base.Preconditions;
import feign.FeignException;
import io.iworkflow.core.Client;
import io.iworkflow.core.ClientOptions;
import io.iworkflow.core.IwfHttpException;
import io.iworkflow.core.ResetWorkflowTypeAndOptions;
import io.iworkflow.core.StopWorkflowOptions;
import io.iworkflow.core.UnregisteredWorkflowOptions;
import io.iworkflow.core.WorkflowUncompletedException;
import io.iworkflow.core.validator.CronScheduleValidator;
import io.iworkflow.gen.api.ApiClient;
import io.iworkflow.gen.api.DefaultApi;
import io.iworkflow.gen.models.SearchAttributeKeyAndType;
import io.iworkflow.gen.models.StateCompletionOutput;
import io.iworkflow.gen.models.WorkflowGetDataObjectsRequest;
import io.iworkflow.gen.models.WorkflowGetDataObjectsResponse;
import io.iworkflow.gen.models.WorkflowGetRequest;
import io.iworkflow.gen.models.WorkflowGetResponse;
import io.iworkflow.gen.models.WorkflowGetSearchAttributesRequest;
import io.iworkflow.gen.models.WorkflowGetSearchAttributesResponse;
import io.iworkflow.gen.models.WorkflowResetRequest;
import io.iworkflow.gen.models.WorkflowResetResponse;
import io.iworkflow.gen.models.WorkflowSearchRequest;
import io.iworkflow.gen.models.WorkflowSearchResponse;
import io.iworkflow.gen.models.WorkflowSignalRequest;
import io.iworkflow.gen.models.WorkflowSkipTimerRequest;
import io.iworkflow.gen.models.WorkflowStartOptions;
import io.iworkflow.gen.models.WorkflowStartRequest;
import io.iworkflow.gen.models.WorkflowStartResponse;
import io.iworkflow.gen.models.WorkflowStatus;
import io.iworkflow.gen.models.WorkflowStopRequest;
import java.util.List;

public class UnregisteredClient {
    private final DefaultApi defaultApi;
    private final ClientOptions clientOptions;

    public UnregisteredClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.defaultApi = new ApiClient().setBasePath(clientOptions.getServerUrl()).buildClient(DefaultApi.class);
    }

    public String startWorkflow(String workflowType, String startStateId, String workflowId, int workflowTimeoutSeconds) {
        return this.startWorkflow(workflowType, startStateId, workflowId, workflowTimeoutSeconds, null, null);
    }

    public String startWorkflow(String workflowType, String startStateId, String workflowId, int workflowTimeoutSeconds, Object input) {
        return this.startWorkflow(workflowType, startStateId, workflowId, workflowTimeoutSeconds, input, null);
    }

    public String startWorkflow(String workflowType, String startStateId, String workflowId, int workflowTimeoutSeconds, Object input, UnregisteredWorkflowOptions options) {
        WorkflowStartRequest request = new WorkflowStartRequest().workflowId(workflowId).iwfWorkerUrl(this.clientOptions.getWorkerUrl()).iwfWorkflowType(workflowType).workflowTimeoutSeconds(workflowTimeoutSeconds).stateInput(this.clientOptions.getObjectEncoder().encode(input)).startStateId(startStateId);
        if (options != null) {
            WorkflowStartOptions startOptions = new WorkflowStartOptions();
            if (options.getCronSchedule().isPresent()) {
                startOptions.cronSchedule(CronScheduleValidator.validate(options.getCronSchedule()));
            }
            if (options.getWorkflowIdReusePolicy().isPresent()) {
                startOptions.idReusePolicy(options.getWorkflowIdReusePolicy().get());
            }
            if (options.getWorkflowRetryPolicy().isPresent()) {
                startOptions.retryPolicy(options.getWorkflowRetryPolicy().get());
            }
            if (options.getWorkflowConfigOverride().isPresent()) {
                startOptions.workflowConfigOverride(options.getWorkflowConfigOverride().get());
            }
            if (options.getInitialSearchAttribute().size() > 0) {
                options.getInitialSearchAttribute().forEach(sa -> {
                    assert (sa.getValueType() != null);
                    Object val = Client.getSearchAttributeValue(sa.getValueType(), sa);
                    if (val == null) {
                        throw new IllegalArgumentException(String.format("search attribute value is not set correctly for key %s with value type %s", new Object[]{sa.getKey(), sa.getValueType()}));
                    }
                });
                startOptions.searchAttributes(options.getInitialSearchAttribute());
            }
            if (options.getStartStateOptions().isPresent()) {
                request.stateOptions(options.getStartStateOptions().get());
            }
            request.workflowStartOptions(startOptions);
        }
        try {
            WorkflowStartResponse workflowStartResponse = this.defaultApi.apiV1WorkflowStartPost(request);
            return workflowStartResponse.getWorkflowRunId();
        }
        catch (FeignException.FeignClientException exp) {
            throw IwfHttpException.fromFeignException(this.clientOptions.getObjectEncoder(), exp);
        }
    }

    public <T> T getSimpleWorkflowResultWithWait(Class<T> valueClass, String workflowId, String workflowRunId) {
        WorkflowGetResponse workflowGetResponse;
        try {
            workflowGetResponse = this.defaultApi.apiV1WorkflowGetWithWaitPost(new WorkflowGetRequest().needsResults(true).workflowId(workflowId).workflowRunId(workflowRunId));
        }
        catch (FeignException.FeignClientException exp) {
            throw IwfHttpException.fromFeignException(this.clientOptions.getObjectEncoder(), exp);
        }
        if (workflowGetResponse.getWorkflowStatus() != WorkflowStatus.COMPLETED) {
            this.throwUncompletedException(workflowGetResponse);
        }
        if (workflowGetResponse.getResults() == null || workflowGetResponse.getResults().size() == 0) {
            return null;
        }
        String checkErrorMessage = "this workflow should have one or zero state output for using this API";
        Preconditions.checkNotNull(workflowGetResponse.getResults(), (Object)checkErrorMessage);
        Preconditions.checkArgument((workflowGetResponse.getResults().size() == 1 ? 1 : 0) != 0, (Object)checkErrorMessage);
        StateCompletionOutput output = workflowGetResponse.getResults().get(0);
        return this.clientOptions.getObjectEncoder().decode(output.getCompletedStateOutput(), valueClass);
    }

    private void throwUncompletedException(WorkflowGetResponse workflowGetResponse) {
        throw new WorkflowUncompletedException(workflowGetResponse.getWorkflowRunId(), workflowGetResponse.getWorkflowStatus(), workflowGetResponse.getErrorType(), workflowGetResponse.getErrorMessage(), workflowGetResponse.getResults(), this.clientOptions.getObjectEncoder());
    }

    public <T> T getSimpleWorkflowResultWithWait(Class<T> valueClass, String workflowId) {
        return this.getSimpleWorkflowResultWithWait(valueClass, workflowId, "");
    }

    public List<StateCompletionOutput> getComplexWorkflowResultWithWait(String workflowId, String workflowRunId) {
        try {
            WorkflowGetResponse workflowGetResponse = this.defaultApi.apiV1WorkflowGetWithWaitPost(new WorkflowGetRequest().needsResults(true).workflowId(workflowId).workflowRunId(workflowRunId));
            if (workflowGetResponse.getWorkflowStatus() != WorkflowStatus.COMPLETED) {
                this.throwUncompletedException(workflowGetResponse);
            }
            return workflowGetResponse.getResults();
        }
        catch (FeignException.FeignClientException exp) {
            throw IwfHttpException.fromFeignException(this.clientOptions.getObjectEncoder(), exp);
        }
    }

    public void signalWorkflow(String workflowId, String workflowRunId, String signalChannelName, Object signalValue) {
        try {
            this.defaultApi.apiV1WorkflowSignalPost(new WorkflowSignalRequest().workflowId(workflowId).workflowRunId(workflowRunId).signalChannelName(signalChannelName).signalValue(this.clientOptions.getObjectEncoder().encode(signalValue)));
        }
        catch (FeignException.FeignClientException exp) {
            throw IwfHttpException.fromFeignException(this.clientOptions.getObjectEncoder(), exp);
        }
    }

    public String resetWorkflow(String workflowId, String workflowRunId, ResetWorkflowTypeAndOptions resetWorkflowTypeAndOptions) {
        WorkflowResetRequest request = new WorkflowResetRequest().workflowId(workflowId).workflowRunId(workflowRunId).resetType(resetWorkflowTypeAndOptions.getResetType()).reason(resetWorkflowTypeAndOptions.getReason());
        if (resetWorkflowTypeAndOptions.getHistoryEventId().isPresent()) {
            request.historyEventId(resetWorkflowTypeAndOptions.getHistoryEventId().get());
        }
        if (resetWorkflowTypeAndOptions.getHistoryEventTime().isPresent()) {
            request.historyEventTime(resetWorkflowTypeAndOptions.getHistoryEventTime().get());
        }
        if (resetWorkflowTypeAndOptions.getSkipSignalReapply().isPresent()) {
            request.skipSignalReapply(resetWorkflowTypeAndOptions.getSkipSignalReapply().get());
        }
        if (resetWorkflowTypeAndOptions.getStateId().isPresent()) {
            request.stateId(resetWorkflowTypeAndOptions.getStateId().get());
        }
        if (resetWorkflowTypeAndOptions.getStateExecutionId().isPresent()) {
            request.stateExecutionId(resetWorkflowTypeAndOptions.getStateExecutionId().get());
        }
        try {
            WorkflowResetResponse resp = this.defaultApi.apiV1WorkflowResetPost(request);
            return resp.getWorkflowRunId();
        }
        catch (FeignException.FeignClientException exp) {
            throw IwfHttpException.fromFeignException(this.clientOptions.getObjectEncoder(), exp);
        }
    }

    public void skipTimer(String workflowId, String workflowRunId, String workflowStateId, int stateExecutionNumber, String timerCommandId) {
        String stateExecutionId = String.format("%s-%s", workflowStateId, stateExecutionNumber);
        try {
            this.defaultApi.apiV1WorkflowTimerSkipPost(new WorkflowSkipTimerRequest().workflowId(workflowId).workflowRunId(workflowRunId).workflowStateExecutionId(stateExecutionId).timerCommandId(timerCommandId));
        }
        catch (FeignException.FeignClientException exp) {
            throw IwfHttpException.fromFeignException(this.clientOptions.getObjectEncoder(), exp);
        }
    }

    public void skipTimer(String workflowId, String workflowRunId, String workflowStateId, int stateExecutionNumber, int timerCommandIndex) {
        String stateExecutionId = String.format("%s-%s", workflowStateId, stateExecutionNumber);
        try {
            this.defaultApi.apiV1WorkflowTimerSkipPost(new WorkflowSkipTimerRequest().workflowId(workflowId).workflowRunId(workflowRunId).workflowStateExecutionId(stateExecutionId).timerCommandIndex(timerCommandIndex));
        }
        catch (FeignException.FeignClientException exp) {
            throw IwfHttpException.fromFeignException(this.clientOptions.getObjectEncoder(), exp);
        }
    }

    public void stopWorkflow(String workflowId, String workflowRunId) {
        this.stopWorkflow(workflowId, workflowRunId, null);
    }

    public void stopWorkflow(String workflowId, String workflowRunId, StopWorkflowOptions options) {
        try {
            WorkflowStopRequest request = new WorkflowStopRequest().workflowId(workflowId).workflowRunId(workflowRunId);
            if (options != null) {
                if (options.getWorkflowStopType().isPresent()) {
                    request.stopType(options.getWorkflowStopType().get());
                }
                if (options.getReason().isPresent()) {
                    request.reason(options.getReason().get());
                }
            }
            this.defaultApi.apiV1WorkflowStopPost(request);
        }
        catch (FeignException.FeignClientException exp) {
            throw IwfHttpException.fromFeignException(this.clientOptions.getObjectEncoder(), exp);
        }
    }

    public WorkflowGetDataObjectsResponse getAnyWorkflowDataObjects(String workflowId, String workflowRunId, List<String> attributeKeys) {
        try {
            return this.defaultApi.apiV1WorkflowDataobjectsGetPost(new WorkflowGetDataObjectsRequest().workflowId(workflowId).workflowRunId(workflowRunId).keys(attributeKeys));
        }
        catch (FeignException.FeignClientException exp) {
            throw IwfHttpException.fromFeignException(this.clientOptions.getObjectEncoder(), exp);
        }
    }

    public WorkflowSearchResponse searchWorkflow(String query, int pageSize) {
        try {
            return this.defaultApi.apiV1WorkflowSearchPost(new WorkflowSearchRequest().query(query).pageSize(pageSize));
        }
        catch (FeignException.FeignClientException exp) {
            throw IwfHttpException.fromFeignException(this.clientOptions.getObjectEncoder(), exp);
        }
    }

    public WorkflowSearchResponse searchWorkflow(WorkflowSearchRequest request) {
        try {
            return this.defaultApi.apiV1WorkflowSearchPost(request);
        }
        catch (FeignException.FeignClientException exp) {
            throw IwfHttpException.fromFeignException(this.clientOptions.getObjectEncoder(), exp);
        }
    }

    public WorkflowGetSearchAttributesResponse getAnyWorkflowSearchAttributes(String workflowId, String workflowRunId, List<SearchAttributeKeyAndType> attributeKeys) {
        try {
            return this.defaultApi.apiV1WorkflowSearchattributesGetPost(new WorkflowGetSearchAttributesRequest().workflowId(workflowId).workflowRunId(workflowRunId).keys(attributeKeys));
        }
        catch (FeignException.FeignClientException exp) {
            throw IwfHttpException.fromFeignException(this.clientOptions.getObjectEncoder(), exp);
        }
    }
}

