/*
 * Decompiled with CFR 0.152.
 */
package io.iworkflow.core;

import io.iworkflow.core.Context;
import io.iworkflow.core.ImmutableContext;
import io.iworkflow.core.Registry;
import io.iworkflow.core.StateDecision;
import io.iworkflow.core.StateDef;
import io.iworkflow.core.WorkerOptions;
import io.iworkflow.core.WorkflowDefinitionException;
import io.iworkflow.core.command.CommandRequest;
import io.iworkflow.core.communication.CommunicationImpl;
import io.iworkflow.core.communication.InterStateChannelCommand;
import io.iworkflow.core.mapper.CommandRequestMapper;
import io.iworkflow.core.mapper.CommandResultsMapper;
import io.iworkflow.core.mapper.StateDecisionMapper;
import io.iworkflow.core.persistence.DataAttributesRWImpl;
import io.iworkflow.core.persistence.PersistenceImpl;
import io.iworkflow.core.persistence.SearchAttributeRWImpl;
import io.iworkflow.core.persistence.StateExecutionLocalsImpl;
import io.iworkflow.gen.models.EncodedObject;
import io.iworkflow.gen.models.InterStateChannelPublishing;
import io.iworkflow.gen.models.KeyValue;
import io.iworkflow.gen.models.SearchAttribute;
import io.iworkflow.gen.models.SearchAttributeValueType;
import io.iworkflow.gen.models.WorkflowStateExecuteRequest;
import io.iworkflow.gen.models.WorkflowStateExecuteResponse;
import io.iworkflow.gen.models.WorkflowStateWaitUntilRequest;
import io.iworkflow.gen.models.WorkflowStateWaitUntilResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class WorkerService {
    public static final String WORKFLOW_STATE_START_API_PATH = "/api/v1/workflowState/start";
    public static final String WORKFLOW_STATE_DECIDE_API_PATH = "/api/v1/workflowState/decide";
    private final Registry registry;
    private final WorkerOptions workerOptions;

    public WorkerService(Registry registry, WorkerOptions workerOptions) {
        this.registry = registry;
        this.workerOptions = workerOptions;
    }

    public WorkflowStateWaitUntilResponse handleWorkflowStateStart(WorkflowStateWaitUntilRequest req) {
        List<InterStateChannelPublishing> interStateChannelPublishing;
        List<SearchAttribute> upsertSAs;
        StateDef state = this.registry.getWorkflowState(req.getWorkflowType(), req.getWorkflowStateId());
        EncodedObject stateInput = req.getStateInput();
        Object input = this.workerOptions.getObjectEncoder().decode(stateInput, state.getWorkflowState().getInputType());
        DataAttributesRWImpl dataObjectsRW = this.createDataObjectsRW(req.getWorkflowType(), req.getDataObjects());
        Context context = this.fromIdlContext(req.getContext());
        StateExecutionLocalsImpl stateExeLocals = new StateExecutionLocalsImpl(this.toMap(null), this.workerOptions.getObjectEncoder());
        Map<String, SearchAttributeValueType> saTypeMap = this.registry.getSearchAttributeKeyToTypeMap(req.getWorkflowType());
        SearchAttributeRWImpl searchAttributeRW = new SearchAttributeRWImpl(saTypeMap, req.getSearchAttributes());
        CommunicationImpl communication = new CommunicationImpl(this.registry.getInterStateChannelNameToTypeMap(req.getWorkflowType()), this.workerOptions.getObjectEncoder());
        PersistenceImpl persistence = new PersistenceImpl(dataObjectsRW, searchAttributeRW, stateExeLocals);
        CommandRequest commandRequest = state.getWorkflowState().waitUntil(context, input, persistence, communication);
        commandRequest.getCommands().forEach(cmd -> {
            if (cmd instanceof InterStateChannelCommand) {
                String name = ((InterStateChannelCommand)cmd).getChannelName();
                if (communication.getToPublishInterStateChannels().containsKey(name)) {
                    throw new WorkflowDefinitionException("it's not allowed to publish and wait for the same interstate channel - " + name);
                }
            }
        });
        WorkflowStateWaitUntilResponse response = new WorkflowStateWaitUntilResponse().commandRequest(CommandRequestMapper.toGenerated(commandRequest));
        if (dataObjectsRW.getToReturnToServer().size() > 0) {
            response.upsertDataObjects(dataObjectsRW.getToReturnToServer());
        }
        if (stateExeLocals.getUpsertStateExecutionLocalAttributes().size() > 0) {
            response.upsertStateLocals(stateExeLocals.getUpsertStateExecutionLocalAttributes());
        }
        if (stateExeLocals.getRecordEvents().size() > 0) {
            response.recordEvents(stateExeLocals.getRecordEvents());
        }
        if ((upsertSAs = this.createUpsertSearchAttributes(saTypeMap, searchAttributeRW.getUpsertToServerInt64AttributeMap(), searchAttributeRW.getUpsertToServerStringAttributeMap(), searchAttributeRW.getUpsertToServerBooleanAttributeMap(), searchAttributeRW.getUpsertToServerDoubleAttributeMap(), searchAttributeRW.getUpsertToServerStringArrayAttributeMap())).size() > 0) {
            response.upsertSearchAttributes(upsertSAs);
        }
        if ((interStateChannelPublishing = this.toInterStateChannelPublishing(communication.getToPublishInterStateChannels())).size() > 0) {
            response.publishToInterStateChannel(interStateChannelPublishing);
        }
        return response;
    }

    public WorkflowStateExecuteResponse handleWorkflowStateDecide(WorkflowStateExecuteRequest req) {
        List<InterStateChannelPublishing> interStateChannelPublishing;
        List<SearchAttribute> upsertSAs;
        StateDef state = this.registry.getWorkflowState(req.getWorkflowType(), req.getWorkflowStateId());
        EncodedObject stateInput = req.getStateInput();
        Object input = this.workerOptions.getObjectEncoder().decode(stateInput, state.getWorkflowState().getInputType());
        DataAttributesRWImpl dataObjectsRW = this.createDataObjectsRW(req.getWorkflowType(), req.getDataObjects());
        Context context = this.fromIdlContext(req.getContext());
        StateExecutionLocalsImpl stateExeLocals = new StateExecutionLocalsImpl(this.toMap(req.getStateLocals()), this.workerOptions.getObjectEncoder());
        Map<String, SearchAttributeValueType> saTypeMap = this.registry.getSearchAttributeKeyToTypeMap(req.getWorkflowType());
        SearchAttributeRWImpl searchAttributeRW = new SearchAttributeRWImpl(saTypeMap, req.getSearchAttributes());
        CommunicationImpl communication = new CommunicationImpl(this.registry.getInterStateChannelNameToTypeMap(req.getWorkflowType()), this.workerOptions.getObjectEncoder());
        PersistenceImpl persistence = new PersistenceImpl(dataObjectsRW, searchAttributeRW, stateExeLocals);
        StateDecision stateDecision = state.getWorkflowState().execute(context, input, CommandResultsMapper.fromGenerated(req.getCommandResults(), this.registry.getSignalChannelNameToSignalTypeMap(req.getWorkflowType()), this.registry.getInterStateChannelNameToTypeMap(req.getWorkflowType()), this.workerOptions.getObjectEncoder()), persistence, communication);
        WorkflowStateExecuteResponse response = new WorkflowStateExecuteResponse().stateDecision(StateDecisionMapper.toGenerated(stateDecision, req.getWorkflowType(), this.registry, this.workerOptions.getObjectEncoder()));
        if (dataObjectsRW.getToReturnToServer().size() > 0) {
            response.upsertDataObjects(dataObjectsRW.getToReturnToServer());
        }
        if (stateExeLocals.getUpsertStateExecutionLocalAttributes().size() > 0) {
            response.upsertStateLocals(stateExeLocals.getUpsertStateExecutionLocalAttributes());
        }
        if (stateExeLocals.getRecordEvents().size() > 0) {
            response.recordEvents(stateExeLocals.getRecordEvents());
        }
        if ((upsertSAs = this.createUpsertSearchAttributes(saTypeMap, searchAttributeRW.getUpsertToServerInt64AttributeMap(), searchAttributeRW.getUpsertToServerStringAttributeMap(), searchAttributeRW.getUpsertToServerBooleanAttributeMap(), searchAttributeRW.getUpsertToServerDoubleAttributeMap(), searchAttributeRW.getUpsertToServerStringArrayAttributeMap())).size() > 0) {
            response.upsertSearchAttributes(upsertSAs);
        }
        if ((interStateChannelPublishing = this.toInterStateChannelPublishing(communication.getToPublishInterStateChannels())).size() > 0) {
            response.publishToInterStateChannel(interStateChannelPublishing);
        }
        return response;
    }

    private List<InterStateChannelPublishing> toInterStateChannelPublishing(Map<String, List<EncodedObject>> toPublish) {
        ArrayList<InterStateChannelPublishing> results = new ArrayList<InterStateChannelPublishing>();
        toPublish.forEach((cname, list) -> list.forEach(val -> {
            InterStateChannelPublishing pub = new InterStateChannelPublishing().channelName((String)cname).value((EncodedObject)val);
            results.add(pub);
        }));
        return results;
    }

    private DataAttributesRWImpl createDataObjectsRW(String workflowType, List<KeyValue> keyValues) {
        Map<String, EncodedObject> map = this.toMap(keyValues);
        return new DataAttributesRWImpl(this.registry.getDataAttributeKeyToTypeMap(workflowType), map, this.workerOptions.getObjectEncoder());
    }

    private Map<String, EncodedObject> toMap(List<KeyValue> keyValues) {
        Map<String, EncodedObject> map = keyValues == null || keyValues.isEmpty() ? new HashMap<String, EncodedObject>() : keyValues.stream().filter(keyValue -> keyValue.getValue() != null).collect(Collectors.toMap(KeyValue::getKey, KeyValue::getValue));
        return map;
    }

    private List<SearchAttribute> createUpsertSearchAttributes(Map<String, SearchAttributeValueType> typeMap, Map<String, Long> upsertToServerInt64AttributeMap, Map<String, String> upsertToServerKeywordAttributeMap, Map<String, Boolean> upsertToServerBoolAttributeMap, Map<String, Double> upsertToServerDoubleAttributeMap, Map<String, List<String>> upsertToServerStringArrayAttributeMap) {
        ArrayList<SearchAttribute> sas = new ArrayList<SearchAttribute>();
        upsertToServerKeywordAttributeMap.forEach((key, sa) -> {
            SearchAttribute attr = new SearchAttribute().key((String)key).stringValue((String)sa).valueType((SearchAttributeValueType)((Object)((Object)typeMap.get(key))));
            sas.add(attr);
        });
        upsertToServerStringArrayAttributeMap.forEach((key, sa) -> {
            SearchAttribute attr = new SearchAttribute().key((String)key).stringArrayValue((List<String>)sa).valueType((SearchAttributeValueType)((Object)((Object)typeMap.get(key))));
            sas.add(attr);
        });
        upsertToServerInt64AttributeMap.forEach((key, sa) -> {
            SearchAttribute attr = new SearchAttribute().key((String)key).integerValue((Long)sa).valueType((SearchAttributeValueType)((Object)((Object)typeMap.get(key))));
            sas.add(attr);
        });
        upsertToServerDoubleAttributeMap.forEach((key, sa) -> {
            SearchAttribute attr = new SearchAttribute().key((String)key).doubleValue((Double)sa).valueType((SearchAttributeValueType)((Object)((Object)typeMap.get(key))));
            sas.add(attr);
        });
        upsertToServerBoolAttributeMap.forEach((key, sa) -> {
            SearchAttribute attr = new SearchAttribute().key((String)key).boolValue((Boolean)sa).valueType((SearchAttributeValueType)((Object)((Object)typeMap.get(key))));
            sas.add(attr);
        });
        return sas;
    }

    private Context fromIdlContext(io.iworkflow.gen.models.Context context) {
        int attempt = -1;
        if (context.getAttempt() != null) {
            attempt = context.getAttempt();
        }
        long firstAttemptTimestamp = -1L;
        if (context.getFirstAttemptTimestamp() != null) {
            firstAttemptTimestamp = context.getFirstAttemptTimestamp();
        }
        return ImmutableContext.builder().workflowId(context.getWorkflowId()).workflowRunId(context.getWorkflowRunId()).workflowStartTimestampSeconds(context.getWorkflowStartedTimestamp()).stateExecutionId(context.getStateExecutionId()).attempt(attempt).firstAttemptTimestampSeconds(firstAttemptTimestamp).build();
    }
}

